/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.terminal.gui.widgets;

import gregtech.api.gui.IRenderContext;
import gregtech.api.gui.Widget;
import gregtech.api.gui.resources.ColorRectTexture;
import gregtech.api.gui.resources.IGuiTexture;
import gregtech.api.gui.resources.TextureArea;
import gregtech.api.util.Position;
import gregtech.api.util.Size;
import java.util.function.Consumer;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.MathHelper;

public class ScrollBarWidget
extends Widget {
    protected final float min;
    protected final float max;
    protected final float dur;
    protected int xOffset;
    protected boolean draggedOnScrollBar;
    protected IGuiTexture background;
    protected IGuiTexture buttonTexture;
    protected int buttonWidth;
    protected int buttonHeight;
    protected Consumer<Float> onChanged;
    protected boolean isClient;

    public ScrollBarWidget(int x, int y, int width, int height, float min, float max, float dur) {
        super(new Position(x, y), new Size(width, height));
        this.max = max;
        this.min = min;
        this.dur = dur;
        this.xOffset = width / 2;
        this.buttonTexture = new ColorRectTexture(-1);
        this.buttonWidth = Math.max((int)((float)width / ((max - min) / dur)), 5);
        this.buttonHeight = height;
    }

    public ScrollBarWidget setOnChanged(Consumer<Float> onChanged, boolean isClient) {
        this.onChanged = onChanged;
        this.isClient = isClient;
        return this;
    }

    public ScrollBarWidget setBackground(IGuiTexture background) {
        this.background = background;
        return this;
    }

    public ScrollBarWidget setInitValue(float value) {
        if (value >= this.min && value <= this.max) {
            this.xOffset = (int)((value - this.min) / (this.max - this.min) * (float)(this.getSize().width - this.buttonWidth));
        }
        return this;
    }

    public ScrollBarWidget setButtonTexture(TextureArea buttonTexture, int buttonWidth, int buttonHeight) {
        this.buttonTexture = buttonTexture;
        this.buttonWidth = buttonWidth;
        this.buttonHeight = buttonHeight;
        return this;
    }

    @Override
    public void drawInBackground(int mouseX, int mouseY, float partialTicks, IRenderContext context) {
        int x = this.getPosition().x;
        int y = this.getPosition().y;
        int width = this.getSize().width;
        int height = this.getSize().height;
        if (this.background != null) {
            this.background.draw(x, y, width, height);
        } else {
            ScrollBarWidget.drawBorder(x - 1, y - 1, width + 2, height + 2, -1, 1);
        }
        if (this.buttonTexture != null) {
            this.buttonTexture.draw(x + this.xOffset, (float)y + (float)(height - this.buttonHeight) / 2.0f, this.buttonWidth, this.buttonHeight);
        }
    }

    private boolean isOnScrollPane(int mouseX, int mouseY) {
        Position position = this.getPosition();
        Size size = this.getSize();
        return ScrollBarWidget.isMouseOver(position.x, position.y, size.width, this.buttonHeight, mouseX, mouseY);
    }

    private float getValue() {
        return (float)((double)this.min + Math.floor((this.max - this.min) * (float)this.xOffset * 1.0f / (float)(this.getSize().width - this.buttonWidth) / this.dur) * (double)this.dur);
    }

    @Override
    public boolean mouseClicked(int mouseX, int mouseY, int button) {
        if (this.isOnScrollPane(mouseX, mouseY)) {
            this.xOffset = MathHelper.func_76125_a((int)(mouseX - this.getPosition().x - this.buttonWidth / 2), (int)0, (int)(this.getSize().width - this.buttonWidth));
            this.draggedOnScrollBar = true;
        }
        return this.isMouseOverElement(mouseX, mouseY);
    }

    @Override
    public boolean mouseDragged(int mouseX, int mouseY, int button, long timeDragged) {
        if (this.draggedOnScrollBar) {
            this.xOffset = MathHelper.func_76125_a((int)(mouseX - this.getPosition().x - this.buttonWidth / 2), (int)0, (int)(this.getSize().width - this.buttonWidth));
            if (this.onChanged != null) {
                this.onChanged.accept(Float.valueOf(this.getValue()));
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean mouseReleased(int mouseX, int mouseY, int button) {
        if (this.draggedOnScrollBar && !this.isClient) {
            this.writeClientAction(2, packetBuffer -> packetBuffer.writeFloat(this.getValue()));
        }
        this.draggedOnScrollBar = false;
        return this.isMouseOverElement(mouseX, mouseY);
    }

    @Override
    public void handleClientAction(int id, PacketBuffer buffer) {
        super.handleClientAction(id, buffer);
        if (id == 2) {
            float value = buffer.readFloat();
            if (this.onChanged != null) {
                this.onChanged.accept(Float.valueOf(value));
            }
        }
    }
}

