/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.recipes.recipeproperties;

import gregtech.api.recipes.recipeproperties.IRecipePropertyStorage;
import gregtech.api.recipes.recipeproperties.RecipeProperty;
import gregtech.api.util.GTLog;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class RecipePropertyStorage
implements IRecipePropertyStorage {
    private final Map<RecipeProperty<?>, Object> recipeProperties = new Object2ObjectArrayMap(1);
    private boolean frozen = false;

    public RecipePropertyStorage() {
    }

    private RecipePropertyStorage(Map<RecipeProperty<?>, Object> recipeProperties) {
        this();
        this.recipeProperties.putAll(recipeProperties);
    }

    @Override
    public boolean store(RecipeProperty<?> recipeProperty, Object value) {
        boolean success = true;
        String key = recipeProperty.getKey();
        if (this.frozen) {
            GTLog.logger.warn("Unable to add RecipeProperty with key {} as the storage is frozen", (Object)key);
            success = false;
        }
        for (RecipeProperty<?> existingRecipeProperty : this.recipeProperties.keySet()) {
            if (!existingRecipeProperty.getKey().equals(key)) continue;
            GTLog.logger.warn("Unable to add RecipeProperty with key {} as it already exists", (Object)key);
            success = false;
        }
        if (value == null) {
            GTLog.logger.warn("Provided value is null for RecipeProperty with key {}", (Object)key);
            success = false;
        }
        try {
            recipeProperty.castValue(value);
        }
        catch (ClassCastException ex) {
            GTLog.logger.warn("Provided incorrect value for RecipeProperty with key {}", (Object)key);
            GTLog.logger.warn("Full exception:", (Throwable)ex);
            success = false;
        }
        if (success) {
            this.recipeProperties.put(recipeProperty, value);
        } else {
            GTLog.logger.warn("Stacktrace:", (Throwable)new IllegalArgumentException());
        }
        return success;
    }

    @Override
    public boolean remove(RecipeProperty<?> recipeProperty) {
        return this.recipeProperties.remove(recipeProperty) != null;
    }

    @Override
    public void freeze(boolean frozen) {
        this.frozen = frozen;
    }

    @Override
    public IRecipePropertyStorage copy() {
        return new RecipePropertyStorage(this.recipeProperties);
    }

    @Override
    public int getSize() {
        return this.recipeProperties.size();
    }

    @Override
    public Set<Map.Entry<RecipeProperty<?>, Object>> getRecipeProperties() {
        return this.recipeProperties.entrySet();
    }

    @Override
    public <T> T getRecipePropertyValue(RecipeProperty<T> recipeProperty, T defaultValue) {
        Object value = this.recipeProperties.get(recipeProperty);
        if (value == null) {
            return defaultValue;
        }
        return recipeProperty.castValue(value);
    }

    @Override
    public boolean hasRecipeProperty(RecipeProperty<?> recipeProperty) {
        return this.recipeProperties.containsKey(recipeProperty);
    }

    @Override
    public Set<String> getRecipePropertyKeys() {
        HashSet<String> keys = new HashSet<String>();
        this.recipeProperties.keySet().forEach(recipeProperty -> keys.add(recipeProperty.getKey()));
        return keys;
    }

    @Override
    public Set<RecipeProperty<?>> getPropertyTypes() {
        return this.recipeProperties.keySet();
    }

    @Override
    public Object getRawRecipePropertyValue(String key) {
        RecipeProperty<?> recipeProperty = this.getRecipePropertyValue(key);
        if (recipeProperty != null) {
            return this.recipeProperties.get(recipeProperty);
        }
        return null;
    }

    private RecipeProperty<?> getRecipePropertyValue(String key) {
        for (RecipeProperty<?> recipeProperty : this.recipeProperties.keySet()) {
            if (!recipeProperty.getKey().equals(key)) continue;
            return recipeProperty;
        }
        return null;
    }
}

