/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.recipes.recipeproperties;

import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class RecipeProperty<T> {
    private final Class<T> type;
    private final String key;

    protected RecipeProperty(String key, Class<T> type) {
        this.key = key;
        this.type = type;
    }

    @SideOnly(value=Side.CLIENT)
    public abstract void drawInfo(Minecraft var1, int var2, int var3, int var4, Object var5);

    @SideOnly(value=Side.CLIENT)
    public void drawInfo(Minecraft minecraft, int x, int y, int color, Object value, int mouseX, int mouseY) {
        this.drawInfo(minecraft, x, y, color, value);
    }

    @SideOnly(value=Side.CLIENT)
    public void getTooltipStrings(List<String> tooltip, int mouseX, int mouseY, Object value) {
    }

    public int getInfoHeight(Object value) {
        return 10;
    }

    public boolean isOfType(Class<?> otherType) {
        return this.type == otherType;
    }

    public String getKey() {
        return this.key;
    }

    public T castValue(Object value) {
        return this.type.cast(value);
    }

    public boolean isHidden() {
        return false;
    }

    public boolean hideTotalEU() {
        return false;
    }

    public boolean hideEUt() {
        return false;
    }

    public boolean hideDuration() {
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RecipeProperty that = (RecipeProperty)o;
        return Objects.equals(this.type, that.type) && Objects.equals(this.key, that.key);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.key);
    }
}

