/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.recipes.machines;

import gregtech.api.recipes.Recipe;
import gregtech.api.recipes.RecipeMap;
import gregtech.api.recipes.builders.SimpleRecipeBuilder;
import gregtech.api.recipes.ingredients.GTRecipeItemInput;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import org.jetbrains.annotations.Nullable;

public class RecipeMapFluidCanner
extends RecipeMap<SimpleRecipeBuilder> {
    public RecipeMapFluidCanner(String unlocalizedName, int maxInputs, int maxOutputs, int maxFluidInputs, int maxFluidOutputs, SimpleRecipeBuilder defaultRecipe, boolean isHidden) {
        super(unlocalizedName, maxInputs, maxOutputs, maxFluidInputs, maxFluidOutputs, defaultRecipe, isHidden);
    }

    @Override
    @Nullable
    public Recipe findRecipe(long voltage, List<ItemStack> inputs, List<FluidStack> fluidInputs, boolean exactVoltage) {
        Recipe recipe = super.findRecipe(voltage, inputs, fluidInputs, exactVoltage);
        if (recipe != null) {
            return recipe;
        }
        for (ItemStack input : inputs) {
            if (input == null || input == ItemStack.field_190927_a || !input.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null)) continue;
            ItemStack inputStack = input.func_77946_l();
            inputStack.func_190920_e(1);
            ItemStack fluidHandlerItemStack = inputStack.func_77946_l();
            IFluidHandlerItem fluidHandlerItem = (IFluidHandlerItem)fluidHandlerItemStack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
            if (fluidHandlerItem == null) {
                return null;
            }
            FluidStack containerFluid = fluidHandlerItem.drain(Integer.MAX_VALUE, true);
            if (containerFluid != null) {
                return ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)this.recipeBuilder()).inputs(new GTRecipeItemInput(inputStack, 1))).outputs(fluidHandlerItem.getContainer())).fluidOutputs(containerFluid)).duration(Math.max(16, containerFluid.amount / 64))).EUt(4)).build().getResult();
            }
            if (fluidInputs.isEmpty()) continue;
            for (FluidStack inputFluid : fluidInputs) {
                if (inputFluid == null) continue;
                inputFluid = inputFluid.copy();
                inputFluid.amount = fluidHandlerItem.fill(inputFluid, true);
                if (inputFluid.amount <= 0) continue;
                return ((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)((SimpleRecipeBuilder)this.recipeBuilder()).inputs(new GTRecipeItemInput(inputStack, 1))).fluidInputs(inputFluid)).outputs(fluidHandlerItem.getContainer())).duration(Math.max(16, inputFluid.amount / 64))).EUt(4)).build().getResult();
            }
        }
        return null;
    }
}

