/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.recipes.chance.output;

import com.google.common.collect.ImmutableList;
import gregtech.api.GTValues;
import gregtech.api.recipes.chance.boost.BoostableChanceEntry;
import gregtech.api.recipes.chance.boost.ChanceBoostFunction;
import gregtech.api.recipes.chance.output.ChancedOutput;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public interface ChancedOutputLogic {
    public static final ChancedOutputLogic OR = new ChancedOutputLogic(){

        @Override
        public <I, T extends ChancedOutput<I>> @Nullable @Unmodifiable List<@NotNull T> roll(@NotNull @NotNull @Unmodifiable List<@NotNull T> chancedEntries, @NotNull ChanceBoostFunction boostFunction, int baseTier, int machineTier) {
            ImmutableList.Builder builder = null;
            for (ChancedOutput entry : chancedEntries) {
                if (!ChancedOutputLogic.passesChance(ChancedOutputLogic.getChance(entry, boostFunction, baseTier, machineTier))) continue;
                if (builder == null) {
                    builder = ImmutableList.builder();
                }
                builder.add((Object)entry);
            }
            return builder == null ? null : builder.build();
        }

        @Override
        @NotNull
        public String getTranslationKey() {
            return "gregtech.chance_logic.or";
        }

        public String toString() {
            return "ChancedOutputLogic{OR}";
        }
    };
    public static final ChancedOutputLogic AND = new ChancedOutputLogic(){

        @Override
        public <I, T extends ChancedOutput<I>> @Nullable @Unmodifiable List<@NotNull T> roll(@NotNull @NotNull @Unmodifiable List<@NotNull T> chancedEntries, @NotNull ChanceBoostFunction boostFunction, int baseTier, int machineTier) {
            for (ChancedOutput entry : chancedEntries) {
                if (ChancedOutputLogic.passesChance(ChancedOutputLogic.getChance(entry, boostFunction, baseTier, machineTier))) continue;
                return null;
            }
            return ImmutableList.copyOf(chancedEntries);
        }

        @Override
        @NotNull
        public String getTranslationKey() {
            return "gregtech.chance_logic.and";
        }

        public String toString() {
            return "ChancedOutputLogic{AND}";
        }
    };
    public static final ChancedOutputLogic XOR = new ChancedOutputLogic(){

        @Override
        public <I, T extends ChancedOutput<I>> @Nullable @Unmodifiable List<@NotNull T> roll(@NotNull @NotNull @Unmodifiable List<@NotNull T> chancedEntries, @NotNull ChanceBoostFunction boostFunction, int baseTier, int machineTier) {
            for (ChancedOutput entry : chancedEntries) {
                if (!ChancedOutputLogic.passesChance(ChancedOutputLogic.getChance(entry, boostFunction, baseTier, machineTier))) continue;
                return Collections.singletonList(entry);
            }
            return null;
        }

        @Override
        @NotNull
        public String getTranslationKey() {
            return "gregtech.chance_logic.xor";
        }

        public String toString() {
            return "ChancedOutputLogic{XOR}";
        }
    };
    public static final ChancedOutputLogic NONE = new ChancedOutputLogic(){

        @Override
        public <I, T extends ChancedOutput<I>> @Nullable @Unmodifiable List<@NotNull T> roll(@NotNull @NotNull @Unmodifiable List<@NotNull T> chancedEntries, @NotNull ChanceBoostFunction boostFunction, int baseTier, int machineTier) {
            return null;
        }

        @Override
        @NotNull
        public String getTranslationKey() {
            return "gregtech.chance_logic.none";
        }

        public String toString() {
            return "ChancedOutputLogic{NONE}";
        }
    };

    public static int getChance(@NotNull ChancedOutput<?> entry, @NotNull ChanceBoostFunction boostFunction, int baseTier, int machineTier) {
        if (entry instanceof BoostableChanceEntry) {
            BoostableChanceEntry boostableChanceEntry = (BoostableChanceEntry)((Object)entry);
            return boostFunction.getBoostedChance(boostableChanceEntry, baseTier, machineTier);
        }
        return entry.getChance();
    }

    public static boolean passesChance(int chance) {
        return chance > 0 && GTValues.RNG.nextInt(ChancedOutputLogic.getMaxChancedValue()) <= chance;
    }

    public static int getMaxChancedValue() {
        return 10000;
    }

    public <I, T extends ChancedOutput<I>> @Nullable @Unmodifiable List<@NotNull T> roll(@NotNull @NotNull @Unmodifiable List<@NotNull T> var1, @NotNull ChanceBoostFunction var2, int var3, int var4);

    @NotNull
    public String getTranslationKey();
}

