/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.recipes.builders;

import gregtech.api.recipes.Recipe;
import gregtech.api.recipes.RecipeBuilder;
import gregtech.api.recipes.RecipeMap;
import gregtech.api.recipes.ingredients.GTRecipeItemInput;
import gregtech.api.recipes.recipeproperties.ImplosionExplosiveProperty;
import gregtech.api.util.EnumValidationResult;
import gregtech.api.util.GTLog;
import gregtech.api.util.ValidationResult;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.jetbrains.annotations.NotNull;
import stanhebben.zenscript.annotations.ZenMethod;

public class ImplosionRecipeBuilder
extends RecipeBuilder<ImplosionRecipeBuilder> {
    public ImplosionRecipeBuilder() {
    }

    public ImplosionRecipeBuilder(Recipe recipe, RecipeMap<ImplosionRecipeBuilder> recipeMap) {
        super(recipe, recipeMap);
    }

    public ImplosionRecipeBuilder(RecipeBuilder<ImplosionRecipeBuilder> recipeBuilder) {
        super(recipeBuilder);
    }

    @Override
    public ImplosionRecipeBuilder copy() {
        return new ImplosionRecipeBuilder(this);
    }

    @Override
    public boolean applyProperty(@NotNull String key, Object value) {
        if (key.equals("explosives")) {
            if (value instanceof ItemStack) {
                this.applyProperty(ImplosionExplosiveProperty.getInstance(), value);
            } else {
                this.applyProperty(ImplosionExplosiveProperty.getInstance(), (Object)new ItemStack(Blocks.field_150335_W, ((Integer)value).intValue()));
            }
            return true;
        }
        return super.applyProperty(key, value);
    }

    @ZenMethod
    public ImplosionRecipeBuilder explosivesAmount(int explosivesAmount) {
        if (1 > explosivesAmount || explosivesAmount > 64) {
            GTLog.logger.error("Amount of explosives should be from 1 to 64 inclusive", (Throwable)new IllegalArgumentException());
            this.recipeStatus = EnumValidationResult.INVALID;
        }
        this.applyProperty(ImplosionExplosiveProperty.getInstance(), (Object)new ItemStack(Blocks.field_150335_W, explosivesAmount));
        return this;
    }

    @ZenMethod
    public ImplosionRecipeBuilder explosivesType(ItemStack explosivesType) {
        if (1 > explosivesType.func_190916_E() || explosivesType.func_190916_E() > 64) {
            GTLog.logger.error("Amount of explosives should be from 1 to 64 inclusive", (Throwable)new IllegalArgumentException());
            this.recipeStatus = EnumValidationResult.INVALID;
        }
        this.applyProperty(ImplosionExplosiveProperty.getInstance(), (Object)explosivesType);
        return this;
    }

    public ItemStack getExplosivesType() {
        if (this.recipePropertyStorage == null) {
            return ItemStack.field_190927_a;
        }
        return this.recipePropertyStorage.getRecipePropertyValue(ImplosionExplosiveProperty.getInstance(), ItemStack.field_190927_a);
    }

    @Override
    public ValidationResult<Recipe> build() {
        ItemStack explosivesType = this.getExplosivesType();
        if (!explosivesType.func_190926_b()) {
            this.inputs.add(new GTRecipeItemInput(explosivesType));
        } else {
            this.recipePropertyStorageErrored = true;
        }
        return super.build();
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this).appendSuper(super.toString()).append(ImplosionExplosiveProperty.getInstance().getKey(), (Object)this.getExplosivesType()).toString();
    }
}

