/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.pipenet.longdist;

import gregtech.api.pipenet.longdist.ILDEndpoint;
import gregtech.api.pipenet.longdist.ILDNetworkPart;
import gregtech.api.pipenet.longdist.LongDistanceNetwork;
import gregtech.common.pipelike.fluidpipe.longdistance.LDFluidPipeType;
import gregtech.common.pipelike.itempipe.longdistance.LDItemPipeType;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Objects;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;

public abstract class LongDistancePipeType {
    private static final Object2ObjectOpenHashMap<String, LongDistancePipeType> PIPE_TYPES = new Object2ObjectOpenHashMap();
    private final String name;

    protected LongDistancePipeType(String name) {
        this.name = Objects.requireNonNull(name);
        if (PIPE_TYPES.containsKey((Object)name)) {
            throw new IllegalArgumentException("Pipe Type with name " + name + " already exists!");
        }
        for (LongDistancePipeType pipeType : PIPE_TYPES.values()) {
            if (this.getClass() != pipeType.getClass()) continue;
            throw new IllegalStateException("Duplicate Pipe Type " + name + " and " + pipeType.name);
        }
        PIPE_TYPES.put((Object)name, (Object)this);
    }

    public static LDFluidPipeType fluid() {
        return LDFluidPipeType.INSTANCE;
    }

    public static LDItemPipeType item() {
        return LDItemPipeType.INSTANCE;
    }

    public static LongDistancePipeType getPipeType(String name) {
        return (LongDistancePipeType)PIPE_TYPES.get((Object)name);
    }

    public boolean isValidPart(ILDNetworkPart networkPart) {
        return networkPart != null && networkPart.getPipeType() == this;
    }

    public int getMinLength() {
        return 0;
    }

    public boolean satisfiesMinLength(ILDEndpoint endpoint1, ILDEndpoint endpoint2) {
        BlockPos p = endpoint2.pos();
        return endpoint1 != endpoint2 && endpoint1.pos().func_185332_f(p.func_177958_n(), p.func_177956_o(), p.func_177952_p()) >= (double)this.getMinLength();
    }

    @NotNull
    public LongDistanceNetwork createNetwork(LongDistanceNetwork.WorldData worldData) {
        return new LongDistanceNetwork(this, worldData);
    }

    public final LongDistanceNetwork createNetwork(World world) {
        return this.createNetwork(LongDistanceNetwork.WorldData.get(world));
    }

    public final String getName() {
        return this.name;
    }
}

