/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.pipenet;

import gregtech.api.pipenet.tile.IPipeTile;
import gregtech.api.util.GTLog;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import org.jetbrains.annotations.Nullable;

public abstract class PipeNetWalker<T extends IPipeTile<?, ?>> {
    protected PipeNetWalker<T> root;
    private final World world;
    private Set<T> walked;
    private final List<EnumFacing> nextPipeFacings = new ArrayList<EnumFacing>(5);
    private final List<T> nextPipes = new ArrayList<T>(5);
    private List<PipeNetWalker<T>> walkers;
    private final BlockPos.MutableBlockPos currentPos;
    private T currentPipe;
    private EnumFacing from = null;
    private int walkedBlocks;
    private boolean invalid;
    private boolean running;
    private boolean failed = false;

    protected PipeNetWalker(World world, BlockPos sourcePipe, int walkedBlocks) {
        this.world = Objects.requireNonNull(world);
        this.walkedBlocks = walkedBlocks;
        this.currentPos = new BlockPos.MutableBlockPos(Objects.requireNonNull(sourcePipe));
        this.root = this;
    }

    protected abstract PipeNetWalker<T> createSubWalker(World var1, EnumFacing var2, BlockPos var3, int var4);

    protected abstract void checkPipe(T var1, BlockPos var2);

    protected abstract void checkNeighbour(T var1, BlockPos var2, EnumFacing var3, @Nullable TileEntity var4);

    protected boolean isValidPipe(T currentPipe, T neighbourPipe, BlockPos pipePos, EnumFacing faceToNeighbour) {
        return true;
    }

    protected abstract Class<T> getBasePipeClass();

    protected EnumFacing[] getSurroundingPipeSides() {
        return EnumFacing.field_82609_l;
    }

    protected void onRemoveSubWalker(PipeNetWalker<T> subWalker) {
    }

    public void traversePipeNet() {
        this.traversePipeNet(32768);
    }

    public void traversePipeNet(int maxWalks) {
        if (this.invalid) {
            throw new IllegalStateException("This walker already walked. Create a new one if you want to walk again");
        }
        this.root = this;
        this.walked = new ObjectOpenHashSet();
        int i = 0;
        this.running = true;
        while (this.running && !this.walk() && i++ < maxWalks) {
        }
        this.running = false;
        this.walked = null;
        if (i >= maxWalks) {
            GTLog.logger.fatal("The walker reached the maximum amount of walks {}", (Object)i);
        }
        this.invalid = true;
    }

    private boolean walk() {
        if (this.walkers == null) {
            if (!this.checkPos()) {
                this.root.failed = true;
                return true;
            }
            if (this.nextPipeFacings.isEmpty()) {
                return true;
            }
            if (this.nextPipeFacings.size() == 1) {
                this.currentPos.func_189533_g((Vec3i)((IPipeTile)this.nextPipes.get(0)).getPipePos());
                this.currentPipe = (IPipeTile)this.nextPipes.get(0);
                this.from = this.nextPipeFacings.get(0).func_176734_d();
                ++this.walkedBlocks;
                return !this.isRunning();
            }
            this.walkers = new ArrayList<PipeNetWalker<T>>();
            for (int i = 0; i < this.nextPipeFacings.size(); ++i) {
                EnumFacing side = this.nextPipeFacings.get(i);
                PipeNetWalker<T> walker = Objects.requireNonNull(this.createSubWalker(this.world, side, this.currentPos.func_177972_a(side), this.walkedBlocks + 1), "Walker can't be null");
                walker.root = this.root;
                walker.currentPipe = (IPipeTile)this.nextPipes.get(i);
                walker.from = side.func_176734_d();
                this.walkers.add(walker);
            }
        }
        Iterator<PipeNetWalker<T>> iterator = this.walkers.iterator();
        while (iterator.hasNext()) {
            PipeNetWalker<T> walker = iterator.next();
            if (!super.walk()) continue;
            this.onRemoveSubWalker(walker);
            iterator.remove();
        }
        return !this.isRunning() || this.walkers.isEmpty();
    }

    private boolean checkPos() {
        this.nextPipeFacings.clear();
        this.nextPipes.clear();
        if (this.currentPipe == null) {
            TileEntity thisPipe = this.world.func_175625_s((BlockPos)this.currentPos);
            if (!(thisPipe instanceof IPipeTile)) {
                GTLog.logger.fatal("PipeWalker expected a pipe, but found {} at {}", (Object)thisPipe, (Object)this.currentPos);
                return false;
            }
            if (!this.getBasePipeClass().isAssignableFrom(thisPipe.getClass())) {
                return false;
            }
            this.currentPipe = (IPipeTile)thisPipe;
        }
        T pipeTile = this.currentPipe;
        this.checkPipe(pipeTile, (BlockPos)this.currentPos);
        this.root.walked.add(pipeTile);
        for (EnumFacing accessSide : this.getSurroundingPipeSides()) {
            if (accessSide == this.from || !pipeTile.isConnected(accessSide)) continue;
            TileEntity tile = pipeTile.getNeighbor(accessSide);
            if (tile != null && this.getBasePipeClass().isAssignableFrom(tile.getClass())) {
                IPipeTile otherPipe = (IPipeTile)tile;
                if (!otherPipe.isConnected(accessSide.func_176734_d()) || otherPipe.isFaceBlocked(accessSide.func_176734_d()) || this.isWalked(otherPipe)) continue;
                if (this.isValidPipe(pipeTile, otherPipe, (BlockPos)this.currentPos, accessSide)) {
                    this.nextPipeFacings.add(accessSide);
                    this.nextPipes.add(otherPipe);
                    continue;
                }
            }
            this.checkNeighbour(pipeTile, (BlockPos)this.currentPos, accessSide, tile);
        }
        return true;
    }

    protected boolean isWalked(T pipe) {
        return this.root.walked.contains(pipe);
    }

    public void stop() {
        this.root.running = false;
    }

    public boolean isRunning() {
        return this.root.running;
    }

    public World getWorld() {
        return this.world;
    }

    public BlockPos getCurrentPos() {
        return this.currentPos;
    }

    public int getWalkedBlocks() {
        return this.walkedBlocks;
    }

    public boolean isRoot() {
        return this.root == this;
    }

    public boolean isFailed() {
        return this.failed;
    }
}

