/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.metatileentity;

import codechicken.lib.raytracer.CuboidRayTraceResult;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Matrix4;
import gregtech.api.GTValues;
import gregtech.api.capability.GregtechDataCodes;
import gregtech.api.capability.GregtechTileCapabilities;
import gregtech.api.capability.IActiveOutputSide;
import gregtech.api.capability.IGhostSlotConfigurable;
import gregtech.api.capability.impl.EnergyContainerHandler;
import gregtech.api.capability.impl.FluidHandlerProxy;
import gregtech.api.capability.impl.FluidTankList;
import gregtech.api.capability.impl.GhostCircuitItemStackHandler;
import gregtech.api.capability.impl.ItemHandlerList;
import gregtech.api.capability.impl.ItemHandlerProxy;
import gregtech.api.cover.Cover;
import gregtech.api.gui.GuiTextures;
import gregtech.api.gui.ModularUI;
import gregtech.api.gui.resources.TextureArea;
import gregtech.api.gui.widgets.CycleButtonWidget;
import gregtech.api.gui.widgets.GhostCircuitSlotWidget;
import gregtech.api.gui.widgets.ImageWidget;
import gregtech.api.gui.widgets.LabelWidget;
import gregtech.api.gui.widgets.SlotWidget;
import gregtech.api.gui.widgets.ToggleButtonWidget;
import gregtech.api.items.itemhandlers.GTItemStackHandler;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.WorkableTieredMetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.recipes.RecipeMap;
import gregtech.api.util.GTTransferUtils;
import gregtech.api.util.GTUtility;
import gregtech.client.particle.IMachineParticleEffect;
import gregtech.client.renderer.ICubeRenderer;
import gregtech.client.renderer.texture.Textures;
import gregtech.client.utils.RenderUtil;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SimpleMachineMetaTileEntity
extends WorkableTieredMetaTileEntity
implements IActiveOutputSide,
IGhostSlotConfigurable {
    private final boolean hasFrontFacing;
    protected final GTItemStackHandler chargerInventory;
    @Nullable
    protected GhostCircuitItemStackHandler circuitInventory;
    private EnumFacing outputFacingItems;
    private EnumFacing outputFacingFluids;
    private boolean autoOutputItems;
    private boolean autoOutputFluids;
    private boolean allowInputFromOutputSideItems = false;
    private boolean allowInputFromOutputSideFluids = false;
    protected IItemHandler outputItemInventory;
    protected IFluidHandler outputFluidInventory;
    private IItemHandlerModifiable actualImportItems;
    private static final int FONT_HEIGHT = 9;
    @Nullable
    protected final IMachineParticleEffect tickingParticle;
    @Nullable
    protected final IMachineParticleEffect randomParticle;

    public SimpleMachineMetaTileEntity(ResourceLocation metaTileEntityId, RecipeMap<?> recipeMap, ICubeRenderer renderer, int tier, boolean hasFrontFacing) {
        this(metaTileEntityId, recipeMap, renderer, tier, hasFrontFacing, GTUtility.defaultTankSizeFunction);
    }

    public SimpleMachineMetaTileEntity(ResourceLocation metaTileEntityId, RecipeMap<?> recipeMap, ICubeRenderer renderer, int tier, boolean hasFrontFacing, Function<Integer, Integer> tankScalingFunction) {
        this(metaTileEntityId, recipeMap, renderer, tier, hasFrontFacing, tankScalingFunction, null, null);
    }

    public SimpleMachineMetaTileEntity(ResourceLocation metaTileEntityId, RecipeMap<?> recipeMap, ICubeRenderer renderer, int tier, boolean hasFrontFacing, Function<Integer, Integer> tankScalingFunction, @Nullable IMachineParticleEffect tickingParticle, @Nullable IMachineParticleEffect randomParticle) {
        super(metaTileEntityId, recipeMap, renderer, tier, tankScalingFunction);
        this.hasFrontFacing = hasFrontFacing;
        this.chargerInventory = new GTItemStackHandler((MetaTileEntity)this, 1);
        this.tickingParticle = tickingParticle;
        this.randomParticle = randomParticle;
    }

    @Override
    public MetaTileEntity createMetaTileEntity(IGregTechTileEntity tileEntity) {
        return new SimpleMachineMetaTileEntity(this.metaTileEntityId, this.workable.getRecipeMap(), this.renderer, this.getTier(), this.hasFrontFacing, this.getTankScalingFunction(), this.tickingParticle, this.randomParticle);
    }

    @Override
    protected void initializeInventory() {
        super.initializeInventory();
        this.outputItemInventory = new ItemHandlerProxy((IItemHandler)new GTItemStackHandler((MetaTileEntity)this, 0), (IItemHandler)this.exportItems);
        this.outputFluidInventory = new FluidHandlerProxy(new FluidTankList(false, new IFluidTank[0]), this.exportFluids);
        if (this.hasGhostCircuitInventory()) {
            this.circuitInventory = new GhostCircuitItemStackHandler(this);
            this.circuitInventory.addNotifiableMetaTileEntity(this);
        }
        this.actualImportItems = null;
    }

    @Override
    public IItemHandlerModifiable getImportItems() {
        if (this.actualImportItems == null) {
            this.actualImportItems = this.circuitInventory == null ? super.getImportItems() : new ItemHandlerList(Arrays.asList(super.getImportItems(), this.circuitInventory));
        }
        return this.actualImportItems;
    }

    @Override
    public boolean hasFrontFacing() {
        return this.hasFrontFacing;
    }

    @Override
    public boolean onWrenchClick(EntityPlayer playerIn, EnumHand hand, EnumFacing facing, CuboidRayTraceResult hitResult) {
        if (!playerIn.func_70093_af()) {
            if (this.getOutputFacing() == facing) {
                return false;
            }
            if (this.hasFrontFacing() && facing == this.getFrontFacing()) {
                return false;
            }
            if (!this.getWorld().field_72995_K) {
                this.setOutputFacing(facing);
            }
            return true;
        }
        return super.onWrenchClick(playerIn, hand, facing, hitResult);
    }

    @Override
    public void addCover(@NotNull EnumFacing side, @NotNull Cover cover) {
        super.addCover(side, cover);
        if (cover.canInteractWithOutputSide()) {
            if (this.getOutputFacingItems() == side) {
                this.setAllowInputFromOutputSideItems(true);
            }
            if (this.getOutputFacingFluids() == side) {
                this.setAllowInputFromOutputSideFluids(true);
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderMetaTileEntity(CCRenderState renderState, Matrix4 translation, IVertexOperation[] pipeline) {
        super.renderMetaTileEntity(renderState, translation, pipeline);
        if (this.outputFacingFluids != null && this.getExportFluids().getTanks() > 0) {
            Textures.PIPE_OUT_OVERLAY.renderSided(this.outputFacingFluids, renderState, RenderUtil.adjustTrans(translation, this.outputFacingFluids, 2), pipeline);
        }
        if (this.outputFacingItems != null && this.getExportItems().getSlots() > 0) {
            Textures.PIPE_OUT_OVERLAY.renderSided(this.outputFacingItems, renderState, RenderUtil.adjustTrans(translation, this.outputFacingItems, 2), pipeline);
        }
        if (this.isAutoOutputItems() && this.outputFacingItems != null) {
            Textures.ITEM_OUTPUT_OVERLAY.renderSided(this.outputFacingItems, renderState, RenderUtil.adjustTrans(translation, this.outputFacingItems, 2), pipeline);
        }
        if (this.isAutoOutputFluids() && this.outputFacingFluids != null) {
            Textures.FLUID_OUTPUT_OVERLAY.renderSided(this.outputFacingFluids, renderState, RenderUtil.adjustTrans(translation, this.outputFacingFluids, 2), pipeline);
        }
    }

    @Override
    public void update() {
        super.update();
        if (!this.getWorld().field_72995_K) {
            ((EnergyContainerHandler)this.energyContainer).dischargeOrRechargeEnergyContainers((IItemHandlerModifiable)this.chargerInventory, 0);
            if (this.getOffsetTimer() % 5L == 0L) {
                if (this.isAutoOutputFluids()) {
                    this.pushFluidsIntoNearbyHandlers(this.getOutputFacingFluids());
                }
                if (this.isAutoOutputItems()) {
                    this.pushItemsIntoNearbyHandlers(this.getOutputFacingItems());
                }
            }
        } else if (this.tickingParticle != null && this.isActive()) {
            this.tickingParticle.runEffect(this);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void randomDisplayTick() {
        if (this.randomParticle != null && this.isActive()) {
            this.randomParticle.runEffect(this);
        }
    }

    @Override
    public boolean onScrewdriverClick(EntityPlayer playerIn, EnumHand hand, EnumFacing facing, CuboidRayTraceResult hitResult) {
        if (!this.getWorld().field_72995_K) {
            if (this.isAllowInputFromOutputSideItems()) {
                this.setAllowInputFromOutputSideItems(false);
                this.setAllowInputFromOutputSideFluids(false);
                playerIn.func_146105_b((ITextComponent)new TextComponentTranslation("gregtech.machine.basic.input_from_output_side.disallow", new Object[0]), true);
            } else {
                this.setAllowInputFromOutputSideItems(true);
                this.setAllowInputFromOutputSideFluids(true);
                playerIn.func_146105_b((ITextComponent)new TextComponentTranslation("gregtech.machine.basic.input_from_output_side.allow", new Object[0]), true);
            }
        }
        return true;
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing side) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            IFluidHandler fluidHandler;
            IFluidHandler iFluidHandler = fluidHandler = side == this.getOutputFacingFluids() && !this.isAllowInputFromOutputSideFluids() ? this.outputFluidInventory : this.fluidInventory;
            if (fluidHandler.getTankProperties().length > 0) {
                return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)fluidHandler);
            }
            return null;
        }
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            IItemHandler itemHandler;
            IItemHandler iItemHandler = itemHandler = side == this.getOutputFacingItems() && !this.isAllowInputFromOutputSideFluids() ? this.outputItemInventory : this.itemInventory;
            if (itemHandler.getSlots() > 0) {
                return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)itemHandler);
            }
            return null;
        }
        if (capability == GregtechTileCapabilities.CAPABILITY_ACTIVE_OUTPUT_SIDE) {
            if (side == this.getOutputFacingItems() || side == this.getOutputFacingFluids()) {
                return (T)GregtechTileCapabilities.CAPABILITY_ACTIVE_OUTPUT_SIDE.cast((Object)this);
            }
            return null;
        }
        return super.getCapability(capability, side);
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        data.func_74782_a("ChargerInventory", (NBTBase)this.chargerInventory.serializeNBT());
        if (this.circuitInventory != null) {
            this.circuitInventory.write(data);
        }
        data.func_74768_a("OutputFacing", this.getOutputFacingItems().func_176745_a());
        data.func_74768_a("OutputFacingF", this.getOutputFacingFluids().func_176745_a());
        data.func_74757_a("AutoOutputItems", this.autoOutputItems);
        data.func_74757_a("AutoOutputFluids", this.autoOutputFluids);
        data.func_74757_a("AllowInputFromOutputSide", this.allowInputFromOutputSideItems);
        data.func_74757_a("AllowInputFromOutputSideF", this.allowInputFromOutputSideFluids);
        return data;
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.chargerInventory.deserializeNBT(data.func_74775_l("ChargerInventory"));
        if (this.circuitInventory != null) {
            if (data.func_150297_b("CircuitInventory", 10)) {
                ItemStackHandler legacyCircuitInventory = new ItemStackHandler();
                legacyCircuitInventory.deserializeNBT(data.func_74775_l("CircuitInventory"));
                for (int i = 0; i < legacyCircuitInventory.getSlots(); ++i) {
                    ItemStack stack = legacyCircuitInventory.getStackInSlot(i);
                    if (stack.func_190926_b()) continue;
                    stack = GTTransferUtils.insertItem((IItemHandler)this.importItems, stack, false);
                    this.circuitInventory.setCircuitValueFromStack(stack);
                }
            } else {
                this.circuitInventory.read(data);
            }
        }
        this.outputFacingItems = EnumFacing.field_82609_l[data.func_74762_e("OutputFacing")];
        this.outputFacingFluids = EnumFacing.field_82609_l[data.func_74762_e("OutputFacingF")];
        this.autoOutputItems = data.func_74767_n("AutoOutputItems");
        this.autoOutputFluids = data.func_74767_n("AutoOutputFluids");
        this.allowInputFromOutputSideItems = data.func_74767_n("AllowInputFromOutputSide");
        this.allowInputFromOutputSideFluids = data.func_74767_n("AllowInputFromOutputSideF");
    }

    @Override
    public void writeInitialSyncData(PacketBuffer buf) {
        super.writeInitialSyncData(buf);
        buf.writeByte(this.getOutputFacingItems().func_176745_a());
        buf.writeByte(this.getOutputFacingFluids().func_176745_a());
        buf.writeBoolean(this.autoOutputItems);
        buf.writeBoolean(this.autoOutputFluids);
    }

    @Override
    public void receiveInitialSyncData(PacketBuffer buf) {
        super.receiveInitialSyncData(buf);
        this.outputFacingItems = EnumFacing.field_82609_l[buf.readByte()];
        this.outputFacingFluids = EnumFacing.field_82609_l[buf.readByte()];
        this.autoOutputItems = buf.readBoolean();
        this.autoOutputFluids = buf.readBoolean();
    }

    @Override
    public void receiveCustomData(int dataId, PacketBuffer buf) {
        super.receiveCustomData(dataId, buf);
        if (dataId == GregtechDataCodes.UPDATE_OUTPUT_FACING) {
            this.outputFacingItems = EnumFacing.field_82609_l[buf.readByte()];
            this.outputFacingFluids = EnumFacing.field_82609_l[buf.readByte()];
            this.scheduleRenderUpdate();
        } else if (dataId == GregtechDataCodes.UPDATE_AUTO_OUTPUT_ITEMS) {
            this.autoOutputItems = buf.readBoolean();
            this.scheduleRenderUpdate();
        } else if (dataId == GregtechDataCodes.UPDATE_AUTO_OUTPUT_FLUIDS) {
            this.autoOutputFluids = buf.readBoolean();
            this.scheduleRenderUpdate();
        }
    }

    @Override
    public boolean isValidFrontFacing(EnumFacing facing) {
        return super.isValidFrontFacing(facing) && facing != this.outputFacingItems && facing != this.outputFacingFluids;
    }

    @Deprecated
    public void setOutputFacing(EnumFacing outputFacing) {
        this.outputFacingItems = outputFacing;
        this.outputFacingFluids = outputFacing;
        if (!this.getWorld().field_72995_K) {
            this.notifyBlockUpdate();
            this.writeCustomData(GregtechDataCodes.UPDATE_OUTPUT_FACING, buf -> {
                buf.writeByte(this.outputFacingItems.func_176745_a());
                buf.writeByte(this.outputFacingFluids.func_176745_a());
            });
            this.markDirty();
        }
    }

    public void setOutputFacingItems(EnumFacing outputFacing) {
        this.outputFacingItems = outputFacing;
        if (!this.getWorld().field_72995_K) {
            this.notifyBlockUpdate();
            this.writeCustomData(GregtechDataCodes.UPDATE_OUTPUT_FACING, buf -> {
                buf.writeByte(this.outputFacingItems.func_176745_a());
                buf.writeByte(this.outputFacingFluids.func_176745_a());
            });
            this.markDirty();
        }
    }

    public void setOutputFacingFluids(EnumFacing outputFacing) {
        this.outputFacingFluids = outputFacing;
        if (!this.getWorld().field_72995_K) {
            this.notifyBlockUpdate();
            this.writeCustomData(GregtechDataCodes.UPDATE_OUTPUT_FACING, buf -> {
                buf.writeByte(this.outputFacingItems.func_176745_a());
                buf.writeByte(this.outputFacingFluids.func_176745_a());
            });
            this.markDirty();
        }
    }

    public void setAutoOutputItems(boolean autoOutputItems) {
        this.autoOutputItems = autoOutputItems;
        if (!this.getWorld().field_72995_K) {
            this.writeCustomData(GregtechDataCodes.UPDATE_AUTO_OUTPUT_ITEMS, buf -> buf.writeBoolean(autoOutputItems));
            this.markDirty();
        }
    }

    public void setAutoOutputFluids(boolean autoOutputFluids) {
        this.autoOutputFluids = autoOutputFluids;
        if (!this.getWorld().field_72995_K) {
            this.writeCustomData(GregtechDataCodes.UPDATE_AUTO_OUTPUT_FLUIDS, buf -> buf.writeBoolean(autoOutputFluids));
            this.markDirty();
        }
    }

    public void setAllowInputFromOutputSideItems(boolean allowInputFromOutputSide) {
        this.allowInputFromOutputSideItems = allowInputFromOutputSide;
        if (!this.getWorld().field_72995_K) {
            this.markDirty();
        }
    }

    public void setAllowInputFromOutputSideFluids(boolean allowInputFromOutputSide) {
        this.allowInputFromOutputSideFluids = allowInputFromOutputSide;
        if (!this.getWorld().field_72995_K) {
            this.markDirty();
        }
    }

    @Override
    public void setGhostCircuitConfig(int config) {
        if (this.circuitInventory == null || this.circuitInventory.getCircuitValue() == config) {
            return;
        }
        this.circuitInventory.setCircuitValue(config);
        if (!this.getWorld().field_72995_K) {
            this.markDirty();
        }
    }

    @Override
    public void setFrontFacing(EnumFacing frontFacing) {
        super.setFrontFacing(frontFacing);
        if (this.outputFacingItems == null || this.outputFacingFluids == null) {
            this.setOutputFacing(frontFacing.func_176734_d());
        }
    }

    @Deprecated
    public EnumFacing getOutputFacing() {
        return this.getOutputFacingItems();
    }

    public EnumFacing getOutputFacingItems() {
        return this.outputFacingItems == null ? EnumFacing.SOUTH : this.outputFacingItems;
    }

    public EnumFacing getOutputFacingFluids() {
        return this.outputFacingFluids == null ? EnumFacing.SOUTH : this.outputFacingFluids;
    }

    @Override
    public boolean isAutoOutputItems() {
        return this.autoOutputItems;
    }

    @Override
    public boolean isAutoOutputFluids() {
        return this.autoOutputFluids;
    }

    @Override
    public boolean isAllowInputFromOutputSideItems() {
        return this.allowInputFromOutputSideItems;
    }

    @Override
    public boolean isAllowInputFromOutputSideFluids() {
        return this.allowInputFromOutputSideFluids;
    }

    @Override
    public void clearMachineInventory(NonNullList<ItemStack> itemBuffer) {
        super.clearMachineInventory(itemBuffer);
        SimpleMachineMetaTileEntity.clearInventory(itemBuffer, (IItemHandlerModifiable)this.chargerInventory);
    }

    protected ModularUI.Builder createGuiTemplate(EntityPlayer player) {
        RecipeMap<?> workableRecipeMap = this.workable.getRecipeMap();
        int yOffset = 0;
        if (workableRecipeMap.getMaxInputs() >= 6 || workableRecipeMap.getMaxFluidInputs() >= 6 || workableRecipeMap.getMaxOutputs() >= 6 || workableRecipeMap.getMaxFluidOutputs() >= 6) {
            yOffset = 9;
        }
        ModularUI.Builder builder = workableRecipeMap.createUITemplate(this.workable::getProgressPercent, this.importItems, this.exportItems, this.importFluids, this.exportFluids, yOffset).widget(new LabelWidget(5, 5, this.getMetaFullName(), new Object[0])).widget(new SlotWidget((IItemHandler)this.chargerInventory, 0, 79, 62 + yOffset, true, true, false).setBackgroundTexture(GuiTextures.SLOT, GuiTextures.CHARGER_OVERLAY).setTooltipText("gregtech.gui.charger_slot.tooltip", GTValues.VNF[this.getTier()], GTValues.VNF[this.getTier()])).widget(new ImageWidget(79, 42 + yOffset, 18, 18, GuiTextures.INDICATOR_NO_ENERGY).setIgnoreColor(true).setPredicate(this.workable::isHasNotEnoughEnergy)).bindPlayerInventory(player.field_71071_by, GuiTextures.SLOT, yOffset);
        int leftButtonStartX = 7;
        if (this.exportItems.getSlots() > 0) {
            builder.widget(new ToggleButtonWidget(leftButtonStartX, 62 + yOffset, 18, 18, GuiTextures.BUTTON_ITEM_OUTPUT, this::isAutoOutputItems, this::setAutoOutputItems).setTooltipText("gregtech.gui.item_auto_output.tooltip", new Object[0]).shouldUseBaseBackground());
            leftButtonStartX += 18;
        }
        if (this.exportFluids.getTanks() > 0) {
            builder.widget(new ToggleButtonWidget(leftButtonStartX, 62 + yOffset, 18, 18, GuiTextures.BUTTON_FLUID_OUTPUT, this::isAutoOutputFluids, this::setAutoOutputFluids).setTooltipText("gregtech.gui.fluid_auto_output.tooltip", new Object[0]).shouldUseBaseBackground());
            leftButtonStartX += 18;
        }
        builder.widget(new CycleButtonWidget(leftButtonStartX, 62 + yOffset, 18, 18, this.workable.getAvailableOverclockingTiers(), this.workable::getOverclockTier, this.workable::setOverclockTier).setTooltipHoverString("gregtech.gui.overclock.description").setButtonTexture(GuiTextures.BUTTON_OVERCLOCK));
        if (this.exportItems.getSlots() + this.exportFluids.getTanks() <= 9) {
            ImageWidget logo = new ImageWidget(152, 63 + yOffset, 17, 17, GTValues.XMAS.get() != false ? GuiTextures.GREGTECH_LOGO_XMAS : GuiTextures.GREGTECH_LOGO).setIgnoreColor(true);
            if (this.circuitInventory != null) {
                SlotWidget circuitSlot = new GhostCircuitSlotWidget(this.circuitInventory, 0, 124, 62 + yOffset).setBackgroundTexture(GuiTextures.SLOT, this.getCircuitSlotOverlay());
                builder.widget(circuitSlot.setConsumer(this::getCircuitSlotTooltip)).widget(logo);
            }
        }
        return builder;
    }

    @Override
    public boolean hasGhostCircuitInventory() {
        return true;
    }

    protected TextureArea getCircuitSlotOverlay() {
        return GuiTextures.INT_CIRCUIT_OVERLAY;
    }

    protected void getCircuitSlotTooltip(SlotWidget widget) {
        String configString = this.circuitInventory == null || this.circuitInventory.getCircuitValue() == -1 ? new TextComponentTranslation("gregtech.gui.configurator_slot.no_value", new Object[0]).func_150254_d() : String.valueOf(this.circuitInventory.getCircuitValue());
        widget.setTooltipText("gregtech.gui.configurator_slot.tooltip", configString);
    }

    @Override
    protected ModularUI createUI(EntityPlayer entityPlayer) {
        return this.createGuiTemplate(entityPlayer).build(this.getHolder(), entityPlayer);
    }

    @Override
    public void addInformation(ItemStack stack, @Nullable World player, List<String> tooltip, boolean advanced) {
        super.addInformation(stack, player, tooltip, advanced);
        String key = this.metaTileEntityId.func_110623_a().split("\\.")[0];
        String mainKey = String.format("gregtech.machine.%s.tooltip", key);
        if (I18n.func_188566_a((String)mainKey)) {
            tooltip.add(1, mainKey);
        }
    }

    @Override
    public boolean needsSneakToRotate() {
        return true;
    }

    @Override
    public void addToolUsages(ItemStack stack, @Nullable World world, List<String> tooltip, boolean advanced) {
        tooltip.add(I18n.func_135052_a((String)"gregtech.tool_action.screwdriver.auto_output_covers", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"gregtech.tool_action.wrench.set_facing", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"gregtech.tool_action.soft_mallet.reset", (Object[])new Object[0]));
        super.addToolUsages(stack, world, tooltip, advanced);
    }
}

