/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.metatileentity;

import gregtech.api.metatileentity.SyncedTileEntityBase;
import gregtech.api.metatileentity.interfaces.INeighborCache;
import java.util.Arrays;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.jetbrains.annotations.MustBeInvokedByOverriders;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class NeighborCacheTileEntityBase
extends SyncedTileEntityBase
implements INeighborCache {
    private final TileEntity[] neighbors = new TileEntity[6];
    private boolean neighborsInvalidated = false;

    public NeighborCacheTileEntityBase() {
        this.invalidateNeighbors();
    }

    protected void invalidateNeighbors() {
        if (!this.neighborsInvalidated) {
            Arrays.fill(this.neighbors, this);
            this.neighborsInvalidated = true;
        }
    }

    @MustBeInvokedByOverriders
    public void func_145834_a(@NotNull World worldIn) {
        super.func_145834_a(worldIn);
        this.invalidateNeighbors();
    }

    @MustBeInvokedByOverriders
    public void func_174878_a(@NotNull BlockPos posIn) {
        super.func_174878_a(posIn);
        this.invalidateNeighbors();
    }

    @MustBeInvokedByOverriders
    public void func_145843_s() {
        super.func_145843_s();
        this.invalidateNeighbors();
    }

    @MustBeInvokedByOverriders
    public void onChunkUnload() {
        super.onChunkUnload();
        this.invalidateNeighbors();
    }

    @Override
    @Nullable
    public TileEntity getNeighbor(@NotNull EnumFacing facing) {
        if (this.field_145850_b == null || this.field_174879_c == null) {
            return null;
        }
        int i = facing.func_176745_a();
        TileEntity neighbor = this.neighbors[i];
        if (neighbor == this || neighbor != null && neighbor.func_145837_r()) {
            this.neighbors[i] = neighbor = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(facing));
            this.neighborsInvalidated = false;
        }
        return neighbor;
    }

    @Override
    public void onNeighborChanged(@NotNull EnumFacing facing) {
        this.neighbors[facing.func_176745_a()] = this;
    }
}

