/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.items.toolitem;

import gregtech.api.items.toolitem.ToolHelper;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayDeque;
import java.util.Comparator;
import java.util.Deque;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import org.jetbrains.annotations.NotNull;

public final class TreeFellingListener {
    private final EntityPlayerMP player;
    private final ItemStack tool;
    private final Deque<BlockPos> orderedBlocks;

    private TreeFellingListener(EntityPlayerMP player, ItemStack tool, Deque<BlockPos> orderedBlocks) {
        this.player = player;
        this.tool = tool;
        this.orderedBlocks = orderedBlocks;
    }

    public static void start(@NotNull IBlockState state, ItemStack tool, BlockPos start, @NotNull EntityPlayerMP player) {
        World world = player.field_70170_p;
        Block block = state.func_177230_c();
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        ArrayDeque<BlockPos> checking = new ArrayDeque<BlockPos>();
        ObjectOpenHashSet visited = new ObjectOpenHashSet();
        checking.add(start);
        while (!checking.isEmpty()) {
            BlockPos check = (BlockPos)checking.remove();
            if (check != start) {
                visited.add(check);
            }
            for (int y = 0; y <= 1; ++y) {
                for (int x = -1; x <= 1; ++x) {
                    for (int z = -1; z <= 1; ++z) {
                        if (x == 0 && y == 0 && z == 0) continue;
                        mutablePos.func_181079_c(check.func_177958_n() + x, check.func_177956_o() + y, check.func_177952_p() + z);
                        if (visited.contains(mutablePos) || block != world.func_180495_p((BlockPos)mutablePos).func_177230_c() || checking.contains(mutablePos)) continue;
                        BlockPos immutablePos = mutablePos.func_185334_h();
                        checking.add(immutablePos);
                    }
                }
            }
        }
        if (!visited.isEmpty()) {
            Deque orderedBlocks = visited.stream().sorted(Comparator.comparingInt(pos -> start.func_177956_o() - pos.func_177956_o())).collect(Collectors.toCollection(ArrayDeque::new));
            MinecraftForge.EVENT_BUS.register((Object)new TreeFellingListener(player, tool, orderedBlocks));
        }
    }

    @SubscribeEvent
    public void onWorldTick(@NotNull TickEvent.WorldTickEvent event) {
        if (event.phase == TickEvent.Phase.START && event.world == this.player.field_70170_p && event.side == Side.SERVER) {
            if (this.orderedBlocks.isEmpty() || this.tool.func_190926_b()) {
                MinecraftForge.EVENT_BUS.unregister((Object)this);
                return;
            }
            ToolHelper.breakBlockRoutine(this.player, this.tool, this.orderedBlocks.removeLast());
        }
    }
}

