/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.gui.widgets;

import gregtech.api.gui.IRenderContext;
import gregtech.api.gui.Widget;
import gregtech.api.gui.resources.IGuiTexture;
import gregtech.api.util.MCGuiUtil;
import gregtech.api.util.Position;
import gregtech.api.util.Size;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TextFieldWidget
extends Widget {
    @SideOnly(value=Side.CLIENT)
    protected GuiTextField textField;
    protected int maxStringLength = 32;
    protected Predicate<String> textValidator;
    protected Supplier<String> textSupplier;
    protected Consumer<String> textResponder;
    protected String currentString;
    private IGuiTexture background;
    private boolean enableBackground;
    private boolean isClient;

    public TextFieldWidget(int xPosition, int yPosition, int width, int height, boolean enableBackground, Supplier<String> textSupplier, Consumer<String> textResponder) {
        super(new Position(xPosition, yPosition), new Size(width, height));
        if (TextFieldWidget.isClientSide()) {
            this.enableBackground = enableBackground;
            FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
            this.textField = enableBackground ? new GuiTextField(0, fontRenderer, xPosition, yPosition, width, height) : new GuiTextField(0, fontRenderer, xPosition + 1, yPosition + (height - fontRenderer.field_78288_b) / 2 + 1, width - 2, height);
            this.textField.func_146205_d(true);
            this.textField.func_146185_a(enableBackground);
            this.textField.func_146203_f(this.maxStringLength);
            this.textField.func_175207_a(MCGuiUtil.createTextFieldResponder(this::onTextChanged));
        }
        this.textSupplier = textSupplier;
        this.textResponder = textResponder;
    }

    public TextFieldWidget(int xPosition, int yPosition, int width, int height, boolean enableBackground, Supplier<String> textSupplier, Consumer<String> textResponder, int maxStringLength) {
        super(new Position(xPosition, yPosition), new Size(width, height));
        if (TextFieldWidget.isClientSide()) {
            FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
            this.textField = enableBackground ? new GuiTextField(0, fontRenderer, xPosition, yPosition, width, height) : new GuiTextField(0, fontRenderer, xPosition + 1, yPosition + (height - fontRenderer.field_78288_b) / 2 + 1, width - 2, height);
            this.textField.func_146205_d(true);
            this.textField.func_146185_a(enableBackground);
            this.textField.func_146203_f(maxStringLength);
            this.maxStringLength = maxStringLength;
            this.textField.func_175207_a(MCGuiUtil.createTextFieldResponder(this::onTextChanged));
        }
        this.textSupplier = textSupplier;
        this.textResponder = textResponder;
    }

    public TextFieldWidget(int xPosition, int yPosition, int width, int height, IGuiTexture background, Supplier<String> textSupplier, Consumer<String> textResponder) {
        super(new Position(xPosition, yPosition), new Size(width, height));
        if (TextFieldWidget.isClientSide()) {
            this.enableBackground = false;
            FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
            this.textField = new GuiTextField(0, fontRenderer, xPosition + 1, yPosition + (height - fontRenderer.field_78288_b) / 2 + 1, width - 2, height);
            this.textField.func_146205_d(true);
            this.textField.func_146185_a(false);
            this.textField.func_146203_f(this.maxStringLength);
            this.textField.func_175207_a(MCGuiUtil.createTextFieldResponder(this::onTextChanged));
        }
        this.background = background;
        this.textSupplier = textSupplier;
        this.textResponder = textResponder;
    }

    public TextFieldWidget doesClientCallback(boolean isClient) {
        this.isClient = isClient;
        return this;
    }

    public TextFieldWidget setTextSupplier(Supplier<String> textSupplier, boolean isClient) {
        this.isClient = isClient;
        this.textSupplier = textSupplier;
        return this;
    }

    public TextFieldWidget setTextResponder(Consumer<String> textResponder, boolean isClient) {
        this.isClient = isClient;
        this.textResponder = textResponder;
        return this;
    }

    public TextFieldWidget setCurrentString(String currentString) {
        this.currentString = currentString;
        this.textField.func_146180_a(currentString);
        return this;
    }

    public String getCurrentString() {
        if (this.isRemote()) {
            return this.textField.func_146179_b();
        }
        return this.currentString;
    }

    @Override
    protected void onPositionUpdate() {
        if (TextFieldWidget.isClientSide() && this.textField != null) {
            FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
            Position position = this.getPosition();
            Size size = this.getSize();
            GuiTextField textField = this.textField;
            textField.field_146209_f = this.enableBackground ? position.x : position.x + 1;
            textField.field_146210_g = this.enableBackground ? position.y : position.y + (size.height - fontRenderer.field_78288_b) / 2 + 1;
        }
    }

    @Override
    protected void onSizeUpdate() {
        if (TextFieldWidget.isClientSide() && this.textField != null) {
            FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
            Position position = this.getPosition();
            Size size = this.getSize();
            GuiTextField textField = this.textField;
            textField.field_146218_h = this.enableBackground ? size.width : size.width - 2;
            textField.field_146219_i = size.height;
            textField.field_146210_g = this.enableBackground ? position.y : position.y + (this.getSize().height - fontRenderer.field_78288_b) / 2 + 1;
        }
    }

    @Override
    public void drawInBackground(int mouseX, int mouseY, float partialTicks, IRenderContext context) {
        super.drawInBackground(mouseX, mouseY, partialTicks, context);
        if (this.background != null) {
            Position position = this.getPosition();
            Size size = this.getSize();
            this.background.draw(position.x, position.y, size.width, size.height);
        }
        this.textField.func_146194_f();
        GlStateManager.func_179147_l();
    }

    @Override
    public boolean mouseClicked(int mouseX, int mouseY, int button) {
        return this.textField.func_146192_a(mouseX, mouseY, button);
    }

    @Override
    public boolean keyTyped(char charTyped, int keyCode) {
        return this.textField.func_146201_a(charTyped, keyCode);
    }

    @Override
    public void updateScreen() {
        if (this.textSupplier != null && this.isClient) {
            this.currentString = this.textSupplier.get();
            this.textField.func_146180_a(this.currentString);
        }
    }

    @Override
    public void detectAndSendChanges() {
        super.detectAndSendChanges();
        if (this.textSupplier != null && !this.textSupplier.get().equals(this.currentString)) {
            this.currentString = this.textSupplier.get();
            this.writeUpdateInfo(1, buffer -> buffer.func_180714_a(this.currentString));
        }
    }

    @Override
    public void readUpdateInfo(int id, PacketBuffer buffer) {
        super.readUpdateInfo(id, buffer);
        if (id == 1) {
            this.currentString = buffer.func_150789_c(Short.MAX_VALUE);
            this.textField.func_146180_a(this.currentString);
        }
    }

    protected void onTextChanged(String newTextString) {
        if (this.textValidator.test(newTextString)) {
            if (this.isClient && this.textResponder != null) {
                this.textResponder.accept(newTextString);
            }
            this.writeClientAction(1, buffer -> buffer.func_180714_a(newTextString));
        }
    }

    @Override
    public void handleClientAction(int id, PacketBuffer buffer) {
        super.handleClientAction(id, buffer);
        if (id == 1) {
            String clientText = buffer.func_150789_c(Short.MAX_VALUE);
            if (this.textValidator.test(clientText = clientText.substring(0, Math.min(clientText.length(), this.maxStringLength)))) {
                this.currentString = clientText;
                if (this.textResponder != null) {
                    this.textResponder.accept(clientText);
                }
            }
        }
    }

    public TextFieldWidget setTextColor(int textColor) {
        if (TextFieldWidget.isClientSide()) {
            this.textField.func_146193_g(textColor);
        }
        return this;
    }

    public TextFieldWidget setMaxStringLength(int maxStringLength) {
        this.maxStringLength = maxStringLength;
        if (TextFieldWidget.isClientSide()) {
            this.textField.func_146203_f(maxStringLength);
        }
        return this;
    }

    public TextFieldWidget setValidator(Predicate<String> validator) {
        this.textValidator = validator;
        if (TextFieldWidget.isClientSide()) {
            this.textField.func_175205_a(validator::test);
        }
        return this;
    }
}

