/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.gui.widgets;

import gregtech.api.gui.IRenderContext;
import gregtech.api.gui.Widget;
import gregtech.api.gui.widgets.AbstractWidgetGroup;
import gregtech.api.gui.widgets.tab.HorizontalTabListRenderer;
import gregtech.api.gui.widgets.tab.ITabInfo;
import gregtech.api.gui.widgets.tab.TabListRenderer;
import gregtech.api.gui.widgets.tab.VerticalTabListRenderer;
import gregtech.api.util.Position;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.Tuple;

public class TabGroup<T extends AbstractWidgetGroup>
extends AbstractWidgetGroup {
    private final List<ITabInfo> tabInfos = new ArrayList<ITabInfo>();
    private final List<T> tabWidgets = new ArrayList<T>();
    protected int selectedTabIndex = 0;
    private final TabListRenderer tabListRenderer;
    private BiConsumer<Integer, Integer> onTabChanged;

    public TabGroup(int x, int y, TabListRenderer tabListRenderer) {
        super(new Position(x, y));
        this.tabListRenderer = tabListRenderer;
    }

    public TabGroup(TabLocation tabLocation, Position position) {
        super(position);
        this.tabListRenderer = (TabListRenderer)tabLocation.supplier.get();
    }

    public void addTab(ITabInfo tabInfo, T tabWidget) {
        this.tabInfos.add(tabInfo);
        int tabIndex = this.tabInfos.size() - 1;
        this.tabWidgets.add(tabWidget);
        ((AbstractWidgetGroup)tabWidget).setVisible(tabIndex == this.selectedTabIndex);
        ((Widget)tabWidget).setActive(tabIndex == this.selectedTabIndex);
        this.addWidget((Widget)tabWidget);
    }

    public ITabInfo getTabInfo(int i) {
        if (i < this.tabInfos.size()) {
            return this.tabInfos.get(i);
        }
        return null;
    }

    public T getTabWidget(int i) {
        if (i < this.tabWidgets.size()) {
            return (T)((AbstractWidgetGroup)this.tabWidgets.get(i));
        }
        return null;
    }

    public void removeTab(int index) {
        this.tabInfos.remove(index);
        AbstractWidgetGroup tab = (AbstractWidgetGroup)this.tabWidgets.remove(index);
        this.removeWidget(tab);
        if (this.selectedTabIndex >= index && this.selectedTabIndex > 0) {
            --this.selectedTabIndex;
        }
        for (int i = 0; i < this.tabWidgets.size(); ++i) {
            ((AbstractWidgetGroup)this.tabWidgets.get(i)).setActive(i == this.selectedTabIndex);
            ((AbstractWidgetGroup)this.tabWidgets.get(i)).setVisible(i == this.selectedTabIndex);
        }
    }

    public TabGroup<T> setOnTabChanged(BiConsumer<Integer, Integer> onTabChanged) {
        this.onTabChanged = onTabChanged;
        return this;
    }

    public T getCurrentTag() {
        return (T)((AbstractWidgetGroup)this.tabWidgets.get(this.selectedTabIndex));
    }

    public List<T> getAllTag() {
        return this.tabWidgets;
    }

    @Override
    public List<Widget> getContainedWidgets(boolean includeHidden) {
        ArrayList<Widget> containedWidgets = new ArrayList<Widget>(this.widgets.size());
        if (includeHidden) {
            for (Widget widget : this.tabWidgets) {
                containedWidgets.add(widget);
                if (!(widget instanceof AbstractWidgetGroup)) continue;
                containedWidgets.addAll(((AbstractWidgetGroup)widget).getContainedWidgets(true));
            }
        } else {
            AbstractWidgetGroup widgetGroup = (AbstractWidgetGroup)this.tabWidgets.get(this.selectedTabIndex);
            containedWidgets.add(widgetGroup);
            containedWidgets.addAll(widgetGroup.getContainedWidgets(false));
        }
        return containedWidgets;
    }

    @Override
    public void drawInBackground(int mouseX, int mouseY, float partialTicks, IRenderContext context) {
        super.drawInBackground(mouseX, mouseY, partialTicks, context);
        this.tabListRenderer.renderTabs(this.gui, this.getPosition(), this.tabInfos, this.sizes.getWidth(), this.sizes.getHeight(), this.selectedTabIndex);
    }

    @Override
    public void drawInForeground(int mouseX, int mouseY) {
        super.drawInForeground(mouseX, mouseY);
        Tuple<ITabInfo, int[]> tabOnMouse = this.getTabOnMouse(mouseX, mouseY);
        if (tabOnMouse != null) {
            int[] tabSizes = (int[])tabOnMouse.func_76340_b();
            ITabInfo tabInfo = (ITabInfo)tabOnMouse.func_76341_a();
            boolean isSelected = this.tabInfos.get(this.selectedTabIndex) == tabInfo;
            tabInfo.renderHoverText(tabSizes[0], tabSizes[1], tabSizes[2], tabSizes[3], this.sizes.getWidth(), this.sizes.getHeight(), isSelected, mouseX, mouseY);
        }
    }

    @Override
    public boolean mouseClicked(int mouseX, int mouseY, int button) {
        ITabInfo tabInfo;
        int tabIndex;
        boolean flag = super.mouseClicked(mouseX, mouseY, button);
        Tuple<ITabInfo, int[]> tabOnMouse = this.getTabOnMouse(mouseX, mouseY);
        if (tabOnMouse != null && this.selectedTabIndex != (tabIndex = this.tabInfos.indexOf(tabInfo = (ITabInfo)tabOnMouse.func_76341_a()))) {
            this.setSelectedTab(tabIndex);
            TabGroup.playButtonClickSound();
            this.writeClientAction(2, buf -> buf.func_150787_b(tabIndex));
            return true;
        }
        return flag;
    }

    public void setSelectedTab(int tabIndex) {
        int old = this.selectedTabIndex;
        ((AbstractWidgetGroup)this.tabWidgets.get(this.selectedTabIndex)).setVisible(false);
        ((AbstractWidgetGroup)this.tabWidgets.get(this.selectedTabIndex)).setActive(false);
        ((AbstractWidgetGroup)this.tabWidgets.get(tabIndex)).setVisible(true);
        ((AbstractWidgetGroup)this.tabWidgets.get(tabIndex)).setActive(true);
        this.selectedTabIndex = tabIndex;
        if (this.onTabChanged != null) {
            this.onTabChanged.accept(old, tabIndex);
        }
    }

    @Override
    public void handleClientAction(int id, PacketBuffer buffer) {
        int tabIndex;
        super.handleClientAction(id, buffer);
        if (id == 2 && this.selectedTabIndex != (tabIndex = buffer.func_150792_a())) {
            this.setSelectedTab(tabIndex);
        }
    }

    private Tuple<ITabInfo, int[]> getTabOnMouse(int mouseX, int mouseY) {
        for (int tabIndex = 0; tabIndex < this.tabInfos.size(); ++tabIndex) {
            ITabInfo tabInfo = this.tabInfos.get(tabIndex);
            int[] tabSizes = this.tabListRenderer.getTabPos(tabIndex, this.sizes.getWidth(), this.sizes.getHeight());
            tabSizes[0] = tabSizes[0] + this.getPosition().x;
            tabSizes[1] = tabSizes[1] + this.getPosition().y;
            if (!TabGroup.isMouseOverTab(mouseX, mouseY, tabSizes)) continue;
            return new Tuple((Object)tabInfo, (Object)tabSizes);
        }
        return null;
    }

    private static boolean isMouseOverTab(int mouseX, int mouseY, int[] tabSizes) {
        int minX = tabSizes[0];
        int minY = tabSizes[1];
        int maxX = tabSizes[0] + tabSizes[2];
        int maxY = tabSizes[1] + tabSizes[3];
        return mouseX >= minX && mouseY >= minY && mouseX < maxX && mouseY < maxY;
    }

    public boolean isWidgetVisible(Widget widget) {
        return this.tabWidgets.get(this.selectedTabIndex) == widget;
    }

    public static enum TabLocation {
        HORIZONTAL_TOP_LEFT(() -> new HorizontalTabListRenderer(HorizontalTabListRenderer.HorizontalStartCorner.LEFT, HorizontalTabListRenderer.VerticalLocation.TOP)),
        HORIZONTAL_TOP_RIGHT(() -> new HorizontalTabListRenderer(HorizontalTabListRenderer.HorizontalStartCorner.RIGHT, HorizontalTabListRenderer.VerticalLocation.TOP)),
        HORIZONTAL_BOTTOM_LEFT(() -> new HorizontalTabListRenderer(HorizontalTabListRenderer.HorizontalStartCorner.LEFT, HorizontalTabListRenderer.VerticalLocation.BOTTOM)),
        HORIZONTAL_BOTTOM_RIGHT(() -> new HorizontalTabListRenderer(HorizontalTabListRenderer.HorizontalStartCorner.RIGHT, HorizontalTabListRenderer.VerticalLocation.BOTTOM)),
        VERTICAL_LEFT_TOP(() -> new VerticalTabListRenderer(VerticalTabListRenderer.VerticalStartCorner.TOP, VerticalTabListRenderer.HorizontalLocation.LEFT)),
        VERTICAL_LEFT_BOTTOM(() -> new VerticalTabListRenderer(VerticalTabListRenderer.VerticalStartCorner.BOTTOM, VerticalTabListRenderer.HorizontalLocation.LEFT)),
        VERTICAL_RIGHT_TOP(() -> new VerticalTabListRenderer(VerticalTabListRenderer.VerticalStartCorner.TOP, VerticalTabListRenderer.HorizontalLocation.RIGHT)),
        VERTICAL_RIGHT_BOTTOM(() -> new VerticalTabListRenderer(VerticalTabListRenderer.VerticalStartCorner.BOTTOM, VerticalTabListRenderer.HorizontalLocation.RIGHT));

        private final Supplier<TabListRenderer> supplier;

        private TabLocation(Supplier<TabListRenderer> supplier) {
            this.supplier = supplier;
        }
    }
}

