/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.gui.widgets;

import gregtech.api.capability.impl.GhostCircuitItemStackHandler;
import gregtech.api.gui.widgets.SlotWidget;
import gregtech.api.util.LocalizationUtils;
import gregtech.client.utils.TooltipHelper;
import java.util.Arrays;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.items.IItemHandler;

public class GhostCircuitSlotWidget
extends SlotWidget {
    private static final int SET_TO_ZERO = 1;
    private static final int SET_TO_EMPTY = 2;
    private static final int SET_TO_N = 3;
    private final GhostCircuitItemStackHandler circuitInventory;

    public GhostCircuitSlotWidget(GhostCircuitItemStackHandler circuitInventory, int slotIndex, int xPosition, int yPosition) {
        super((IItemHandler)circuitInventory, slotIndex, xPosition, yPosition, false, false, false);
        this.circuitInventory = circuitInventory;
    }

    @Override
    public void drawInForeground(int mouseX, int mouseY) {
        if (this.isMouseOverElement(mouseX, mouseY)) {
            if (this.tooltipText == null && this.consumer != null) {
                this.consumer.accept(this);
            }
            List<String> hoverList = Arrays.asList(LocalizationUtils.formatLines(this.tooltipText, this.tooltipArgs));
            this.drawHoveringText(ItemStack.field_190927_a, hoverList, 300, mouseX, mouseY);
        }
    }

    @Override
    public boolean mouseClicked(int mouseX, int mouseY, int button) {
        if (this.isMouseOverElement(mouseX, mouseY) && this.gui != null) {
            if (button != 0 || !TooltipHelper.isShiftDown()) {
                if (button == 0) {
                    int newValue = this.getNextValue(true);
                    this.circuitInventory.setCircuitValue(newValue);
                    this.writeClientAction(3, buf -> buf.func_150787_b(newValue));
                } else if (button == 1 && TooltipHelper.isShiftDown()) {
                    this.circuitInventory.setCircuitValue(-1);
                    this.writeClientAction(2, buf -> {});
                } else if (button == 1) {
                    int newValue = this.getNextValue(false);
                    this.circuitInventory.setCircuitValue(newValue);
                    this.writeClientAction(3, buf -> buf.func_150787_b(newValue));
                }
            }
            if (this.consumer != null) {
                this.consumer.accept(this);
            }
            return true;
        }
        return false;
    }

    private int getNextValue(boolean increment) {
        if (increment) {
            if (this.circuitInventory.getCircuitValue() == 32) {
                return -1;
            }
            if (!this.circuitInventory.hasCircuitValue()) {
                return 1;
            }
            return this.circuitInventory.getCircuitValue() + 1;
        }
        if (!this.circuitInventory.hasCircuitValue()) {
            return 32;
        }
        if (this.circuitInventory.getCircuitValue() == 1) {
            return -1;
        }
        return this.circuitInventory.getCircuitValue() - 1;
    }

    @Override
    public boolean mouseWheelMove(int mouseX, int mouseY, int wheelDelta) {
        if (this.isMouseOverElement(mouseX, mouseY) && this.gui != null) {
            int newValue = this.getNextValue(wheelDelta >= 0);
            this.circuitInventory.setCircuitValue(newValue);
            this.writeClientAction(3, buf -> buf.func_150787_b(newValue));
            if (this.consumer != null) {
                this.consumer.accept(this);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean mouseDragged(int mouseX, int mouseY, int button, long timeDragged) {
        return false;
    }

    @Override
    public boolean canMergeSlot(ItemStack stack) {
        return false;
    }

    @Override
    public void handleClientAction(int id, PacketBuffer buffer) {
        switch (id) {
            case 1: {
                this.circuitInventory.setCircuitValue(0);
                return;
            }
            case 2: {
                this.circuitInventory.setCircuitValue(-1);
                return;
            }
            case 3: {
                this.circuitInventory.setCircuitValue(buffer.func_150792_a());
            }
        }
    }
}

