/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.gui.widgets;

import gregtech.api.gui.GuiTextures;
import gregtech.api.gui.IRenderContext;
import gregtech.api.gui.Widget;
import gregtech.api.gui.widgets.AbstractWidgetGroup;
import gregtech.api.gui.widgets.PhantomSlotWidget;
import gregtech.api.util.Position;
import gregtech.common.metatileentities.storage.CraftingRecipeLogic;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;

public class CraftingStationInputWidgetGroup
extends AbstractWidgetGroup {
    protected CraftingRecipeLogic recipeResolver;
    protected short tintLocations;
    public static final int LIGHT_RED = 0x66FF0000;

    public CraftingStationInputWidgetGroup(int x, int y, ItemStackHandler craftingGrid, CraftingRecipeLogic recipeResolver) {
        super(new Position(x, y));
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.addWidget(new PhantomSlotWidget((IItemHandlerModifiable)craftingGrid, j + i * 3, x + j * 18, y + i * 18).setBackgroundTexture(GuiTextures.SLOT));
            }
        }
        this.recipeResolver = recipeResolver;
    }

    @Override
    public void drawInBackground(int mouseX, int mouseY, float partialTicks, IRenderContext context) {
        super.drawInBackground(mouseX, mouseY, partialTicks, context);
        if (this.widgets.size() == 9) {
            for (int i = 0; i < 9; ++i) {
                Widget widget = (Widget)this.widgets.get(i);
                if (!(widget instanceof PhantomSlotWidget) || (this.tintLocations >> i & 1) != 0) continue;
                int color = 0x66FF0000;
                PhantomSlotWidget phantomSlotWidget = (PhantomSlotWidget)widget;
                CraftingStationInputWidgetGroup.drawSolidRect(phantomSlotWidget.getPosition().x + 1, phantomSlotWidget.getPosition().y + 1, phantomSlotWidget.getSize().getWidth() - 2, phantomSlotWidget.getSize().getWidth() - 2, color);
            }
        }
    }

    @Override
    public void detectAndSendChanges() {
        super.detectAndSendChanges();
        short newTintLocations = this.recipeResolver.getTintLocations();
        if (this.tintLocations != newTintLocations) {
            this.tintLocations = newTintLocations;
            this.writeUpdateInfo(2, buffer -> buffer.writeShort((int)this.tintLocations));
        }
    }

    @Override
    public void readUpdateInfo(int id, PacketBuffer buffer) {
        super.readUpdateInfo(id, buffer);
        if (id == 2) {
            this.tintLocations = buffer.readShort();
        }
    }
}

