/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.gui.widgets;

import gregtech.api.gui.INativeWidget;
import gregtech.api.gui.IRenderContext;
import gregtech.api.gui.Widget;
import gregtech.api.gui.ingredient.IGhostIngredientTarget;
import gregtech.api.gui.ingredient.IIngredientSlot;
import gregtech.api.gui.widgets.WidgetUIAccess;
import gregtech.api.util.GTLog;
import gregtech.api.util.Position;
import gregtech.api.util.Size;
import gregtech.common.ConfigHolder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import mezz.jei.api.gui.IGhostIngredientHandler;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;

public class AbstractWidgetGroup
extends Widget
implements IGhostIngredientTarget,
IIngredientSlot {
    public final transient List<Widget> widgets = new ArrayList<Widget>();
    private final transient WidgetGroupUIAccess groupUIAccess = new WidgetGroupUIAccess();
    private final transient boolean isDynamicSized;
    private transient boolean initialized = false;
    protected transient List<Widget> waitToRemoved;

    public AbstractWidgetGroup(Position position) {
        super(position, Size.ZERO);
        this.isDynamicSized = true;
    }

    public AbstractWidgetGroup(Position position, Size size) {
        super(position, size);
        this.isDynamicSized = false;
    }

    public List<Widget> getContainedWidgets(boolean includeHidden) {
        ArrayList<Widget> containedWidgets = new ArrayList<Widget>(this.widgets.size());
        for (Widget widget : this.widgets) {
            if (!widget.isVisible() && !includeHidden) continue;
            containedWidgets.add(widget);
            if (!(widget instanceof AbstractWidgetGroup)) continue;
            containedWidgets.addAll(((AbstractWidgetGroup)widget).getContainedWidgets(includeHidden));
        }
        return containedWidgets;
    }

    @Override
    protected void onPositionUpdate() {
        Position selfPosition = this.getPosition();
        for (Widget widget : this.widgets) {
            widget.setParentPosition(selfPosition);
        }
        this.recomputeSize();
    }

    protected boolean recomputeSize() {
        Size dynamicSize;
        Size currentSize;
        if (this.isDynamicSized && !(currentSize = this.getSize()).equals(dynamicSize = this.computeDynamicSize())) {
            this.setSize(dynamicSize);
            if (this.uiAccess != null) {
                this.uiAccess.notifySizeChange();
            }
            return true;
        }
        return false;
    }

    protected Size computeDynamicSize() {
        Position selfPosition = this.getPosition();
        Size currentSize = this.getSize();
        for (Widget widget : this.widgets) {
            Position size = widget.getPosition().add(widget.getSize()).subtract(selfPosition);
            if (size.x > currentSize.width) {
                currentSize = new Size(size.x, currentSize.height);
            }
            if (size.y <= currentSize.height) continue;
            currentSize = new Size(currentSize.width, size.y);
        }
        return currentSize;
    }

    @Override
    public void setVisible(boolean visible) {
        if (this.isVisible() == visible) {
            return;
        }
        super.setVisible(visible);
    }

    protected void addWidget(Widget widget) {
        if (widget == this) {
            throw new IllegalArgumentException("Cannot add self");
        }
        if (this.widgets.contains(widget)) {
            throw new IllegalArgumentException("Already added");
        }
        this.widgets.add(widget);
        widget.setUiAccess(this.groupUIAccess);
        widget.setGui(this.gui);
        widget.setSizes(this.sizes);
        widget.setParentPosition(this.getPosition());
        if (this.initialized) {
            widget.initWidget();
        }
        this.recomputeSize();
        if (this.uiAccess != null) {
            this.uiAccess.notifyWidgetChange();
        }
    }

    protected void addWidget(int index, Widget widget) {
        if (widget == this) {
            throw new IllegalArgumentException("Cannot add self");
        }
        if (this.widgets.contains(widget)) {
            throw new IllegalArgumentException("Already added");
        }
        this.widgets.add(index, widget);
        widget.setUiAccess(this.groupUIAccess);
        widget.setGui(this.gui);
        widget.setSizes(this.sizes);
        widget.setParentPosition(this.getPosition());
        if (this.initialized) {
            widget.initWidget();
        }
        this.recomputeSize();
        if (this.uiAccess != null) {
            this.uiAccess.notifyWidgetChange();
        }
    }

    protected void waitToRemoved(Widget widget) {
        if (this.waitToRemoved == null) {
            this.waitToRemoved = new ArrayList<Widget>();
        }
        this.waitToRemoved.add(widget);
    }

    protected void removeWidget(Widget widget) {
        if (!this.widgets.contains(widget)) {
            if (ConfigHolder.misc.debug) {
                GTLog.logger.warn("widget not added");
            }
            return;
        }
        this.widgets.remove(widget);
        widget.setUiAccess(null);
        widget.setGui(null);
        widget.setSizes(null);
        widget.setParentPosition(Position.ORIGIN);
        this.recomputeSize();
        if (this.uiAccess != null) {
            this.uiAccess.notifyWidgetChange();
        }
    }

    protected void clearAllWidgets() {
        this.widgets.forEach(it -> {
            it.setUiAccess(null);
            it.setGui(null);
            it.setSizes(null);
            it.setParentPosition(Position.ORIGIN);
        });
        this.widgets.clear();
        this.recomputeSize();
        if (this.uiAccess != null) {
            this.uiAccess.notifyWidgetChange();
        }
    }

    public boolean isWidgetClickable(Widget widget) {
        return this.isVisible();
    }

    @Override
    public void initWidget() {
        this.initialized = true;
        for (Widget widget : this.widgets) {
            widget.setGui(this.gui);
            widget.setSizes(this.sizes);
            widget.initWidget();
        }
    }

    @Override
    public List<INativeWidget> getNativeWidgets() {
        ArrayList<INativeWidget> nativeWidgets = new ArrayList<INativeWidget>();
        for (Widget widget : this.widgets) {
            nativeWidgets.addAll(widget.getNativeWidgets());
        }
        if (this instanceof INativeWidget) {
            nativeWidgets.add((INativeWidget)((Object)this));
        }
        return nativeWidgets;
    }

    @Override
    public List<IGhostIngredientHandler.Target<?>> getPhantomTargets(Object ingredient) {
        if (!this.isVisible()) {
            return Collections.emptyList();
        }
        ArrayList targets = new ArrayList();
        for (Widget widget : this.widgets) {
            if (!widget.isVisible() || !(widget instanceof IGhostIngredientTarget)) continue;
            targets.addAll(((IGhostIngredientTarget)((Object)widget)).getPhantomTargets(ingredient));
        }
        return targets;
    }

    @Override
    public Object getIngredientOverMouse(int mouseX, int mouseY) {
        if (!this.isVisible()) {
            return Collections.emptyList();
        }
        for (Widget widget : this.widgets) {
            IIngredientSlot ingredientSlot;
            Object result;
            if (!widget.isVisible() || !(widget instanceof IIngredientSlot) || (result = (ingredientSlot = (IIngredientSlot)((Object)widget)).getIngredientOverMouse(mouseX, mouseY)) == null) continue;
            return result;
        }
        return null;
    }

    @Override
    public void detectAndSendChanges() {
        for (Widget widget : this.widgets) {
            if (!widget.isActive()) continue;
            widget.detectAndSendChanges();
        }
        if (this.waitToRemoved != null) {
            this.waitToRemoved.forEach(this::removeWidget);
            this.waitToRemoved = null;
        }
    }

    @Override
    public void updateScreen() {
        for (Widget widget : this.widgets) {
            if (!widget.isActive()) continue;
            widget.updateScreen();
        }
        if (this.waitToRemoved != null) {
            this.waitToRemoved.forEach(this::removeWidget);
            this.waitToRemoved = null;
        }
    }

    @Override
    public void updateScreenOnFrame() {
        for (Widget widget : this.widgets) {
            if (!widget.isActive()) continue;
            widget.updateScreenOnFrame();
        }
    }

    @Override
    public void drawInForeground(int mouseX, int mouseY) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        for (Widget widget : this.widgets) {
            if (!widget.isVisible()) continue;
            widget.drawInForeground(mouseX, mouseY);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    @Override
    public void drawInBackground(int mouseX, int mouseY, float partialTicks, IRenderContext context) {
        GlStateManager.func_179131_c((float)this.gui.getRColorForOverlay(), (float)this.gui.getGColorForOverlay(), (float)this.gui.getBColorForOverlay(), (float)1.0f);
        for (Widget widget : this.widgets) {
            if (!widget.isVisible()) continue;
            widget.drawInBackground(mouseX, mouseY, partialTicks, context);
            GlStateManager.func_179131_c((float)this.gui.getRColorForOverlay(), (float)this.gui.getGColorForOverlay(), (float)this.gui.getBColorForOverlay(), (float)1.0f);
        }
    }

    @Override
    public boolean mouseWheelMove(int mouseX, int mouseY, int wheelDelta) {
        for (int i = this.widgets.size() - 1; i >= 0; --i) {
            Widget widget = this.widgets.get(i);
            if (!widget.isVisible() || !widget.isActive() || !widget.mouseWheelMove(mouseX, mouseY, wheelDelta)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean mouseClicked(int mouseX, int mouseY, int button) {
        for (int i = this.widgets.size() - 1; i >= 0; --i) {
            Widget widget = this.widgets.get(i);
            if (!widget.isVisible() || !widget.isActive() || !widget.mouseClicked(mouseX, mouseY, button)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean mouseDragged(int mouseX, int mouseY, int button, long timeDragged) {
        for (int i = this.widgets.size() - 1; i >= 0; --i) {
            Widget widget = this.widgets.get(i);
            if (!widget.isVisible() || !widget.isActive() || !widget.mouseDragged(mouseX, mouseY, button, timeDragged)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean mouseReleased(int mouseX, int mouseY, int button) {
        for (int i = this.widgets.size() - 1; i >= 0; --i) {
            Widget widget = this.widgets.get(i);
            if (!widget.isVisible() || !widget.isActive() || !widget.mouseReleased(mouseX, mouseY, button)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean keyTyped(char charTyped, int keyCode) {
        for (int i = this.widgets.size() - 1; i >= 0; --i) {
            Widget widget = this.widgets.get(i);
            if (!widget.isVisible() || !widget.isActive() || !widget.keyTyped(charTyped, keyCode)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void readUpdateInfo(int id, PacketBuffer buffer) {
        if (id == 1) {
            int widgetIndex = buffer.func_150792_a();
            int widgetUpdateId = buffer.func_150792_a();
            Widget widget = this.widgets.get(widgetIndex);
            widget.readUpdateInfo(widgetUpdateId, buffer);
        }
    }

    @Override
    public void handleClientAction(int id, PacketBuffer buffer) {
        if (id == 1) {
            int widgetIndex = buffer.func_150792_a();
            int widgetUpdateId = buffer.func_150792_a();
            Widget widget = this.widgets.get(widgetIndex);
            widget.handleClientAction(widgetUpdateId, buffer);
        }
    }

    private class WidgetGroupUIAccess
    implements WidgetUIAccess {
        private WidgetGroupUIAccess() {
        }

        @Override
        public void notifySizeChange() {
            WidgetUIAccess uiAccess = AbstractWidgetGroup.this.uiAccess;
            AbstractWidgetGroup.this.recomputeSize();
            if (uiAccess != null) {
                uiAccess.notifySizeChange();
            }
        }

        @Override
        public boolean attemptMergeStack(ItemStack itemStack, boolean fromContainer, boolean simulate) {
            WidgetUIAccess uiAccess = AbstractWidgetGroup.this.uiAccess;
            if (uiAccess != null) {
                return uiAccess.attemptMergeStack(itemStack, fromContainer, simulate);
            }
            return false;
        }

        @Override
        public void sendSlotUpdate(INativeWidget slot) {
            WidgetUIAccess uiAccess = AbstractWidgetGroup.this.uiAccess;
            if (uiAccess != null) {
                uiAccess.sendSlotUpdate(slot);
            }
        }

        @Override
        public void sendHeldItemUpdate() {
            WidgetUIAccess uiAccess = AbstractWidgetGroup.this.uiAccess;
            if (uiAccess != null) {
                uiAccess.sendHeldItemUpdate();
            }
        }

        @Override
        public void notifyWidgetChange() {
            WidgetUIAccess uiAccess = AbstractWidgetGroup.this.uiAccess;
            if (uiAccess != null) {
                uiAccess.notifyWidgetChange();
            }
            AbstractWidgetGroup.this.recomputeSize();
        }

        @Override
        public void writeClientAction(Widget widget, int updateId, Consumer<PacketBuffer> dataWriter) {
            AbstractWidgetGroup.this.writeClientAction(1, buffer -> {
                buffer.func_150787_b(AbstractWidgetGroup.this.widgets.indexOf(widget));
                buffer.func_150787_b(updateId);
                dataWriter.accept((PacketBuffer)buffer);
            });
        }

        @Override
        public void writeUpdateInfo(Widget widget, int updateId, Consumer<PacketBuffer> dataWriter) {
            AbstractWidgetGroup.this.writeUpdateInfo(1, buffer -> {
                buffer.func_150787_b(AbstractWidgetGroup.this.widgets.indexOf(widget));
                buffer.func_150787_b(updateId);
                dataWriter.accept((PacketBuffer)buffer);
            });
        }
    }
}

