/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.gui.resources;

import gregtech.api.gui.resources.SizedTextureArea;
import gregtech.api.util.GTUtility;
import net.minecraft.util.ResourceLocation;

public class AdoptableTextureArea
extends SizedTextureArea {
    private final int pixelCornerWidth;
    private final int pixelCornerHeight;

    public AdoptableTextureArea(ResourceLocation imageLocation, double offsetX, double offsetY, double width, double height, double pixelImageWidth, double pixelImageHeight, int pixelCornerWidth, int pixelCornerHeight) {
        super(imageLocation, offsetX, offsetY, width, height, pixelImageWidth, pixelImageHeight);
        this.pixelCornerWidth = pixelCornerWidth;
        this.pixelCornerHeight = pixelCornerHeight;
    }

    public static AdoptableTextureArea fullImage(String imageLocation, int imageWidth, int imageHeight, int cornerWidth, int cornerHeight) {
        return new AdoptableTextureArea(GTUtility.gregtechId(imageLocation), 0.0, 0.0, 1.0, 1.0, imageWidth, imageHeight, cornerWidth, cornerHeight);
    }

    @Override
    public void drawSubArea(double x, double y, double width, double height, double drawnU, double drawnV, double drawnWidth, double drawnHeight) {
        double cornerWidth = (double)this.pixelCornerWidth / this.pixelImageWidth;
        double cornerHeight = (double)this.pixelCornerHeight / this.pixelImageHeight;
        super.drawSubArea(x, y, this.pixelCornerWidth, this.pixelCornerHeight, 0.0, 0.0, cornerWidth, cornerHeight);
        super.drawSubArea(x + width - (double)this.pixelCornerWidth, y, this.pixelCornerWidth, this.pixelCornerHeight, 1.0 - cornerWidth, 0.0, cornerWidth, cornerHeight);
        super.drawSubArea(x, y + height - (double)this.pixelCornerHeight, this.pixelCornerWidth, this.pixelCornerHeight, 0.0, 1.0 - cornerHeight, cornerWidth, cornerHeight);
        super.drawSubArea(x + width - (double)this.pixelCornerWidth, y + height - (double)this.pixelCornerHeight, this.pixelCornerWidth, this.pixelCornerHeight, 1.0 - cornerWidth, 1.0 - cornerHeight, cornerWidth, cornerHeight);
        super.drawSubArea(x + (double)this.pixelCornerWidth, y, width - (double)(2 * this.pixelCornerWidth), this.pixelCornerHeight, cornerWidth, 0.0, 1.0 - 2.0 * cornerWidth, cornerHeight);
        super.drawSubArea(x + (double)this.pixelCornerWidth, y + height - (double)this.pixelCornerHeight, width - (double)(2 * this.pixelCornerWidth), this.pixelCornerHeight, cornerWidth, 1.0 - cornerHeight, 1.0 - 2.0 * cornerWidth, cornerHeight);
        super.drawSubArea(x, y + (double)this.pixelCornerHeight, this.pixelCornerWidth, height - (double)(2 * this.pixelCornerHeight), 0.0, cornerHeight, cornerWidth, 1.0 - 2.0 * cornerHeight);
        super.drawSubArea(x + width - (double)this.pixelCornerWidth, y + (double)this.pixelCornerHeight, this.pixelCornerWidth, height - (double)(2 * this.pixelCornerHeight), 1.0 - cornerWidth, cornerHeight, cornerWidth, 1.0 - 2.0 * cornerHeight);
        super.drawSubArea(x + (double)this.pixelCornerWidth, y + (double)this.pixelCornerHeight, width - (double)(2 * this.pixelCornerWidth), height - (double)(2 * this.pixelCornerHeight), cornerWidth, cornerHeight, 1.0 - 2.0 * cornerWidth, 1.0 - 2.0 * cornerHeight);
    }
}

