/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.cover;

import gregtech.api.cover.Cover;
import gregtech.api.cover.CoverDefinition;
import gregtech.api.cover.CoverHolder;
import gregtech.api.cover.CoverableView;
import gregtech.api.util.GTLog;
import java.util.function.BiConsumer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public final class CoverSaveHandler {
    private CoverSaveHandler() {
    }

    public static void writeInitialSyncData(@NotNull PacketBuffer buf, @NotNull CoverableView coverableView) {
        Cover[] covers = new Cover[EnumFacing.field_82609_l.length];
        int count = 0;
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            Cover cover = coverableView.getCoverAtSide(facing);
            if (cover == null) continue;
            covers[count++] = cover;
        }
        buf.writeByte(count);
        if (count == 0) {
            return;
        }
        for (int i = 0; i < count; ++i) {
            Cover cover = covers[i];
            buf.writeByte(cover.getAttachedSide().ordinal());
            buf.func_150787_b(CoverDefinition.getNetworkIdForCover(cover.getDefinition()));
            cover.writeInitialSyncData(buf);
        }
    }

    public static void receiveInitialSyncData(@NotNull PacketBuffer buf, @NotNull CoverHolder coverHolder) {
        int count = buf.readByte();
        if (count == 0) {
            return;
        }
        for (int i = 0; i < count; ++i) {
            EnumFacing facing = EnumFacing.field_82609_l[buf.readByte()];
            int id = buf.func_150792_a();
            CoverDefinition definition = CoverDefinition.getCoverByNetworkId(id);
            if (definition == null) {
                GTLog.logger.warn("Unable to find CoverDefinition for Network ID {} at position {}", (Object)id, (Object)coverHolder.getPos());
                continue;
            }
            Cover cover = definition.createCover(coverHolder, facing);
            cover.readInitialSyncData(buf);
            coverHolder.addCover(facing, cover);
        }
    }

    public static void writeCoverPlacement(@NotNull CoverHolder coverHolder, int discriminator, @NotNull EnumFacing side, @NotNull Cover cover) {
        coverHolder.writeCustomData(discriminator, buf -> {
            buf.writeByte(side.func_176745_a());
            buf.func_150787_b(CoverDefinition.getNetworkIdForCover(cover.getDefinition()));
            cover.writeInitialSyncData((PacketBuffer)buf);
        });
    }

    public static void readCoverPlacement(@NotNull PacketBuffer buf, @NotNull CoverHolder coverHolder) {
        EnumFacing placementSide = EnumFacing.field_82609_l[buf.readByte()];
        int id = buf.func_150792_a();
        CoverDefinition coverDefinition = CoverDefinition.getCoverByNetworkId(id);
        if (coverDefinition == null) {
            GTLog.logger.warn("Unable to find CoverDefinition for Network ID {} at position {}", (Object)id, (Object)coverHolder.getPos());
        } else {
            Cover cover = coverDefinition.createCover(coverHolder, placementSide);
            coverHolder.addCover(placementSide, cover);
            cover.readInitialSyncData(buf);
        }
        coverHolder.scheduleRenderUpdate();
    }

    public static void writeCoverNBT(@NotNull NBTTagCompound tagCompound, @NotNull CoverableView coverableView) {
        NBTTagList coversList = new NBTTagList();
        for (EnumFacing coverSide : EnumFacing.field_82609_l) {
            Cover cover = coverableView.getCoverAtSide(coverSide);
            if (cover == null) continue;
            NBTTagCompound tag = new NBTTagCompound();
            ResourceLocation coverId = cover.getDefinition().getResourceLocation();
            tag.func_74778_a("CoverId", coverId.toString());
            tag.func_74774_a("Side", (byte)coverSide.func_176745_a());
            cover.writeToNBT(tag);
            coversList.func_74742_a((NBTBase)tag);
        }
        tagCompound.func_74782_a("Covers", (NBTBase)coversList);
    }

    public static void readCoverNBT(@NotNull NBTTagCompound tagCompound, @NotNull CoverHolder coverHolder, @NotNull BiConsumer<EnumFacing, Cover> coverStoreFunction) {
        NBTTagList coversList = tagCompound.func_150295_c("Covers", 10);
        for (int index = 0; index < coversList.func_74745_c(); ++index) {
            NBTTagCompound tag = coversList.func_150305_b(index);
            if (!tag.func_150297_b("CoverId", 8)) continue;
            EnumFacing coverSide = EnumFacing.field_82609_l[tag.func_74771_c("Side")];
            ResourceLocation coverLocation = new ResourceLocation(tag.func_74779_i("CoverId"));
            CoverDefinition coverDefinition = CoverDefinition.getCoverById(coverLocation);
            if (coverDefinition == null) {
                GTLog.logger.warn("Unable to find CoverDefinition for ResourceLocation {} at position {}", (Object)coverLocation, (Object)coverHolder.getPos());
                continue;
            }
            Cover cover = coverDefinition.createCover(coverHolder, coverSide);
            cover.readFromNBT(tag);
            coverStoreFunction.accept(coverSide, cover);
        }
    }
}

