/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.cover;

import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Matrix4;
import gregtech.api.cover.Cover;
import gregtech.api.cover.CoverDefinition;
import gregtech.api.cover.CoverableView;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.client.renderer.texture.Textures;
import gregtech.client.renderer.texture.cube.SimpleSidedCubeRenderer;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;

public abstract class CoverBase
implements Cover {
    private final CoverDefinition definition;
    private final CoverableView coverableView;
    private final EnumFacing attachedSide;

    public CoverBase(@NotNull CoverDefinition definition, @NotNull CoverableView coverableView, @NotNull EnumFacing attachedSide) {
        this.definition = definition;
        this.coverableView = coverableView;
        this.attachedSide = attachedSide;
    }

    @Override
    @NotNull
    public final CoverDefinition getDefinition() {
        return this.definition;
    }

    @Override
    @NotNull
    public final CoverableView getCoverableView() {
        return this.coverableView;
    }

    @Override
    @NotNull
    public final EnumFacing getAttachedSide() {
        return this.attachedSide;
    }

    protected void dropInventoryContents(@NotNull IItemHandlerModifiable inventory) {
        NonNullList drops = NonNullList.func_191196_a();
        MetaTileEntity.clearInventory((NonNullList<ItemStack>)drops, inventory);
        for (ItemStack itemStack : drops) {
            Block.func_180635_a((World)this.getWorld(), (BlockPos)this.getPos(), (ItemStack)itemStack);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderCoverPlate(@NotNull CCRenderState renderState, @NotNull Matrix4 translation, @NotNull IVertexOperation[] pipeline, @NotNull Cuboid6 plateBox, @NotNull BlockRenderLayer layer) {
        TextureAtlasSprite casingSide = this.getPlateSprite();
        for (EnumFacing coverPlateSide : EnumFacing.field_82609_l) {
            boolean isAttachedSide;
            boolean bl = isAttachedSide = this.getAttachedSide().func_176740_k() == coverPlateSide.func_176740_k();
            if (!isAttachedSide && this.getCoverableView().hasCover(coverPlateSide)) continue;
            Textures.renderFace(renderState, translation, pipeline, coverPlateSide, plateBox, casingSide, BlockRenderLayer.CUTOUT_MIPPED);
        }
    }

    @SideOnly(value=Side.CLIENT)
    @NotNull
    protected TextureAtlasSprite getPlateSprite() {
        return Textures.VOLTAGE_CASINGS[1].getSpriteOnSide(SimpleSidedCubeRenderer.RenderSide.SIDE);
    }
}

