/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.capability.impl;

import gregtech.api.capability.IEnergyContainer;
import gregtech.api.capability.impl.AbstractRecipeLogic;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.recipes.RecipeMap;
import java.util.function.Supplier;

public class RecipeLogicEnergy
extends AbstractRecipeLogic {
    protected final Supplier<IEnergyContainer> energyContainer;

    public RecipeLogicEnergy(MetaTileEntity tileEntity, RecipeMap<?> recipeMap, Supplier<IEnergyContainer> energyContainer) {
        super(tileEntity, recipeMap);
        this.energyContainer = energyContainer;
        this.setMaximumOverclockVoltage(this.getMaxVoltage());
    }

    @Override
    protected long getEnergyInputPerSecond() {
        return this.energyContainer.get().getInputPerSec();
    }

    @Override
    protected long getEnergyStored() {
        return this.energyContainer.get().getEnergyStored();
    }

    @Override
    protected long getEnergyCapacity() {
        return this.energyContainer.get().getEnergyCapacity();
    }

    @Override
    protected boolean drawEnergy(int recipeEUt, boolean simulate) {
        long resultEnergy = this.getEnergyStored() - (long)recipeEUt;
        if (resultEnergy >= 0L && resultEnergy <= this.getEnergyCapacity()) {
            if (!simulate) {
                this.energyContainer.get().changeEnergy(-recipeEUt);
            }
            return true;
        }
        return false;
    }

    @Override
    public long getMaxVoltage() {
        return Math.max(this.energyContainer.get().getInputVoltage(), this.energyContainer.get().getOutputVoltage());
    }
}

