/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.capability.impl;

import gregtech.api.capability.IPropertyFluidFilter;
import gregtech.api.fluids.FluidState;
import gregtech.api.fluids.attribute.FluidAttribute;
import gregtech.api.fluids.attribute.FluidAttributes;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.UnmodifiableView;

public class PropertyFluidFilter
implements IPropertyFluidFilter {
    private final Object2BooleanMap<FluidAttribute> containmentPredicate = new Object2BooleanOpenHashMap();
    private final int maxFluidTemperature;
    private final boolean gasProof;
    private final boolean cryoProof;
    private final boolean plasmaProof;

    public PropertyFluidFilter(int maxFluidTemperature, boolean gasProof, boolean acidProof, boolean cryoProof, boolean plasmaProof) {
        this.maxFluidTemperature = maxFluidTemperature;
        this.gasProof = gasProof;
        if (acidProof) {
            this.setCanContain(FluidAttributes.ACID, true);
        }
        this.cryoProof = cryoProof;
        this.plasmaProof = plasmaProof;
    }

    @Override
    public boolean canContain(@NotNull FluidState state) {
        boolean bl;
        switch (state) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case LIQUID: {
                bl = true;
                break;
            }
            case GAS: {
                bl = this.gasProof;
                break;
            }
            case PLASMA: {
                bl = this.plasmaProof;
            }
        }
        return bl;
    }

    @Override
    public boolean canContain(@NotNull FluidAttribute attribute) {
        return this.containmentPredicate.getBoolean((Object)attribute);
    }

    @Override
    public void setCanContain(@NotNull FluidAttribute attribute, boolean canContain) {
        this.containmentPredicate.put((Object)attribute, canContain);
    }

    @Override
    @NotNull
    public @NotNull @UnmodifiableView Collection<@NotNull FluidAttribute> getContainedAttributes() {
        return this.containmentPredicate.keySet();
    }

    @Override
    public int getMaxFluidTemperature() {
        return this.maxFluidTemperature;
    }

    @Override
    public boolean isGasProof() {
        return this.gasProof;
    }

    @Override
    public boolean isCryoProof() {
        return this.cryoProof;
    }

    @Override
    public boolean isPlasmaProof() {
        return this.plasmaProof;
    }

    public String toString() {
        return "SimplePropertyFluidFilter{maxFluidTemperature=" + this.maxFluidTemperature + ", gasProof=" + this.gasProof + ", cryoProof=" + this.cryoProof + ", plasmaProof=" + this.plasmaProof + ", containmentPredicate=" + this.containmentPredicate + '}';
    }
}

