/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.capability.impl;

import gregtech.api.GTValues;
import gregtech.api.capability.FeCompat;
import gregtech.api.capability.GregtechCapabilities;
import gregtech.api.capability.IEnergyContainer;
import gregtech.api.capability.impl.CapabilityCompatProvider;
import gregtech.api.util.GTUtility;
import gregtech.common.ConfigHolder;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import org.jetbrains.annotations.NotNull;

public class EUToFEProvider
extends CapabilityCompatProvider {
    private long feBuffer;

    public EUToFEProvider(TileEntity tileEntity) {
        super((ICapabilityProvider)tileEntity);
    }

    public boolean hasCapability(@NotNull Capability<?> capability, EnumFacing facing) {
        return ConfigHolder.compat.energy.nativeEUToFE && capability == GregtechCapabilities.CAPABILITY_ENERGY_CONTAINER && this.hasUpvalueCapability(CapabilityEnergy.ENERGY, facing);
    }

    public <T> T getCapability(@NotNull Capability<T> capability, EnumFacing facing) {
        if (!ConfigHolder.compat.energy.nativeEUToFE || capability != GregtechCapabilities.CAPABILITY_ENERGY_CONTAINER) {
            return null;
        }
        IEnergyStorage energyStorage = (IEnergyStorage)this.getUpvalueCapability(CapabilityEnergy.ENERGY, facing);
        return (T)(energyStorage != null ? GregtechCapabilities.CAPABILITY_ENERGY_CONTAINER.cast((Object)new GTEnergyWrapper(energyStorage)) : null);
    }

    public static int safeCastLongToInt(long v) {
        return v > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)v;
    }

    public class GTEnergyWrapper
    implements IEnergyContainer {
        private final IEnergyStorage energyStorage;

        public GTEnergyWrapper(IEnergyStorage energyStorage) {
            this.energyStorage = energyStorage;
        }

        @Override
        public long acceptEnergyFromNetwork(EnumFacing facing, long voltage, long amperage) {
            int receive = 0;
            if (EUToFEProvider.this.feBuffer > 0L) {
                receive = this.energyStorage.receiveEnergy(EUToFEProvider.safeCastLongToInt(EUToFEProvider.this.feBuffer), true);
                if (receive == 0) {
                    return 0L;
                }
                if (EUToFEProvider.this.feBuffer > (long)receive) {
                    EUToFEProvider.this.feBuffer -= receive;
                    this.energyStorage.receiveEnergy(receive, false);
                    return 0L;
                }
                receive = EUToFEProvider.safeCastLongToInt(EUToFEProvider.this.feBuffer);
                EUToFEProvider.this.feBuffer = 0L;
            }
            long maxPacket = FeCompat.toFe(voltage, FeCompat.ratio(false));
            long maximalValue = maxPacket * amperage;
            if (receive != 0) {
                int consumable = this.energyStorage.receiveEnergy(EUToFEProvider.safeCastLongToInt(maximalValue + (long)receive), true);
                if (consumable == 0) {
                    return 0L;
                }
                if (consumable == receive) {
                    this.energyStorage.receiveEnergy(consumable, false);
                    return 0L;
                }
                if ((long)consumable == maximalValue + (long)receive) {
                    this.energyStorage.receiveEnergy(consumable, false);
                    return amperage;
                }
                int newPower = consumable - receive;
                if ((long)newPower % maxPacket == 0L) {
                    return (long)this.energyStorage.receiveEnergy(consumable, false) / maxPacket;
                }
                int ampsToConsume = EUToFEProvider.safeCastLongToInt((long)newPower / maxPacket + 1L);
                EUToFEProvider.this.feBuffer = EUToFEProvider.safeCastLongToInt(maxPacket * (long)ampsToConsume - (long)consumable);
                this.energyStorage.receiveEnergy(consumable, false);
                return ampsToConsume;
            }
            int consumable = this.energyStorage.receiveEnergy(EUToFEProvider.safeCastLongToInt(maximalValue), true);
            if (consumable == 0) {
                return 0L;
            }
            if ((long)consumable == maximalValue) {
                this.energyStorage.receiveEnergy(consumable, false);
                return amperage;
            }
            if ((long)consumable % maxPacket == 0L) {
                return (long)this.energyStorage.receiveEnergy(consumable, false) / maxPacket;
            }
            int ampsToConsume = EUToFEProvider.safeCastLongToInt((long)consumable / maxPacket + 1L);
            EUToFEProvider.this.feBuffer = EUToFEProvider.safeCastLongToInt(maxPacket * (long)ampsToConsume - (long)consumable);
            this.energyStorage.receiveEnergy(consumable, false);
            return ampsToConsume;
        }

        @Override
        public long changeEnergy(long delta) {
            if (delta == 0L) {
                return 0L;
            }
            if (delta < 0L) {
                return FeCompat.extractEu(this.energyStorage, -delta);
            }
            return FeCompat.insertEu(this.energyStorage, delta);
        }

        @Override
        public long getEnergyCapacity() {
            return FeCompat.toEu(this.energyStorage.getMaxEnergyStored(), FeCompat.ratio(false));
        }

        @Override
        public long getEnergyStored() {
            return FeCompat.toEu(this.energyStorage.getEnergyStored(), FeCompat.ratio(false));
        }

        @Override
        public long getEnergyCanBeInserted() {
            return Math.max(1L, this.getEnergyCapacity() - this.getEnergyStored());
        }

        @Override
        public long getInputAmperage() {
            return this.getInputVoltage() == 0L ? 0L : 2L;
        }

        @Override
        public long getInputVoltage() {
            long maxInput = this.energyStorage.receiveEnergy(Integer.MAX_VALUE, true);
            if (maxInput == 0L) {
                return 0L;
            }
            return GTValues.V[GTUtility.getTierByVoltage(FeCompat.toEu(maxInput, FeCompat.ratio(false)))];
        }

        @Override
        public boolean inputsEnergy(EnumFacing facing) {
            return this.energyStorage.canReceive();
        }

        @Override
        public boolean outputsEnergy(EnumFacing facing) {
            return false;
        }

        @Override
        public boolean isOneProbeHidden() {
            return true;
        }
    }
}

