/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.capability;

import java.util.Comparator;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;

@FunctionalInterface
public interface IFilter<T>
extends Predicate<T> {
    public static final Comparator<IFilter<?>> FILTER_COMPARATOR = Comparator.comparingInt(IFilter::getPriority).reversed();

    @Override
    public boolean test(@NotNull T var1);

    default public int getPriority() {
        return 0;
    }

    @Override
    @NotNull
    default public IFilter<T> negate() {
        return new IFilter<T>(){

            @Override
            public boolean test(@NotNull T t) {
                return !IFilter.this.test(t);
            }

            @Override
            public int getPriority() {
                return -IFilter.this.getPriority();
            }

            @Override
            @NotNull
            public IFilter<T> negate() {
                return IFilter.this;
            }
        };
    }

    public static int whitelistPriority(int whitelistSize) {
        return Integer.MAX_VALUE - whitelistSize;
    }

    public static int blacklistPriority(int blacklistSize) {
        return -2147483647 + blacklistSize;
    }

    public static int whitelistLikePriority() {
        return 1000;
    }

    public static int blacklistLikePriority() {
        return -1000;
    }

    public static int firstPriority() {
        return Integer.MAX_VALUE;
    }

    public static int lastPriority() {
        return -2147483647;
    }

    public static int noPriority() {
        return Integer.MIN_VALUE;
    }
}

