/*
 * Decompiled with CFR 0.152.
 */
package gregtechfoodoption.worldgen.trees;

import gregtech.api.util.function.TriConsumer;
import gregtechfoodoption.GTFOMaterialHandler;
import gregtechfoodoption.utils.GTFOUtils;
import gregtechfoodoption.worldgen.condition.BiomeCondition;
import gregtechfoodoption.worldgen.condition.TemperatureRainfallCondition;
import gregtechfoodoption.worldgen.trees.GTFOTree;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Biomes;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;

public class RainbowwoodTree
extends GTFOTree {
    public static final int[] RAINBOW_ARRAY = new int[]{0xFF0000, 0xFF4000, 0xFF8000, 0xFFC000, 0xFFFF00, 0xC0FF00, 0x80FF00, 0x40FF00, 65280, 65344, 65408, 65472, 65535, 49407, 33023, 16639, 255, 0x4000FF, 0x8000FF, 0xC000FF, 0xFF00FF, 0xFF00C0, 0xFF0080, 0xFF0040};

    public RainbowwoodTree() {
        super("rainbowwood", 7);
        this.addCondition(new BiomeCondition(Biomes.field_76772_c, 5, 0.89));
        this.addCondition(new BiomeCondition(Biomes.field_185441_Q, 5, 0.89));
        this.addCondition(new TemperatureRainfallCondition(5, 0.5, 0.8, 0.4, 0.1));
    }

    @Override
    public int getMinTrunkHeight(Random random) {
        return random.nextInt(3) + 6;
    }

    @Override
    protected void generateLeaves(World world, BlockPos.MutableBlockPos pos, int height, Random random, TriConsumer<World, BlockPos, IBlockState> notifier) {
        BlockPos.MutableBlockPos currentYPos = GTFOUtils.copy((BlockPos)pos);
        currentYPos.func_189534_c(EnumFacing.UP, height - 3);
        for (int i = 0; i < 7; ++i) {
            int layerSize = this.getMooreRadiusAtHeight(i + height - 3, height);
            Iterable iterator = BlockPos.func_177980_a((BlockPos)currentYPos.func_177967_a(EnumFacing.NORTH, layerSize).func_177967_a(EnumFacing.WEST, layerSize), (BlockPos)currentYPos.func_177967_a(EnumFacing.SOUTH, layerSize).func_177967_a(EnumFacing.EAST, layerSize));
            iterator.forEach(leavesPos -> {
                if (Math.abs(leavesPos.func_177958_n() - currentYPos.func_177958_n()) + Math.abs(leavesPos.func_177952_p() - currentYPos.func_177952_p()) < 6) {
                    notifier.accept((Object)world, leavesPos, (Object)this.getNaturalLeavesState());
                }
            });
            currentYPos.func_189536_c(EnumFacing.UP);
        }
    }

    @Override
    public int getBlockColor(IBlockState state, IBlockAccess worldIn, BlockPos pos, int tintIndex) {
        return RAINBOW_ARRAY[(Math.abs(pos.func_177958_n()) + Math.abs(pos.func_177956_o()) + Math.abs(pos.func_177952_p())) % RAINBOW_ARRAY.length];
    }

    @Override
    public int getItemColor(ItemStack stack, int tintIndex) {
        return 0x8F00FF;
    }

    @Override
    protected int getMooreRadiusAtHeight(int height, int trunkHeight) {
        if (height < trunkHeight - 3) {
            return 0;
        }
        if (height == trunkHeight - 3) {
            return 2;
        }
        if (height < trunkHeight + 3) {
            return 3;
        }
        return 2;
    }

    @Override
    public double getPerlinScale() {
        return 0.05;
    }

    @Override
    public Fluid getSap() {
        return GTFOMaterialHandler.RainbowSap.getFluid();
    }
}

