/*
 * Decompiled with CFR 0.152.
 */
package gregtechfoodoption.worldgen.trees;

import gregtech.api.util.function.TriConsumer;
import gregtechfoodoption.GTFOValues;
import gregtechfoodoption.item.GTFOMetaItem;
import gregtechfoodoption.utils.GTFOUtils;
import gregtechfoodoption.worldgen.condition.BiomeCondition;
import gregtechfoodoption.worldgen.condition.TemperatureRainfallCondition;
import gregtechfoodoption.worldgen.trees.GTFOTree;
import java.util.Random;
import net.minecraft.block.BlockLog;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Biomes;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class OliveTree
extends GTFOTree {
    public static int LEAVES_COLOR = 8556122;

    public OliveTree() {
        super("olive", 6);
        this.addCondition(new BiomeCondition(Biomes.field_150583_P, 5, 0.55));
        this.addCondition(new BiomeCondition(Biomes.field_76767_f, 2, 0.65));
        this.addCondition(new BiomeCondition(Biomes.field_76772_c, 1, 0.88));
        this.addCondition(new TemperatureRainfallCondition(3, 1.5, 0.6, 0.6, 0.3));
    }

    @Override
    protected void generateTrunk(World world, BlockPos.MutableBlockPos pos, int maxHeight, Random random, TriConsumer<World, BlockPos, IBlockState> notifier) {
        BlockPos.MutableBlockPos upN = GTFOUtils.copy((BlockPos)pos);
        BlockPos.MutableBlockPos upNSplit = GTFOUtils.copy((BlockPos)upN);
        EnumFacing splitDirection = EnumFacing.func_176731_b((int)random.nextInt(4));
        int splittingHeight = maxHeight - 1 - random.nextInt(3);
        for (int height = 0; height < maxHeight; ++height) {
            IBlockState state = world.func_180495_p((BlockPos)upN);
            if (state.func_177230_c().isAir(state, (IBlockAccess)world, (BlockPos)upN) || state.func_177230_c().isLeaves(state, (IBlockAccess)world, (BlockPos)upN)) {
                notifier.accept((Object)world, (Object)upN, (Object)this.logState.func_177226_a((IProperty)BlockLog.field_176299_a, (Comparable)BlockLog.EnumAxis.Y));
            }
            if (height == splittingHeight) {
                upNSplit.func_189536_c(splitDirection);
            }
            if (height >= splittingHeight) {
                notifier.accept((Object)world, (Object)upNSplit, (Object)this.logState.func_177226_a((IProperty)BlockLog.field_176299_a, (Comparable)BlockLog.EnumAxis.Y));
                if (random.nextInt(2) == 0) {
                    upNSplit.func_189536_c(splitDirection);
                }
            }
            upN.func_189536_c(EnumFacing.UP);
            upNSplit.func_189536_c(EnumFacing.UP);
        }
    }

    @Override
    protected void generateLeaves(World world, BlockPos.MutableBlockPos pos, int trunkHeight, Random random, TriConsumer<World, BlockPos, IBlockState> notifier) {
        BlockPos.MutableBlockPos currentYPos = GTFOUtils.copy((BlockPos)pos);
        currentYPos.func_189534_c(EnumFacing.UP, trunkHeight);
        for (int i = 25; i > 0; i -= random.nextInt(8) + 13) {
            int layerSize = (int)Math.ceil(Math.sqrt(i));
            Iterable iterator = BlockPos.func_177980_a((BlockPos)currentYPos.func_177967_a(EnumFacing.NORTH, layerSize).func_177967_a(EnumFacing.WEST, layerSize), (BlockPos)currentYPos.func_177967_a(EnumFacing.SOUTH, layerSize).func_177967_a(EnumFacing.EAST, layerSize));
            int finalI = i;
            iterator.forEach(leavesPos -> {
                if ((double)(Math.abs(leavesPos.func_177958_n() - currentYPos.func_177958_n()) + Math.abs(leavesPos.func_177952_p() - currentYPos.func_177952_p())) <= Math.sqrt(finalI)) {
                    notifier.accept((Object)world, leavesPos, (Object)this.getNaturalLeavesState());
                }
            });
            currentYPos.func_189536_c(EnumFacing.UP);
        }
    }

    @Override
    public int getBlockColor(IBlockState state, IBlockAccess worldIn, BlockPos pos, int tintIndex) {
        return LEAVES_COLOR;
    }

    @Override
    public int getItemColor(ItemStack stack, int tintIndex) {
        return LEAVES_COLOR;
    }

    @Override
    protected int getMooreRadiusAtHeight(int height, int trunkHeight) {
        if (height < trunkHeight - 3) {
            return 0;
        }
        if (height < trunkHeight) {
            return 4 - (trunkHeight - height);
        }
        return 0;
    }

    @Override
    public ItemStack getAppleDrop(int chance) {
        if (GTFOValues.rand.nextInt(chance / 15) == 0) {
            return GTFOMetaItem.OLIVE.getStackForm(GTFOValues.rand.nextInt(4) + 1);
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public ItemStack getApple() {
        return GTFOMetaItem.OLIVE.getStackForm();
    }
}

