/*
 * Decompiled with CFR 0.152.
 */
package gregtechfoodoption.worldgen.trees;

import gregtech.api.util.function.TriConsumer;
import gregtechfoodoption.GTFOValues;
import gregtechfoodoption.item.GTFOMetaItem;
import gregtechfoodoption.utils.GTFOUtils;
import gregtechfoodoption.worldgen.condition.BiomeCondition;
import gregtechfoodoption.worldgen.condition.TemperatureRainfallCondition;
import gregtechfoodoption.worldgen.trees.GTFOTree;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Biomes;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class NutmegTree
extends GTFOTree {
    public static int LEAVES_COLOR = 7190054;

    public NutmegTree() {
        super("nutmeg", 8);
        this.addCondition(new BiomeCondition(Biomes.field_76782_w, 3, 0.3));
        this.addCondition(new TemperatureRainfallCondition(3, 1.2, 0.85, 1.0, 0.3));
    }

    @Override
    public int getBlockColor(IBlockState state, IBlockAccess worldIn, BlockPos pos, int tintIndex) {
        return LEAVES_COLOR;
    }

    @Override
    public int getItemColor(ItemStack stack, int tintIndex) {
        return LEAVES_COLOR;
    }

    @Override
    protected void generateLeaves(World world, BlockPos.MutableBlockPos pos, int trunkHeight, Random random, TriConsumer<World, BlockPos, IBlockState> notifier) {
        BlockPos.MutableBlockPos currentYPos = GTFOUtils.copy((BlockPos)pos);
        currentYPos.func_189534_c(EnumFacing.UP, trunkHeight - 2);
        for (double i = 3.0; i > 0.0; i -= random.nextDouble() / 2.0 + 0.5) {
            int layerSize = (int)Math.ceil(i);
            Iterable iterator = BlockPos.func_177980_a((BlockPos)currentYPos.func_177967_a(EnumFacing.NORTH, layerSize).func_177967_a(EnumFacing.WEST, layerSize), (BlockPos)currentYPos.func_177967_a(EnumFacing.SOUTH, layerSize).func_177967_a(EnumFacing.EAST, layerSize));
            double finalI = i;
            iterator.forEach(leavesPos -> {
                if (Math.pow(Math.pow(Math.abs(leavesPos.func_177958_n() - currentYPos.func_177958_n()), 2.0) + Math.pow(Math.abs(leavesPos.func_177952_p() - currentYPos.func_177952_p()), 2.0), 0.5) <= finalI) {
                    notifier.accept((Object)world, leavesPos, (Object)this.getNaturalLeavesState());
                }
            });
            currentYPos.func_189536_c(EnumFacing.UP);
        }
        notifier.accept((Object)world, (Object)GTFOUtils.copy((BlockPos)pos).func_189534_c(EnumFacing.UP, trunkHeight), (Object)this.getNaturalLeavesState());
    }

    @Override
    public ItemStack getAppleDrop(int chance) {
        if (GTFOValues.rand.nextInt(chance / 10) == 0) {
            return GTFOMetaItem.NUTMEG_SEED.getStackForm(GTFOValues.rand.nextInt(2) + 1);
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public ItemStack getApple() {
        return GTFOMetaItem.NUTMEG_SEED.getStackForm();
    }
}

