/*
 * Decompiled with CFR 0.152.
 */
package gregtechfoodoption.worldgen.trees;

import gregtech.api.util.function.TriConsumer;
import gregtechfoodoption.GTFOValues;
import gregtechfoodoption.item.GTFOMetaItem;
import gregtechfoodoption.utils.GTFOUtils;
import gregtechfoodoption.worldgen.condition.BiomeCondition;
import gregtechfoodoption.worldgen.condition.TemperatureRainfallCondition;
import gregtechfoodoption.worldgen.trees.GTFOTree;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Biomes;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class ApricotTree
extends GTFOTree {
    public static int LEAVES_COLOR = 8890668;

    public ApricotTree() {
        super("apricot", 3);
        this.addCondition(new BiomeCondition(Biomes.field_185435_ag, 4, 0.4));
        this.addCondition(new BiomeCondition(Biomes.field_150588_X, 2, 0.55));
        this.addCondition(new TemperatureRainfallCondition(2, 1.2, 1.2, 0.05, 0.2));
    }

    @Override
    protected void generateLeaves(World world, BlockPos.MutableBlockPos pos, int trunkHeight, Random random, TriConsumer<World, BlockPos, IBlockState> notifier) {
        BlockPos.MutableBlockPos currentYPos = GTFOUtils.copy((BlockPos)pos);
        currentYPos.func_189534_c(EnumFacing.UP, trunkHeight - 4);
        boolean atBottom = true;
        for (int i = 8; i > 0; i -= random.nextInt(3) + 3) {
            int layerSize = (int)Math.ceil(Math.sqrt(i));
            Iterable iterator = BlockPos.func_177980_a((BlockPos)currentYPos.func_177967_a(EnumFacing.NORTH, layerSize).func_177967_a(EnumFacing.WEST, layerSize), (BlockPos)currentYPos.func_177967_a(EnumFacing.SOUTH, layerSize).func_177967_a(EnumFacing.EAST, layerSize));
            int finalI = i;
            iterator.forEach(leavesPos -> {
                if ((double)(Math.abs(leavesPos.func_177958_n() - currentYPos.func_177958_n()) + Math.abs(leavesPos.func_177952_p() - currentYPos.func_177952_p())) <= Math.sqrt(finalI)) {
                    notifier.accept((Object)world, leavesPos, (Object)this.getNaturalLeavesState());
                }
            });
            if (atBottom) {
                i += 7;
                atBottom = false;
            }
            currentYPos.func_189536_c(EnumFacing.UP);
        }
        notifier.accept((Object)world, (Object)GTFOUtils.copy((BlockPos)pos).func_189534_c(EnumFacing.UP, trunkHeight), (Object)this.getNaturalLeavesState());
    }

    @Override
    public int getMinTrunkHeight(Random random) {
        return super.getMinTrunkHeight(random);
    }

    @Override
    public int getBlockColor(IBlockState state, IBlockAccess worldIn, BlockPos pos, int tintIndex) {
        return LEAVES_COLOR;
    }

    @Override
    public int getItemColor(ItemStack stack, int tintIndex) {
        return LEAVES_COLOR;
    }

    @Override
    public ItemStack getAppleDrop(int chance) {
        if (GTFOValues.rand.nextInt(chance / 15) == 0) {
            return GTFOMetaItem.APRICOT.getStackForm();
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public ItemStack getApple() {
        return GTFOMetaItem.APRICOT.getStackForm();
    }
}

