/*
 * Decompiled with CFR 0.152.
 */
package gregtechfoodoption.worldgen;

import gregtech.common.ConfigHolder;
import gregtechfoodoption.worldgen.GTFOFeature;
import gregtechfoodoption.worldgen.condition.FeatureCondition;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.gen.feature.WorldGenerator;

public abstract class GTFOFeatureGen
extends WorldGenerator {
    public final GTFOFeature feature;

    protected GTFOFeatureGen(boolean notify, GTFOFeature feature) {
        super(notify);
        this.feature = feature;
    }

    public boolean func_180709_b(@Nonnull World world, @Nonnull Random random, @Nonnull BlockPos pos) {
        return this.generateImpl(world, random, new BlockPos.MutableBlockPos(pos));
    }

    public void setBlockSafely(World worldIn, BlockPos pos, IBlockState state) {
        if (worldIn.func_180495_p(pos).func_177230_c().canBeReplacedByLeaves(worldIn.func_180495_p(pos), (IBlockAccess)worldIn, pos)) {
            this.func_175903_a(worldIn, pos, state);
        }
    }

    public int getAmountInChunk(List<FeatureCondition> conditions, int chunkX, int chunkZ, World world, BlockPos pos) {
        Biome biome = world.func_180494_b(pos);
        Optional<FeatureCondition> relevantCondition = conditions.stream().filter(biomeCondition -> biomeCondition.isSatisfied(biome)).findFirst();
        double treeStrength = this.feature.getRandomStrength(chunkX, chunkZ);
        if (!ConfigHolder.misc.debug) {
            if (relevantCondition.isPresent() && relevantCondition.get().getPerlinCutoff(biome) < treeStrength) {
                double perlinCutoff = relevantCondition.get().getPerlinCutoff(biome);
                double maxTrees = relevantCondition.get().getMaxFeatures();
                return (int)Math.ceil(maxTrees - perlinCutoff * maxTrees);
            }
        } else if (relevantCondition.isPresent()) {
            if (relevantCondition.get().getPerlinCutoff(biome) < treeStrength) {
                this.feature.updatePlacePercentage(true);
                double perlinCutoff = relevantCondition.get().getPerlinCutoff(biome);
                double maxTrees = relevantCondition.get().getMaxFeatures();
                return (int)Math.ceil(maxTrees - perlinCutoff * maxTrees);
            }
            this.feature.updatePlacePercentage(false);
        }
        return 0;
    }

    public boolean generateInChunk(@Nonnull World world, @Nonnull Random random, int chunkX, int chunkZ) {
        if (!this.configOption()) {
            return false;
        }
        Chunk chunk = world.func_72964_e(chunkX, chunkZ);
        int seaLevel = chunk.func_177412_p().func_181545_F();
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(chunk.func_76632_l().func_180331_a(8, seaLevel, 8));
        int featureCount = this.getAmountInChunk(this.feature.featureConditions, chunkX, chunkZ, world, (BlockPos)pos);
        if (featureCount > 0) {
            for (int j = 0; j < featureCount; ++j) {
                pos.func_181079_c(chunk.field_76635_g * 16 + random.nextInt(16) + 8, 255, chunk.field_76647_h * 16 + random.nextInt(16) + 8);
                while (world.func_175623_d((BlockPos)pos) && pos.func_177956_o() != 0) {
                    pos.func_185336_p(pos.func_177956_o() - 1);
                }
                pos.func_185336_p(pos.func_177956_o() + 1);
                if (this.generateImpl(chunk.func_177412_p(), random, pos)) continue;
                --featureCount;
            }
            return true;
        }
        return false;
    }

    public abstract boolean configOption();

    public abstract boolean generateImpl(World var1, Random var2, BlockPos.MutableBlockPos var3);
}

