/*
 * Decompiled with CFR 0.152.
 */
package gregtechfoodoption.recipe.builder;

import gregtech.api.recipes.Recipe;
import gregtech.api.recipes.RecipeBuilder;
import gregtech.api.recipes.RecipeMap;
import gregtech.api.recipes.recipeproperties.RecipeProperty;
import gregtechfoodoption.recipe.properties.CauseDamageProperty;
import gregtechfoodoption.recipe.properties.MobOnTopProperty;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class MobProximityRecipeBuilder
extends RecipeBuilder<MobProximityRecipeBuilder> {
    public MobProximityRecipeBuilder() {
    }

    public MobProximityRecipeBuilder(Recipe recipe, RecipeMap<MobProximityRecipeBuilder> recipeMap) {
        super(recipe, recipeMap);
    }

    public MobProximityRecipeBuilder(RecipeBuilder<MobProximityRecipeBuilder> recipeBuilder) {
        super(recipeBuilder);
    }

    public MobProximityRecipeBuilder copy() {
        return new MobProximityRecipeBuilder(this);
    }

    public boolean applyProperty(String key, Object value) {
        if (key.equals("mob_on_top")) {
            this.mob((ResourceLocation)value);
            return true;
        }
        if (key.equals("cause_damage")) {
            this.causeDamage(((Number)value).floatValue());
            return true;
        }
        return true;
    }

    public MobProximityRecipeBuilder mob(ResourceLocation entityID) {
        this.applyProperty(MobOnTopProperty.getInstance(), entityID);
        return this;
    }

    public MobProximityRecipeBuilder mob(Class<? extends Entity> clazz) {
        this.applyProperty(MobOnTopProperty.getInstance(), EntityList.func_191306_a(clazz));
        return this;
    }

    public MobProximityRecipeBuilder causeDamage(float damage) {
        this.applyProperty(CauseDamageProperty.getInstance(), Float.valueOf(damage));
        return this;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).appendSuper(super.toString()).append(MobOnTopProperty.getInstance().getKey(), (Object)this.getEntityID()).append(CauseDamageProperty.getInstance().getKey(), this.getDamage()).toString();
    }

    public ResourceLocation getEntityID() {
        return this.recipePropertyStorage == null ? new ResourceLocation("lightning_bolt") : (ResourceLocation)this.recipePropertyStorage.getRecipePropertyValue((RecipeProperty)MobOnTopProperty.getInstance(), (Object)new ResourceLocation("lightning_bolt"));
    }

    public float getDamage() {
        return this.recipePropertyStorage == null ? 0.0f : ((Float)this.recipePropertyStorage.getRecipePropertyValue((RecipeProperty)CauseDamageProperty.getInstance(), (Object)Float.valueOf(0.0f))).floatValue();
    }
}

