/*
 * Decompiled with CFR 0.152.
 */
package gregtechfoodoption.recipe.builder;

import gregtech.api.recipes.RecipeBuilder;
import gregtech.api.recipes.recipeproperties.RecipeProperty;
import gregtech.api.util.EnumValidationResult;
import gregtech.api.util.GTLog;
import gregtechfoodoption.machines.multiblock.MetaTileEntityElectricBakingOven;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class ElectricBakingOvenRecipeBuilder
extends RecipeBuilder<ElectricBakingOvenRecipeBuilder> {
    private int temp;

    public ElectricBakingOvenRecipeBuilder() {
    }

    public ElectricBakingOvenRecipeBuilder(RecipeBuilder<ElectricBakingOvenRecipeBuilder> recipeBuilder) {
        super(recipeBuilder);
    }

    public ElectricBakingOvenRecipeBuilder copy() {
        return new ElectricBakingOvenRecipeBuilder(this);
    }

    public ElectricBakingOvenRecipeBuilder setTemp(int temperature) {
        this.temp = temperature;
        this.applyProperty(TemperatureProperty.getInstance(), temperature);
        return this;
    }

    public boolean applyProperty(@Nonnull String key, Object value) {
        if (key.equals("temperature")) {
            this.setTemp(((Number)value).intValue());
            return true;
        }
        return super.applyProperty(key, value);
    }

    protected EnumValidationResult finalizeAndValidate() {
        if (this.temp <= 300) {
            GTLog.logger.error("Temperature cannot be less or equal to 300", (Throwable)new IllegalArgumentException());
            this.recipeStatus = EnumValidationResult.INVALID;
        }
        this.EUt(MetaTileEntityElectricBakingOven.temperatureEnergyCost(this.temp, 1));
        return this.recipeStatus;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).appendSuper(super.toString()).append(TemperatureProperty.getInstance().getKey(), this.temp).toString();
    }

    public static class TemperatureProperty
    extends RecipeProperty<Integer> {
        public static final String KEY = "temperature";
        private static TemperatureProperty INSTANCE;

        protected TemperatureProperty() {
            super(KEY, Integer.class);
        }

        public static TemperatureProperty getInstance() {
            if (INSTANCE == null) {
                INSTANCE = new TemperatureProperty();
            }
            return INSTANCE;
        }

        public void drawInfo(Minecraft minecraft, int x, int y, int color, Object value) {
            minecraft.field_71466_p.func_78276_b(I18n.func_135052_a((String)"gregtechfoodoption.recipe.baking_oven_temperature", (Object[])new Object[]{value}), x, y, color);
        }
    }
}

