/*
 * Decompiled with CFR 0.152.
 */
package gregtechfoodoption.recipe;

import gregtech.api.block.VariantBlock;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.recipes.ModHandler;
import gregtech.api.recipes.RecipeMaps;
import gregtech.api.recipes.builders.AssemblerRecipeBuilder;
import gregtech.api.unification.material.MarkerMaterials;
import gregtech.api.unification.material.Material;
import gregtech.api.unification.material.Materials;
import gregtech.api.unification.ore.OrePrefix;
import gregtech.api.unification.stack.UnificationEntry;
import gregtech.common.blocks.BlockFrame;
import gregtech.common.blocks.BlockMetalCasing;
import gregtech.common.blocks.BlockWireCoil;
import gregtech.common.blocks.MetaBlocks;
import gregtech.common.items.MetaItems;
import gregtech.common.metatileentities.MetaTileEntities;
import gregtech.loaders.recipe.CraftingComponent;
import gregtech.loaders.recipe.MetaTileEntityLoader;
import gregtechfoodoption.block.GTFOBlockCasing;
import gregtechfoodoption.block.GTFOMetaBlocks;
import gregtechfoodoption.block.GTFOMetalCasing;
import gregtechfoodoption.item.GTFOMetaItem;
import gregtechfoodoption.machines.GTFOTileEntities;
import java.util.Arrays;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.Loader;

public class GTFOMachineRecipes {
    public static void init() {
        CraftingComponent.Component DENSE_PLATE = new CraftingComponent.Component(Stream.of({0, new UnificationEntry(OrePrefix.plate, Materials.WroughtIron)}, {1, new UnificationEntry(OrePrefix.plate, Materials.Steel)}, {2, new UnificationEntry(OrePrefix.plateDense, Materials.Aluminium)}, {3, new UnificationEntry(OrePrefix.plateDense, Materials.StainlessSteel)}, {4, new UnificationEntry(OrePrefix.plateDense, Materials.Titanium)}, {5, new UnificationEntry(OrePrefix.plateDense, Materials.TungstenSteel)}, {6, new UnificationEntry(OrePrefix.plateDense, Materials.RhodiumPlatedPalladium)}, {7, new UnificationEntry(OrePrefix.plateDense, Materials.NaquadahAlloy)}, {8, new UnificationEntry(OrePrefix.plateDense, Materials.Darmstadtium)}, {9, new UnificationEntry(OrePrefix.plateDense, Materials.Neutronium)}).collect(Collectors.toMap(data -> (Integer)data[0], data -> data[1])));
        if (Loader.isModLoaded((String)"gcys")) {
            DENSE_PLATE.appendIngredients(Stream.of(new Object[0][]).collect(Collectors.toMap(data -> (Integer)data[0], data -> data[1])));
        }
        MetaTileEntityLoader.registerMachineRecipe((MetaTileEntity[])GTFOTileEntities.SLICER, (Object[])new Object[]{"PCA", "SHC", "LOA", Character.valueOf('P'), CraftingComponent.PISTON, Character.valueOf('C'), CraftingComponent.CIRCUIT, Character.valueOf('A'), CraftingComponent.CABLE, Character.valueOf('S'), CraftingComponent.SAWBLADE, Character.valueOf('H'), CraftingComponent.HULL, Character.valueOf('L'), DENSE_PLATE, Character.valueOf('O'), CraftingComponent.CONVEYOR});
        MetaTileEntityLoader.registerMachineRecipe((MetaTileEntity[])GTFOTileEntities.CUISINE_ASSEMBLER, (Object[])new Object[]{"AOC", "RHR", "AOC", Character.valueOf('C'), CraftingComponent.CIRCUIT, Character.valueOf('A'), CraftingComponent.CABLE, Character.valueOf('R'), CraftingComponent.ROBOT_ARM, Character.valueOf('H'), CraftingComponent.HULL, Character.valueOf('O'), CraftingComponent.CONVEYOR});
        MetaTileEntityLoader.registerMachineRecipe((MetaTileEntity[])GTFOTileEntities.MICROWAVE, (Object[])new Object[]{"LAC", "LHE", "LMC", Character.valueOf('H'), CraftingComponent.HULL, Character.valueOf('M'), CraftingComponent.MOTOR, Character.valueOf('E'), CraftingComponent.EMITTER, Character.valueOf('C'), CraftingComponent.CIRCUIT, Character.valueOf('A'), CraftingComponent.CABLE, Character.valueOf('L'), new UnificationEntry(OrePrefix.plate, Materials.Lead)});
        MetaTileEntityLoader.registerMachineRecipe((MetaTileEntity[])GTFOTileEntities.MOB_AGE_SORTER, (Object[])new Object[]{"OWS", "OHW", "OCW", Character.valueOf('O'), CraftingComponent.CONVEYOR, Character.valueOf('W'), CraftingComponent.CABLE, Character.valueOf('H'), CraftingComponent.HULL, Character.valueOf('C'), CraftingComponent.CIRCUIT, Character.valueOf('S'), CraftingComponent.SENSOR});
        MetaTileEntityLoader.registerMachineRecipe((MetaTileEntity[])GTFOTileEntities.MOB_EXTERMINATOR, (Object[])new Object[]{"EIE", "WHW", "CSC", Character.valueOf('E'), CraftingComponent.EMITTER, Character.valueOf('W'), CraftingComponent.CABLE, Character.valueOf('I'), CraftingComponent.WIRE_QUAD, Character.valueOf('H'), CraftingComponent.HULL, Character.valueOf('C'), CraftingComponent.CIRCUIT, Character.valueOf('S'), CraftingComponent.SENSOR});
        MetaTileEntityLoader.registerMachineRecipe((MetaTileEntity[])GTFOTileEntities.MOB_EXTRACTOR, (Object[])new Object[]{"BCE", "PME", "WCW", Character.valueOf('M'), CraftingComponent.HULL, Character.valueOf('E'), CraftingComponent.PISTON, Character.valueOf('P'), CraftingComponent.PUMP, Character.valueOf('C'), CraftingComponent.CIRCUIT, Character.valueOf('W'), CraftingComponent.CABLE, Character.valueOf('B'), CraftingComponent.SAWBLADE});
        MetaTileEntityLoader.registerMachineRecipe((MetaTileEntity[])GTFOTileEntities.FARMER, (Object[])new Object[]{"BEP", "WMW", "CWC", Character.valueOf('M'), CraftingComponent.HULL, Character.valueOf('E'), CraftingComponent.EMITTER, Character.valueOf('P'), CraftingComponent.PISTON, Character.valueOf('C'), CraftingComponent.CIRCUIT, Character.valueOf('W'), CraftingComponent.CABLE_QUAD, Character.valueOf('B'), CraftingComponent.SENSOR});
        MetaTileEntityLoader.registerMachineRecipe((MetaTileEntity[])GTFOTileEntities.MULTICOOKER, (Object[])new Object[]{"CGC", "GHG", "WMW", Character.valueOf('G'), CraftingComponent.GLASS, Character.valueOf('H'), CraftingComponent.HULL, Character.valueOf('C'), CraftingComponent.CIRCUIT, Character.valueOf('W'), CraftingComponent.COIL_HEATING_DOUBLE, Character.valueOf('M'), CraftingComponent.MOTOR});
        ModHandler.addShapedRecipe((String)"baking_oven", (ItemStack)GTFOTileEntities.BAKING_OVEN.getStackForm(), (Object[])new Object[]{"dSS", "RRA", "fSS", Character.valueOf('S'), new UnificationEntry(OrePrefix.screw, Materials.Iron), Character.valueOf('R'), new UnificationEntry(OrePrefix.stick, Materials.Iron), Character.valueOf('A'), GTFOMetaBlocks.GTFO_CASING.getItemVariant(GTFOBlockCasing.CasingType.ADOBE_BRICKS)});
        ModHandler.addShapedRecipe((String)"baking_oven2", (ItemStack)GTFOTileEntities.BAKING_OVEN.getStackForm(), (Object[])new Object[]{"dRR", "RRA", "fRR", Character.valueOf('R'), new UnificationEntry(OrePrefix.stick, Materials.Iron), Character.valueOf('A'), GTFOMetaBlocks.GTFO_CASING.getItemVariant(GTFOBlockCasing.CasingType.ADOBE_BRICKS)});
        ModHandler.addShapedRecipe((String)"steam_baking_oven", (ItemStack)GTFOTileEntities.STEAM_BAKING_OVEN.getStackForm(), (Object[])new Object[]{"dSG", "PAR", "fSG", Character.valueOf('S'), new UnificationEntry(OrePrefix.screw, Materials.Steel), Character.valueOf('P'), GTFOMetaBlocks.GTFO_CASING.getItemVariant(GTFOBlockCasing.CasingType.REINFORCED_ADOBE_BRICKS), Character.valueOf('R'), new UnificationEntry(OrePrefix.pipeSmallFluid, Materials.Bronze), Character.valueOf('G'), new UnificationEntry(OrePrefix.gear, Materials.Invar), Character.valueOf('A'), GTFOTileEntities.BAKING_OVEN.getStackForm()});
        ModHandler.addShapedRecipe((String)"electric_baking_oven", (ItemStack)GTFOTileEntities.ELECTRIC_BAKING_OVEN.getStackForm(), (Object[])new Object[]{"CPC", "IWI", "CAC", Character.valueOf('C'), GTFOMetaBlocks.GTFO_METAL_CASING.getItemVariant(GTFOMetalCasing.CasingType.BISMUTH_BRONZE_CASING), Character.valueOf('P'), MetaItems.ELECTRIC_PUMP_MV, Character.valueOf('I'), new UnificationEntry(OrePrefix.circuit, MarkerMaterials.Tier.MV), Character.valueOf('W'), new UnificationEntry(OrePrefix.wireGtQuadruple, Materials.Cupronickel), Character.valueOf('A'), MetaBlocks.WIRE_COIL.getItemVariant((Enum)BlockWireCoil.CoilType.CUPRONICKEL)});
        ModHandler.addShapedRecipe((String)"kitchen", (ItemStack)GTFOTileEntities.KITCHEN.getStackForm(), (Object[])new Object[]{"PIP", "ICI", "RWR", Character.valueOf('C'), MetaBlocks.METAL_CASING.getItemVariant((Enum)BlockMetalCasing.MetalCasingType.STEEL_SOLID), Character.valueOf('R'), MetaItems.ROBOT_ARM_MV, Character.valueOf('I'), new UnificationEntry(OrePrefix.circuit, MarkerMaterials.Tier.MV), Character.valueOf('W'), new UnificationEntry(OrePrefix.cableGtQuadruple, Materials.AnnealedCopper), Character.valueOf('P'), new UnificationEntry(OrePrefix.plate, Materials.BismuthBronze)});
        ModHandler.addShapelessRecipe((String)"kitchen_recipe_pencil", (ItemStack)GTFOMetaItem.KITCHEN_RECIPE.getStackForm(), (Object[])new Object[]{Items.field_151121_aF, "dustGraphite"});
        ModHandler.addShapelessRecipe((String)"kitchen_recipe_pen", (ItemStack)GTFOMetaItem.KITCHEN_RECIPE.getStackForm(), (Object[])new Object[]{Items.field_151121_aF, MetaItems.DYE_ONLY_ITEMS[EnumDyeColor.BLACK.ordinal()]});
        Arrays.stream(GTFOMetalCasing.CasingType.values()).forEach(casing -> GTFOMachineRecipes.registerMetalCasingRecipe(casing.getMaterial(), GTFOMetaBlocks.GTFO_METAL_CASING, casing));
        ((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder()).EUt(120)).duration(400)).inputs(new ItemStack[]{MetaTileEntities.HULL[2].getStackForm(), MetaItems.ELECTRIC_PUMP_MV.getStackForm(2)})).input(OrePrefix.circuit, MarkerMaterials.Tier.HV, 4)).inputs(new ItemStack[]{((BlockFrame)MetaBlocks.FRAMES.get(Materials.Steel)).getItem(Materials.Steel)})).input(OrePrefix.plate, Materials.SterlingSilver, 6)).circuitMeta(3)).outputs(new ItemStack[]{GTFOTileEntities.GREENHOUSE.getStackForm()})).buildAndRegister();
        ((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder()).EUt(16)).duration(200)).input(OrePrefix.plate, Materials.Iron)).input(OrePrefix.pipeTinyFluid, Materials.Steel)).inputs(new ItemStack[]{MetaItems.FLUID_FILTER.getStackForm()})).fluidInputs(new FluidStack[]{Materials.Tin.getFluid(144)})).outputs(new ItemStack[]{GTFOMetaItem.SPRINKLER_COVER.getStackForm()})).buildAndRegister();
        ((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder()).EUt(16)).duration(200)).input(OrePrefix.plate, Materials.Iron)).input(OrePrefix.pipeTinyFluid, Materials.Steel)).inputs(new ItemStack[]{MetaItems.FLUID_FILTER.getStackForm()})).fluidInputs(new FluidStack[]{Materials.SolderingAlloy.getFluid(72)})).outputs(new ItemStack[]{GTFOMetaItem.SPRINKLER_COVER.getStackForm()})).buildAndRegister();
    }

    private static <T extends Enum<T>> void registerMetalCasingRecipe(Material inputMaterial, VariantBlock<T> outputCasingType, T outputCasing) {
        ModHandler.addShapedRecipe((String)String.format("metal_casing_%s", inputMaterial), (ItemStack)outputCasingType.getItemVariant(outputCasing, 3), (Object[])new Object[]{"PhP", "PFP", "PwP", Character.valueOf('P'), new UnificationEntry(OrePrefix.plate, inputMaterial), Character.valueOf('F'), new UnificationEntry(OrePrefix.frameGt, inputMaterial)});
        ((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)((AssemblerRecipeBuilder)RecipeMaps.ASSEMBLER_RECIPES.recipeBuilder()).duration(50)).EUt(16)).input(OrePrefix.plate, inputMaterial, 6)).input(OrePrefix.frameGt, inputMaterial)).circuitMeta(6)).outputs(new ItemStack[]{outputCasingType.getItemVariant(outputCasing, 3)})).buildAndRegister();
    }
}

