/*
 * Decompiled with CFR 0.152.
 */
package gregtechfoodoption.potion;

import gregtechfoodoption.potion.GTFOPotions;
import gregtechfoodoption.utils.GTFOLog;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class GTFOPotion
extends Potion {
    private static final ResourceLocation resource = new ResourceLocation("gregtechfoodoption", "textures/gui/potions.png");
    private final int iconIndex;

    public GTFOPotion(String name, boolean badEffect, int color, int iconIndex) {
        super(badEffect, color);
        this.setRegistryName(new ResourceLocation("gregtechfoodoption", name));
        try {
            this.func_76390_b("gregtechfoodoption.potion." + name);
        }
        catch (Exception e) {
            GTFOLog.logger.error("You are currently using the wrong type of jar of GTFO. This usually means that I, bruberu, accidentally released the wrong version. Report this immediately!");
            throw e;
        }
        this.iconIndex = iconIndex;
        GTFOPotions.POTIONS.add(this);
    }

    public boolean hasEffect(EntityLivingBase entity) {
        return this.hasEffect(entity, this);
    }

    public boolean hasEffect(EntityLivingBase entity, Potion potion) {
        return entity.func_70660_b(potion) != null;
    }

    @SideOnly(value=Side.CLIENT)
    public void renderInventoryEffect(int x, int y, PotionEffect effect, Minecraft mc) {
        this.render(x + 6, y + 7, 1.0f);
    }

    @SideOnly(value=Side.CLIENT)
    public void renderHUDEffect(int x, int y, PotionEffect effect, Minecraft mc, float alpha) {
        this.render(x + 3, y + 3, alpha);
    }

    public boolean shouldRender(PotionEffect effect) {
        return this.canRender();
    }

    public boolean shouldRenderInvText(PotionEffect effect) {
        return this.canRender();
    }

    public boolean shouldRenderHUD(PotionEffect effect) {
        return this.canRender();
    }

    @SideOnly(value=Side.CLIENT)
    private void render(int x, int y, float alpha) {
        if (this.canRender()) {
            Minecraft.func_71410_x().field_71446_o.func_110577_a(resource);
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder buf = tessellator.func_178180_c();
            buf.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
            int textureX = this.iconIndex % 8 * 18;
            int textureY = 198 + this.iconIndex / 8 * 18;
            buf.func_181662_b((double)x, (double)(y + 18), 0.0).func_187315_a((double)textureX * 0.00390625, (double)(textureY + 18) * 0.00390625).func_181675_d();
            buf.func_181662_b((double)(x + 18), (double)(y + 18), 0.0).func_187315_a((double)(textureX + 18) * 0.00390625, (double)(textureY + 18) * 0.00390625).func_181675_d();
            buf.func_181662_b((double)(x + 18), (double)y, 0.0).func_187315_a((double)(textureX + 18) * 0.00390625, (double)textureY * 0.00390625).func_181675_d();
            buf.func_181662_b((double)x, (double)y, 0.0).func_187315_a((double)textureX * 0.00390625, (double)textureY * 0.00390625).func_181675_d();
            tessellator.func_78381_a();
        }
    }

    @SideOnly(value=Side.CLIENT)
    protected abstract boolean canRender();
}

