/*
 * Decompiled with CFR 0.152.
 */
package gregtechfoodoption.machines.multiblock.kitchen;

import gregtech.api.capability.IMultipleTankHandler;
import gregtech.api.metatileentity.WorkableTieredMetaTileEntity;
import gregtech.api.recipes.Recipe;
import gregtech.api.recipes.RecipeMap;
import gregtech.api.recipes.ingredients.GTRecipeFluidInput;
import gregtech.api.recipes.ingredients.GTRecipeInput;
import gregtech.api.recipes.ingredients.GTRecipeItemInput;
import gregtech.api.util.GTUtility;
import gregtechfoodoption.machines.multiblock.kitchen.KitchenLogic;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.items.IItemHandlerModifiable;

public class KitchenRequestNode {
    final Recipe recipe;
    final RecipeMap map;
    final KitchenLogic logic;
    BlockPos machineRunning;
    KitchenRequestState state = KitchenRequestState.NEEDS_PROCESSING;
    final List<GTRecipeInput> dependencies = new ArrayList<GTRecipeInput>();

    public KitchenRequestNode(Recipe recipe, RecipeMap map, KitchenLogic logic) {
        this.recipe = recipe;
        this.map = map;
        this.logic = logic;
    }

    public void checkDependencies(IItemHandlerModifiable inputs, IMultipleTankHandler fluidInputs) {
        if (this.state == KitchenRequestState.PROCESSING) {
            WorkableTieredMetaTileEntity machine = this.logic.getMachineAtPos(this.machineRunning);
            if (machine == null) {
                this.state = KitchenRequestState.NOT_RUNNABLE;
            } else if (machine.getRecipeLogic().getProgress() == 0) {
                this.state = KitchenRequestState.DONE;
            }
        }
        if (this.state == KitchenRequestState.NEEDS_PROCESSING || (this.state == KitchenRequestState.AWAITING_RESULTS || this.state == KitchenRequestState.AWAITING_INGREDIENTS) && this.logic.wasNotified) {
            this.dependencies.clear();
            List<GTRecipeItemInput> missingItems = this.missingItems(GTUtility.itemHandlerToList((IItemHandlerModifiable)inputs));
            List<GTRecipeFluidInput> missingFluids = this.missingFluids(GTUtility.fluidHandlerToList((IMultipleTankHandler)fluidInputs));
            if (missingItems.isEmpty() && missingFluids.isEmpty()) {
                this.machineRunning = this.logic.findRun(this.recipe, this.map);
                this.state = this.machineRunning == null ? KitchenRequestState.NOT_RUNNABLE : KitchenRequestState.RUNNABLE;
            } else {
                List<KitchenRequestNode> nodes;
                this.dependencies.addAll(missingItems);
                this.dependencies.addAll(missingFluids);
                this.state = KitchenRequestState.AWAITING_RESULTS;
                for (GTRecipeItemInput item : missingItems) {
                    this.logic.setNodes((GTRecipeInput)item);
                    nodes = this.logic.getNodes((GTRecipeInput)item);
                    if (nodes != null && !nodes.isEmpty()) continue;
                    this.state = KitchenRequestState.AWAITING_INGREDIENTS;
                }
                for (GTRecipeFluidInput fluid : missingFluids) {
                    this.logic.setNodes((GTRecipeInput)fluid);
                    nodes = this.logic.getNodes((GTRecipeInput)fluid);
                    if (nodes != null && !nodes.isEmpty()) continue;
                    this.state = KitchenRequestState.AWAITING_INGREDIENTS;
                }
            }
        } else if (this.state == KitchenRequestState.AWAITING_RESULTS) {
            boolean certainToRun = true;
            for (GTRecipeInput dependency : this.dependencies) {
                boolean isRunnable = false;
                boolean certainOnDependency = false;
                for (KitchenRequestNode node : this.logic.leaves.get(dependency)) {
                    if (node.state == KitchenRequestState.NOT_RUNNABLE) continue;
                    isRunnable = true;
                    if (node.state != KitchenRequestState.RUNNABLE && node.state != KitchenRequestState.PROCESSING) continue;
                    certainOnDependency = true;
                    return;
                }
                if (!isRunnable) {
                    this.state = KitchenRequestState.NOT_RUNNABLE;
                    return;
                }
                if (certainOnDependency) continue;
                certainToRun = false;
            }
            if (certainToRun) {
                this.state = KitchenRequestState.AWAITING_INGREDIENTS;
            }
        }
    }

    private List<GTRecipeItemInput> missingItems(List<ItemStack> inputs) {
        int[] itemAmountInSlot = new int[inputs.size()];
        int indexed = 0;
        List gtRecipeInputs = this.recipe.getInputs();
        ArrayList<GTRecipeItemInput> missing = new ArrayList<GTRecipeItemInput>();
        for (GTRecipeInput ingredient : gtRecipeInputs) {
            int ingredientAmount = ingredient.getAmount();
            for (int j = 0; j < inputs.size(); ++j) {
                ItemStack inputStack = inputs.get(j);
                if (j == indexed) {
                    itemAmountInSlot[j] = inputStack.func_190926_b() ? 0 : inputStack.func_190916_E();
                    ++indexed;
                }
                if (inputStack.func_190926_b() || !ingredient.acceptsStack(inputStack)) continue;
                int itemAmountToConsume = Math.min(itemAmountInSlot[j], ingredientAmount);
                ingredientAmount -= itemAmountToConsume;
                if (!ingredient.isNonConsumable()) {
                    int n = j;
                    itemAmountInSlot[n] = itemAmountInSlot[n] - itemAmountToConsume;
                }
                if (ingredientAmount == 0) break;
            }
            if (ingredientAmount <= 0) continue;
            missing.add(new GTRecipeItemInput(ingredient, ingredientAmount));
        }
        return missing;
    }

    private List<GTRecipeFluidInput> missingFluids(List<FluidStack> fluidInputs) {
        int[] fluidAmountInTank = new int[fluidInputs.size()];
        int indexed = 0;
        List gtRecipeInputs = this.recipe.getFluidInputs();
        ArrayList<GTRecipeFluidInput> missing = new ArrayList<GTRecipeFluidInput>();
        for (GTRecipeInput fluid : gtRecipeInputs) {
            int fluidAmount = fluid.getAmount();
            for (int j = 0; j < fluidInputs.size(); ++j) {
                FluidStack tankFluid = fluidInputs.get(j);
                if (j == indexed) {
                    ++indexed;
                    int n = fluidAmountInTank[j] = tankFluid == null ? 0 : tankFluid.amount;
                }
                if (tankFluid == null || !fluid.acceptsFluid(tankFluid)) continue;
                int fluidAmountToConsume = Math.min(fluidAmountInTank[j], fluidAmount);
                fluidAmount -= fluidAmountToConsume;
                if (!fluid.isNonConsumable()) {
                    int n = j;
                    fluidAmountInTank[n] = fluidAmountInTank[n] - fluidAmountToConsume;
                }
                if (fluidAmount == 0) break;
            }
            if (fluidAmount <= 0) continue;
            missing.add(new GTRecipeFluidInput(fluid.getInputFluidStack(), fluidAmount));
        }
        return missing;
    }

    public static enum KitchenRequestState {
        NEEDS_PROCESSING,
        AWAITING_INGREDIENTS,
        AWAITING_RESULTS,
        NOT_RUNNABLE,
        RUNNABLE,
        PROCESSING,
        DONE;

    }
}

