/*
 * Decompiled with CFR 0.152.
 */
package gregtechfoodoption.machines.multiblock.kitchen;

import gregtech.api.GregTechAPI;
import gregtech.api.capability.GregtechDataCodes;
import gregtech.api.capability.GregtechTileCapabilities;
import gregtech.api.capability.IControllable;
import gregtech.api.capability.IMultipleTankHandler;
import gregtech.api.metatileentity.MTETrait;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.WorkableTieredMetaTileEntity;
import gregtech.api.recipes.Recipe;
import gregtech.api.recipes.RecipeMap;
import gregtech.api.recipes.ingredients.GTRecipeFluidInput;
import gregtech.api.recipes.ingredients.GTRecipeInput;
import gregtech.api.recipes.ingredients.GTRecipeItemInput;
import gregtech.api.unification.material.Material;
import gregtech.api.util.GTTransferUtils;
import gregtech.api.util.GTUtility;
import gregtech.common.ConfigHolder;
import gregtechfoodoption.GTFOMaterialHandler;
import gregtechfoodoption.GTFOValues;
import gregtechfoodoption.machines.multiblock.kitchen.KitchenRequestNode;
import gregtechfoodoption.machines.multiblock.kitchen.MetaTileEntityKitchen;
import gregtechfoodoption.materials.CleanerProperty;
import gregtechfoodoption.utils.GTFOLog;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.relauncher.FMLLaunchHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;

public class KitchenLogic
extends MTETrait
implements IControllable {
    private final boolean hasMaintenance;
    private final Set<WorkableTieredMetaTileEntity> controlledMTEs = new HashSet<WorkableTieredMetaTileEntity>();
    private final List<KitchenRequestNode> requestNodes = new ObjectArrayList();
    final HashMap<GTRecipeInput, List<KitchenRequestNode>> leaves = new HashMap();
    public String info = "";
    boolean wasNotified = true;
    boolean recheckOutputs = true;
    private boolean workingEnabled = true;
    private ItemStack resultItem;
    int dirtiness;
    public KitchenLogicState state;

    public KitchenLogic(MetaTileEntityKitchen controller) {
        super((MetaTileEntity)controller);
        this.hasMaintenance = ConfigHolder.machines.enableMaintenance && controller.hasMaintenanceMechanics();
    }

    @NotNull
    public MetaTileEntityKitchen getMetaTileEntity() {
        return (MetaTileEntityKitchen)super.getMetaTileEntity();
    }

    public void giveMetaTileEntity(WorkableTieredMetaTileEntity metaTileEntity) {
        this.controlledMTEs.add(metaTileEntity);
    }

    public void update() {
        if (FMLLaunchHandler.side() != Side.CLIENT || !this.isWorkingEnabled() || this.hasMaintenance && this.getMetaTileEntity().getNumMaintenanceProblems() > 5) {
            return;
        }
        KitchenLogicState previousState = this.state;
        this.controlledMTEs.removeIf(metaTileEntity -> !metaTileEntity.isValid());
        boolean consumedEnergy = this.getMetaTileEntity().drainEnergy(true);
        if (consumedEnergy) {
            this.getMetaTileEntity().drainEnergy(false);
            this.cleanSelf();
        }
        if (this.getMetaTileEntity().getOffsetTimer() % (long)Math.max(4, this.operationSlowdown()) == 0L) {
            if (this.recheckOutputs || !this.getMetaTileEntity().getNotifiedItemOutputList().isEmpty()) {
                this.getMetaTileEntity().getNotifiedItemOutputList().clear();
                this.state = this.resultItem != null && this.checkOrder() ? KitchenLogicState.ORDER_COMPLETE : KitchenLogicState.PROBABLY_FINE;
                this.wasNotified = true;
            }
            if (this.state != KitchenLogicState.ORDER_COMPLETE && previousState != KitchenLogicState.ORDER_COMPLETE) {
                this.state = KitchenLogicState.PROBABLY_FINE;
                if (consumedEnergy) {
                    this.operate();
                }
            }
        }
        for (MetaTileEntity metaTileEntity2 : this.controlledMTEs) {
            if (metaTileEntity2.getRecipeLogic().getProgress() <= 0) continue;
            this.dirtiness += GTUtility.getFloorTierByVoltage((long)metaTileEntity2.getRecipeLogic().getProgress()) + 1;
        }
        if (previousState != this.state) {
            this.writeCustomData(GTFOValues.UPDATE_KITCHEN_STATUS, buf -> buf.writeByte(this.state.ordinal()));
        }
        this.wasNotified = false;
    }

    private int operationSlowdown() {
        return 20 / this.getMetaTileEntity().getEnergyTier() + (int)Math.ceil(Math.log(this.dirtiness));
    }

    private boolean dirtinessChance() {
        return Math.random() * (double)this.dirtiness < 10.0;
    }

    public void operate() {
        boolean areAnyRunning = false;
        for (MetaTileEntity metaTileEntity : this.controlledMTEs) {
            if (metaTileEntity.getRecipeLogic().getProgress() == 0) {
                areAnyRunning |= this.slurpInventory((IItemHandler)metaTileEntity.getExportItems());
                areAnyRunning |= this.slurpFluids((IFluidHandler)metaTileEntity.getExportFluids());
                continue;
            }
            areAnyRunning = true;
        }
        if (!areAnyRunning && this.state == KitchenLogicState.PROBABLY_FINE) {
            this.state = KitchenLogicState.NO_INGREDIENTS;
        }
        if (!this.getMetaTileEntity().getNotifiedItemInputList().isEmpty() || !this.getMetaTileEntity().getNotifiedFluidInputList().isEmpty()) {
            this.getMetaTileEntity().getNotifiedItemInputList().clear();
            this.getMetaTileEntity().getNotifiedFluidInputList().clear();
            this.wasNotified = true;
        }
        this.handleNodes();
    }

    public void handleNodes() {
        NBTTagCompound data = this.getMetaTileEntity().getRecipeNBT();
        if (data != null && !data.func_82582_d()) {
            this.resultItem = new ItemStack(data.func_74775_l("finalresult"));
            if (!this.resultItem.func_190926_b()) {
                GTRecipeItemInput resultItemIn = new GTRecipeItemInput(this.resultItem);
                this.setNodes((GTRecipeInput)resultItemIn);
                for (int i = 0; i < this.requestNodes.size(); ++i) {
                    KitchenRequestNode node = this.requestNodes.get(i);
                    node.checkDependencies(this.getMetaTileEntity().getInputInventory(), this.getMetaTileEntity().getInputFluidInventory());
                    if (node.state != KitchenRequestNode.KitchenRequestState.RUNNABLE) continue;
                    WorkableTieredMetaTileEntity mte = this.getMachineAtPos(node.machineRunning);
                    if (this.dirtinessChance()) {
                        if (mte == null || mte.getRecipeLogic().getProgress() != 0) continue;
                        if (this.getMachineAtPos(node.machineRunning).getRecipeLogic().prepareRecipe(node.recipe, this.getMetaTileEntity().getInputInventory(), this.getMetaTileEntity().getInputFluidInventory())) {
                            node.state = KitchenRequestNode.KitchenRequestState.PROCESSING;
                            continue;
                        }
                        this.state = KitchenLogicState.MACHINES_NOT_WORKING;
                        continue;
                    }
                    this.state = KitchenLogicState.PROBABLY_FINE;
                }
                List<KitchenRequestNode> finalNodes = this.getNodes((GTRecipeInput)resultItemIn);
                boolean canRunAny = false;
                for (KitchenRequestNode node : finalNodes) {
                    if (node.state == KitchenRequestNode.KitchenRequestState.NOT_RUNNABLE) continue;
                    canRunAny = true;
                    break;
                }
                if (!canRunAny) {
                    this.state = KitchenLogicState.BAD_MACHINES;
                }
                return;
            }
        }
        this.state = KitchenLogicState.NO_RECIPE;
        this.reset();
    }

    public void reset() {
        this.resultItem = null;
        this.requestNodes.clear();
        this.leaves.clear();
        this.recheckOutputs = true;
    }

    public void cleanSelf() {
        for (IMultipleTankHandler.MultiFluidTankEntry tank : this.getMetaTileEntity().getInputFluidInventory().getFluidTanks()) {
            CleanerProperty property;
            Material mat;
            FluidStack fluid;
            if (this.dirtiness <= 0 || (fluid = tank.getFluid()) == null || fluid.amount <= 0 || (mat = GregTechAPI.materialManager.getMaterial(fluid.getFluid().getName())) == null || (property = (CleanerProperty)mat.getProperty(GTFOMaterialHandler.CLEANER)) == null) continue;
            tank.drain(1, true);
            this.dirtiness -= property.getCleaningPower();
        }
    }

    private boolean checkOrder() {
        int countLeft = this.getMetaTileEntity().getOrderSize();
        for (int i = 0; i < this.getMetaTileEntity().getOutputInventory().getSlots(); ++i) {
            ItemStack itemStack = this.getMetaTileEntity().getOutputInventory().getStackInSlot(i);
            if (!itemStack.func_190926_b() && itemStack.func_77969_a(this.resultItem) && ItemStack.func_77970_a((ItemStack)itemStack, (ItemStack)this.resultItem)) {
                countLeft -= itemStack.func_190916_E();
            }
            if (countLeft > 0) continue;
            return true;
        }
        return false;
    }

    public boolean slurpInventory(IItemHandler sourceInventory) {
        boolean didAnything = false;
        for (int srcIndex = 0; srcIndex < sourceInventory.getSlots(); ++srcIndex) {
            ItemStack sourceStack = sourceInventory.extractItem(srcIndex, Integer.MAX_VALUE, true);
            if (sourceStack.func_190926_b() || !this.dirtinessChance()) continue;
            IItemHandlerModifiable inventory = this.getNodes((GTRecipeInput)new GTRecipeItemInput(sourceStack)) == null || this.resultItem.func_77969_a(sourceStack) ? this.getMetaTileEntity().getOutputInventory() : this.getMetaTileEntity().getInputInventory();
            ItemStack remainder = GTTransferUtils.insertItem((IItemHandler)inventory, (ItemStack)sourceStack, (boolean)true);
            int amountToInsert = sourceStack.func_190916_E() - remainder.func_190916_E();
            if (remainder.func_190916_E() > 0) {
                this.state = KitchenLogicState.BUSES_FULL;
            }
            if (amountToInsert <= 0) continue;
            sourceStack = sourceInventory.extractItem(srcIndex, amountToInsert, false);
            GTTransferUtils.insertItem((IItemHandler)inventory, (ItemStack)sourceStack, (boolean)false);
            didAnything = true;
        }
        return didAnything;
    }

    public boolean slurpFluids(@NotNull IFluidHandler sourceHandler) {
        boolean didAnything = false;
        for (IFluidTankProperties prop : sourceHandler.getTankProperties()) {
            IMultipleTankHandler handler;
            int canInsertAmount;
            FluidStack currentFluid = prop.getContents();
            if (currentFluid == null || currentFluid.amount == 0 || !this.dirtinessChance()) continue;
            FluidStack fluidStack = sourceHandler.drain(currentFluid, false);
            if (fluidStack != null && fluidStack.amount != 0 && (canInsertAmount = (handler = this.getNodes((GTRecipeInput)new GTRecipeFluidInput(fluidStack)) == null ? this.getMetaTileEntity().getOutputFluidInventory() : this.getMetaTileEntity().getInputFluidInventory()).fill(fluidStack, false)) > 0) {
                fluidStack.amount = canInsertAmount;
                if ((fluidStack = sourceHandler.drain(fluidStack, true)) != null && fluidStack.amount > 0) {
                    handler.fill(fluidStack, true);
                }
                didAnything = true;
            }
            if (currentFluid.amount <= 0) continue;
            this.state = KitchenLogicState.HATCHES_FULL;
        }
        return didAnything;
    }

    public BlockPos findRun(Recipe r, RecipeMap map) {
        BlockPos result = null;
        for (WorkableTieredMetaTileEntity mte : this.controlledMTEs) {
            if (mte.getRecipeLogic().getProgress() != 0 && result != null || !mte.getRecipeLogic().getRecipeMap().equals((Object)map) || mte.getRecipeLogic().getMaxVoltage() < (long)r.getEUt()) continue;
            result = mte.getPos();
        }
        return result;
    }

    protected Collection<RecipeAndMap> getRecipesFor(GTRecipeItemInput s, @NotNull NBTTagCompound recipeData) {
        ArrayList<RecipeAndMap> recipes = new ArrayList<RecipeAndMap>();
        int count = recipeData.func_74762_e("recipecount");
        for (int i = 0; i < count; ++i) {
            NBTTagCompound recipe = recipeData.func_74775_l("recipe" + i);
            NBTTagCompound outputs = recipe.func_74775_l("outputs");
            int outputSize = outputs.func_74762_e("size");
            for (int j = 0; j < outputSize; ++j) {
                ItemStack stack = new ItemStack(outputs.func_74775_l("item" + j));
                if (!s.acceptsStack(stack)) continue;
                RecipeMap map = RecipeMap.getByName((String)recipe.func_74779_i("map"));
                Recipe actualRecipe = this.getRecipeFromMap(recipe, map);
                if (actualRecipe != null) {
                    recipes.add(new RecipeAndMap(actualRecipe, map));
                    continue;
                }
                GTFOLog.logger.warn("A recipe for " + s + " had bad NBT! Maybe it doesn't exist anymore?");
            }
        }
        return recipes;
    }

    protected Recipe getRecipeFromMap(NBTTagCompound tag, RecipeMap<?> map) {
        ArrayList<ItemStack> inputs = new ArrayList<ItemStack>();
        ArrayList<FluidStack> fluidInputs = new ArrayList<FluidStack>();
        NBTTagCompound inputsTag = tag.func_74775_l("inputs");
        for (int i = 0; i < inputsTag.func_74762_e("size"); ++i) {
            inputs.add(new ItemStack(inputsTag.func_74775_l("item" + i)));
        }
        NBTTagCompound fluidInputsTag = tag.func_74775_l("fluidInputs");
        for (int i = 0; i < fluidInputsTag.func_74762_e("size"); ++i) {
            fluidInputs.add(FluidStack.loadFluidStackFromNBT((NBTTagCompound)fluidInputsTag.func_74775_l("fluid" + i)));
        }
        int eut = tag.func_74762_e("EUt");
        return map.findRecipe((long)eut, inputs, fluidInputs);
    }

    protected Collection<RecipeAndMap> getRecipesFor(GTRecipeFluidInput s, @NotNull NBTTagCompound recipeData) {
        ArrayList<RecipeAndMap> recipes = new ArrayList<RecipeAndMap>();
        int count = recipeData.func_74762_e("recipecount");
        for (int i = 0; i < count; ++i) {
            NBTTagCompound recipe = recipeData.func_74775_l("recipe" + i);
            NBTTagCompound outputs = recipe.func_74775_l("fluidOutputs");
            int outputSize = outputs.func_74762_e("size");
            for (int j = 0; j < outputSize; ++j) {
                FluidStack stack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)outputs.func_74775_l("fluid" + j));
                if (!s.acceptsFluid(stack)) continue;
                RecipeMap map = RecipeMap.getByName((String)recipe.func_74779_i("map"));
                Recipe actualRecipe = this.getRecipeFromMap(recipe, map);
                if (actualRecipe != null) {
                    recipes.add(new RecipeAndMap(actualRecipe, map));
                    continue;
                }
                GTFOLog.logger.warn("A recipe for " + s + " had bad NBT! Maybe it doesn't exist anymore?");
            }
        }
        return recipes;
    }

    public void setNodes(GTRecipeInput sizedInput) {
        GTRecipeInput input = sizedInput.copyWithAmount(1);
        if (this.leaves.get(input) == null) {
            ArrayList<KitchenRequestNode> nodes = new ArrayList<KitchenRequestNode>();
            Collection<RecipeAndMap> rs = input instanceof GTRecipeItemInput ? this.getRecipesFor((GTRecipeItemInput)input, this.getMetaTileEntity().getRecipeNBT()) : this.getRecipesFor((GTRecipeFluidInput)input, this.getMetaTileEntity().getRecipeNBT());
            for (RecipeAndMap recipeAndMap : rs) {
                KitchenRequestNode node = new KitchenRequestNode(recipeAndMap.recipe, recipeAndMap.map, this);
                this.requestNodes.add(node);
                nodes.add(node);
            }
            this.leaves.put(input, nodes);
            this.wasNotified = true;
        } else {
            for (KitchenRequestNode node : this.leaves.get(input)) {
                if (node.state == KitchenRequestNode.KitchenRequestState.NOT_RUNNABLE) continue;
                node.state = KitchenRequestNode.KitchenRequestState.AWAITING_INGREDIENTS;
            }
        }
    }

    public List<KitchenRequestNode> getNodes(GTRecipeInput sizedInput) {
        GTRecipeInput input = sizedInput.copyWithAmount(1);
        return this.leaves.get(input);
    }

    public WorkableTieredMetaTileEntity getMachineAtPos(BlockPos pos) {
        for (WorkableTieredMetaTileEntity mte : this.controlledMTEs) {
            if (!mte.getPos().equals((Object)pos)) continue;
            return mte;
        }
        return null;
    }

    public boolean isWorkingEnabled() {
        return this.workingEnabled;
    }

    public void setWorkingEnabled(boolean b) {
        this.workingEnabled = b;
    }

    @NotNull
    public String getName() {
        return "ExternalMachineRecipeLogic";
    }

    public void receiveCustomData(int dataId, @NotNull PacketBuffer buf) {
        if (dataId == GregtechDataCodes.WORKING_ENABLED) {
            this.workingEnabled = buf.readBoolean();
            this.getMetaTileEntity().scheduleRenderUpdate();
        } else if (dataId == GTFOValues.UPDATE_KITCHEN_STATUS) {
            this.state = KitchenLogicState.values()[buf.readByte()];
            this.getMetaTileEntity().scheduleRenderUpdate();
        }
    }

    @NotNull
    public NBTTagCompound serializeNBT() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74757_a("WorkEnabled", this.workingEnabled);
        tag.func_74768_a("Status", this.state.ordinal());
        tag.func_74768_a("Dirtiness", this.dirtiness);
        return tag;
    }

    public void deserializeNBT(@NotNull NBTTagCompound compound) {
        this.workingEnabled = compound.func_74767_n("WorkEnabled");
        this.state = KitchenLogicState.values()[compound.func_74762_e("Status")];
        this.dirtiness = compound.func_74762_e("Dirtiness");
    }

    public void writeInitialSyncData(@NotNull PacketBuffer buf) {
        buf.writeBoolean(this.workingEnabled);
        buf.writeInt(this.dirtiness);
    }

    public void receiveInitialSyncData(@NotNull PacketBuffer buf) {
        this.workingEnabled = buf.readBoolean();
        this.dirtiness = buf.readInt();
    }

    public <T> T getCapability(Capability<T> capability) {
        if (capability == GregtechTileCapabilities.CAPABILITY_CONTROLLABLE) {
            return (T)GregtechTileCapabilities.CAPABILITY_CONTROLLABLE.cast((Object)this);
        }
        return null;
    }

    public static enum KitchenLogicState {
        NO_RECIPE,
        NO_INGREDIENTS,
        BAD_MACHINES,
        MACHINES_NOT_WORKING,
        PROBABLY_FINE,
        BUSES_FULL,
        HATCHES_FULL,
        ORDER_COMPLETE;

    }

    private static class RecipeAndMap {
        Recipe recipe;
        RecipeMap map;

        public RecipeAndMap(Recipe recipe, RecipeMap map) {
            this.recipe = recipe;
            this.map = map;
        }
    }
}

