/*
 * Decompiled with CFR 0.152.
 */
package gregtechfoodoption.machines.multiblock;

import gregtech.api.capability.impl.MultiblockRecipeLogic;
import gregtech.api.gui.ModularUI;
import gregtech.api.gui.resources.TextureArea;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.metatileentity.multiblock.IMultiblockPart;
import gregtech.api.metatileentity.multiblock.RecipeMapMultiblockController;
import gregtech.api.pattern.BlockPattern;
import gregtech.api.pattern.FactoryBlockPattern;
import gregtech.api.recipes.Recipe;
import gregtech.api.recipes.RecipeMap;
import gregtech.api.unification.material.Materials;
import gregtech.client.renderer.ICubeRenderer;
import gregtech.client.renderer.texture.Textures;
import gregtech.common.ConfigHolder;
import gregtech.common.blocks.BlockFrame;
import gregtech.common.blocks.BlockMetalCasing;
import gregtech.common.blocks.MetaBlocks;
import gregtechfoodoption.GTFOConfig;
import gregtechfoodoption.block.GTFOGlassCasing;
import gregtechfoodoption.block.GTFOMetaBlocks;
import gregtechfoodoption.client.GTFOGuiTextures;
import gregtechfoodoption.utils.GTFOLog;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.command.CommandBase;
import net.minecraft.command.InvalidBlockStateException;
import net.minecraft.command.NumberInvalidException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class MetaTileEntityGreenhouse
extends RecipeMapMultiblockController {
    protected static IBlockState[] GRASSES;

    public static void addGrasses() {
        GRASSES = new IBlockState[GTFOConfig.gtfoMiscConfig.greenhouseDirts.length];
        boolean errorsFound = false;
        for (int i = 0; i < GTFOConfig.gtfoMiscConfig.greenhouseDirts.length; ++i) {
            String blockStateString = GTFOConfig.gtfoMiscConfig.greenhouseDirts[i];
            try {
                String stateString;
                String[] splitBlockStateString = StringUtils.split((String)blockStateString, (String)"[");
                String blockString = splitBlockStateString[0];
                if (splitBlockStateString.length == 1) {
                    stateString = "default";
                } else if (splitBlockStateString.length == 2) {
                    stateString = StringUtils.reverse((String)StringUtils.reverse((String)StringUtils.split((String)blockStateString, (String)"[")[1]).replaceFirst("]", ""));
                } else {
                    GTFOLog.logger.error("Block/BlockState Parsing error for \"" + blockStateString + "\"");
                    errorsFound = true;
                    continue;
                }
                Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(blockString));
                if (block == null) {
                    GTFOLog.logger.error("Block Parsing error for \"" + blockString + "\". Block does not exist!");
                    errorsFound = true;
                    continue;
                }
                try {
                    IBlockState state;
                    MetaTileEntityGreenhouse.GRASSES[i] = state = CommandBase.func_190794_a((Block)block, (String)stateString);
                }
                catch (NumberInvalidException e) {
                    GTFOLog.logger.error("BlockState Parsing error " + (Object)((Object)e) + " for \"" + stateString + "\". Invalid Number!");
                    errorsFound = true;
                }
                catch (InvalidBlockStateException e) {
                    GTFOLog.logger.error("BlockState Parsing error " + (Object)((Object)e) + " for \"" + stateString + "\". Invalid BlockState!");
                    errorsFound = true;
                }
                continue;
            }
            catch (Exception e) {
                GTFOLog.logger.error("Smoothable BlockState Parsing error " + e + " for \"" + blockStateString + "\"");
                errorsFound = true;
            }
        }
        if (errorsFound) {
            throw new IllegalArgumentException("One or more errors were found with the Greenhouse Blocks configuration for GTFO. Check log above.");
        }
    }

    public MetaTileEntityGreenhouse(ResourceLocation metaTileEntityId) {
        super(metaTileEntityId, RecipeMap.getByName((String)"greenhouse"));
        this.recipeMapWorkable = new GreenhouseWorkable(this);
    }

    protected BlockPattern createStructurePattern() {
        return FactoryBlockPattern.start().aisle(new String[]{"CCCCCCC", "XXXFXXX", "XXXFXXX", "XXXFXXX", "XXXFXXX", "XXXFXXX", "XXXFXXX", "XXXFXXX", "   F   "}).aisle(new String[]{"CDDDDDC", "X#####X", "X#####X", "X#####X", "X#####X", "X#####X", "X#####X", "X#####X", " XXFXX "}).aisle(new String[]{"CDDDDDC", "X#####X", "X#####X", "X#####X", "X#####X", "X#####X", "X#####X", "X#####X", " XXFXX "}).aisle(new String[]{"CDDDDDC", "F#####F", "F#####F", "F#####F", "F#####F", "F#####F", "F#####F", "F#####F", "FFFFFFF"}).aisle(new String[]{"CDDDDDC", "X#####X", "X#####X", "X#####X", "X#####X", "X#####X", "X#####X", "X#####X", " XXFXX "}).aisle(new String[]{"CDDDDDC", "X#####X", "X#####X", "X#####X", "X#####X", "X#####X", "X#####X", "X#####X", " XXFXX "}).aisle(new String[]{"CCCYCCC", "XXXFXXX", "XXXFXXX", "XXXFXXX", "XXXFXXX", "XXXFXXX", "XXXFXXX", "XXXFXXX", "   F   "}).where('X', MetaTileEntityGreenhouse.states((IBlockState[])new IBlockState[]{this.getCasingState()})).where('F', MetaTileEntityGreenhouse.states((IBlockState[])new IBlockState[]{this.getFrameState()})).where('D', MetaTileEntityGreenhouse.states((IBlockState[])new IBlockState[]{Blocks.field_150346_d.func_176223_P(), Blocks.field_150349_c.func_176223_P()}).or(MetaTileEntityGreenhouse.states((IBlockState[])GRASSES))).where('C', MetaTileEntityGreenhouse.states((IBlockState[])new IBlockState[]{this.getCasingState2()}).setMinGlobalLimited(10).or(this.autoAbilities())).where('#', MetaTileEntityGreenhouse.air()).where(' ', MetaTileEntityGreenhouse.any()).where('Y', this.selfPredicate()).build();
    }

    protected IBlockState getCasingState() {
        return GTFOMetaBlocks.GTFO_GLASS_CASING.getState(GTFOGlassCasing.CasingType.GREENHOUSE_GLASS);
    }

    protected IBlockState getCasingState2() {
        return MetaBlocks.METAL_CASING.getState((Enum)BlockMetalCasing.MetalCasingType.STEEL_SOLID);
    }

    protected IBlockState getFrameState() {
        return ((BlockFrame)MetaBlocks.FRAMES.get(Materials.Steel)).getBlock(Materials.Steel);
    }

    public ICubeRenderer getBaseTexture(IMultiblockPart iMultiblockPart) {
        return Textures.SOLID_STEEL_CASING;
    }

    public MetaTileEntity createMetaTileEntity(IGregTechTileEntity iGregTechTileEntity) {
        return new MetaTileEntityGreenhouse(this.metaTileEntityId);
    }

    public boolean checkNaturalLighting() {
        if (!this.getWorld().func_72935_r()) {
            return false;
        }
        for (BlockPos pos : BlockPos.func_177980_a((BlockPos)this.getPos().func_177981_b(8).func_177967_a(this.frontFacing.func_176746_e(), 3), (BlockPos)this.getPos().func_177981_b(8).func_177967_a(this.getFrontFacing().func_176735_f(), 3).func_177967_a(this.getFrontFacing().func_176734_d(), 6))) {
            if (this.getWorld().func_175678_i(pos.func_177984_a())) continue;
            return false;
        }
        return true;
    }

    public void addInformation(ItemStack stack, @Nullable World player, List<String> tooltip, boolean advanced) {
        super.addInformation(stack, player, tooltip, advanced);
        tooltip.add(I18n.func_135052_a((String)"gregtechfoodoption.machine.greenhouse.tooltip.1", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"gregtechfoodoption.machine.greenhouse.tooltip.2", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"gregtechfoodoption.machine.greenhouse.tooltip.3", (Object[])new Object[0]));
    }

    protected void addWarningText(List<ITextComponent> textList) {
        super.addWarningText(textList);
        if (this.isStructureFormed() && !((GreenhouseWorkable)this.recipeMapWorkable).hasSun()) {
            textList.add(new TextComponentTranslation("gregtech.multiblock.not_enough_sun", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED)));
        }
    }

    protected ModularUI createUI(EntityPlayer entityPlayer) {
        ((GreenhouseWorkable)this.recipeMapWorkable).hasSun = this.checkNaturalLighting();
        return super.createUI(entityPlayer);
    }

    @NotNull
    protected TextureArea getLogo() {
        return GTFOGuiTextures.GTFO_LOGO_WORKING;
    }

    @NotNull
    protected TextureArea getWarningLogo() {
        return GTFOGuiTextures.GTFO_LOGO_WARNING;
    }

    @NotNull
    protected TextureArea getErrorLogo() {
        return GTFOGuiTextures.GTFO_LOGO_ERROR;
    }

    public boolean canBeDistinct() {
        return true;
    }

    public boolean isMultiblockPartWeatherResistant(@NotNull IMultiblockPart part) {
        return true;
    }

    public boolean getIsWeatherOrTerrainResistant() {
        return true;
    }

    public static class GreenhouseWorkable
    extends MultiblockRecipeLogic {
        private boolean hasSun;

        public GreenhouseWorkable(RecipeMapMultiblockController tileEntity) {
            super(tileEntity);
        }

        protected void setupRecipe(Recipe recipe) {
            super.setupRecipe(recipe);
            this.hasSun = ((MetaTileEntityGreenhouse)this.metaTileEntity).checkNaturalLighting();
        }

        public boolean hasSun() {
            return this.hasSun;
        }

        protected void updateRecipeProgress() {
            if (this.canRecipeProgress && this.drawEnergy(this.recipeEUt, true)) {
                this.drawEnergy(this.recipeEUt, false);
                this.progressTime = this.hasSun ? ++this.progressTime : (int)((double)this.progressTime + Math.random() * 2.0);
                if (this.progressTime > this.maxProgressTime) {
                    this.completeRecipe();
                }
                if (this.hasNotEnoughEnergy && this.getEnergyInputPerSecond() > 19L * (long)this.recipeEUt) {
                    this.hasNotEnoughEnergy = false;
                }
            } else if (this.recipeEUt > 0) {
                this.hasNotEnoughEnergy = true;
                if (this.progressTime >= 2) {
                    this.progressTime = ConfigHolder.machines.recipeProgressLowEnergy ? 1 : Math.max(1, this.progressTime - 2);
                }
            }
        }

        public NBTTagCompound serializeNBT() {
            NBTTagCompound tag = super.serializeNBT();
            tag.func_74757_a("hasSun", this.hasSun);
            return tag;
        }

        public void deserializeNBT(@Nonnull NBTTagCompound compound) {
            super.deserializeNBT(compound);
            this.hasSun = compound.func_74767_n("hasSun");
        }
    }
}

