/*
 * Decompiled with CFR 0.152.
 */
package gregtechfoodoption.machines.multiblock;

import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Matrix4;
import gregtech.api.capability.GregtechTileCapabilities;
import gregtech.api.capability.IControllable;
import gregtech.api.capability.impl.MultiblockRecipeLogic;
import gregtech.api.gui.GuiTextures;
import gregtech.api.gui.ModularUI;
import gregtech.api.gui.Widget;
import gregtech.api.gui.resources.IGuiTexture;
import gregtech.api.gui.resources.TextureArea;
import gregtech.api.gui.widgets.AdvancedTextWidget;
import gregtech.api.gui.widgets.ClickButtonWidget;
import gregtech.api.gui.widgets.ImageCycleButtonWidget;
import gregtech.api.gui.widgets.ImageWidget;
import gregtech.api.gui.widgets.IndicatorImageWidget;
import gregtech.api.gui.widgets.ProgressWidget;
import gregtech.api.gui.widgets.WidgetGroup;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.metatileentity.multiblock.IMultiblockPart;
import gregtech.api.metatileentity.multiblock.IProgressBarMultiblock;
import gregtech.api.metatileentity.multiblock.MultiblockAbility;
import gregtech.api.metatileentity.multiblock.ParallelLogicType;
import gregtech.api.metatileentity.multiblock.RecipeMapMultiblockController;
import gregtech.api.pattern.BlockPattern;
import gregtech.api.pattern.FactoryBlockPattern;
import gregtech.api.pattern.PatternMatchContext;
import gregtech.api.pattern.TraceabilityPredicate;
import gregtech.api.recipes.Recipe;
import gregtech.api.recipes.recipeproperties.RecipeProperty;
import gregtech.api.unification.material.Materials;
import gregtech.api.util.RelativeDirection;
import gregtech.api.util.TextComponentUtil;
import gregtech.client.renderer.ICubeRenderer;
import gregtech.common.blocks.BlockFrame;
import gregtech.common.blocks.BlockGlassCasing;
import gregtech.common.blocks.MetaBlocks;
import gregtech.core.sound.GTSoundEvents;
import gregtechfoodoption.block.GTFOMetaBlocks;
import gregtechfoodoption.block.GTFOMetalCasing;
import gregtechfoodoption.client.GTFOClientHandler;
import gregtechfoodoption.client.GTFOGuiTextures;
import gregtechfoodoption.recipe.GTFORecipeMaps;
import gregtechfoodoption.recipe.builder.ElectricBakingOvenRecipeBuilder;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;

public class MetaTileEntityElectricBakingOven
extends RecipeMapMultiblockController
implements IProgressBarMultiblock {
    private int temp;
    private int targetTemp;
    private boolean canAchieveTargetTemp;
    private boolean hasEnoughEnergy;
    public int size;
    public boolean adaptable = true;
    private boolean canRunRecipe = false;
    private static final MultiblockAbility<?>[] ALLOWED_ABILITIES = new MultiblockAbility[]{MultiblockAbility.IMPORT_ITEMS, MultiblockAbility.EXPORT_ITEMS, MultiblockAbility.INPUT_ENERGY, MultiblockAbility.MAINTENANCE_HATCH};

    public MetaTileEntityElectricBakingOven(ResourceLocation metaTileEntityId) {
        super(metaTileEntityId, GTFORecipeMaps.ELECTRIC_BAKING_OVEN_RECIPES);
        this.recipeMapWorkable = new ElectricBakingOvenLogic(this);
        this.temp = 300;
        this.targetTemp = 300;
    }

    protected void updateFormedValid() {
        if (this.getWorld().field_72995_K) {
            return;
        }
        super.updateFormedValid();
        if (this.temp > 300) {
            this.hasEnoughEnergy = this.drainEnergy();
            if (this.adaptable && !this.canRunRecipe) {
                this.targetTemp = 300;
            }
        } else {
            this.hasEnoughEnergy = true;
        }
        if (this.getOffsetTimer() % 20L == 0L && !this.recipeMapWorkable.isActive()) {
            this.stepTowardsTargetTemp();
        } else if (this.targetTemp == this.temp) {
            this.canAchieveTargetTemp = true;
        }
        if (!this.isActive()) {
            this.canRunRecipe = false;
        }
    }

    private void stepTowardsTargetTemp() {
        this.canAchieveTargetTemp = true;
        if (!(this.temp <= 300 || this.recipeMapWorkable.isWorking() && this.targetTemp >= this.temp)) {
            this.setTemp(this.temp - 5);
            if (this.temp == 300) {
                this.markDirty();
            }
            return;
        }
        if (this.temp == this.targetTemp) {
            return;
        }
        if ((long)MetaTileEntityElectricBakingOven.temperatureEnergyCost(this.temp + 5, this.size) <= this.getEnergyContainer().getInputVoltage() * this.getEnergyContainer().getInputAmperage() && this.hasEnoughEnergy) {
            this.setTemp(this.temp + 5);
            if (this.temp == 305) {
                this.markDirty();
            }
        } else {
            this.canAchieveTargetTemp = false;
        }
    }

    private boolean drainEnergy() {
        if (this.energyContainer.getEnergyStored() >= (long)MetaTileEntityElectricBakingOven.temperatureEnergyCost(this.temp, this.size)) {
            this.energyContainer.removeEnergy((long)MetaTileEntityElectricBakingOven.temperatureEnergyCost(this.temp, this.size));
            return true;
        }
        this.setTemp(this.temp - 5);
        return false;
    }

    public void addInformation(ItemStack stack, @Nullable World player, List<String> tooltip, boolean advanced) {
        super.addInformation(stack, player, tooltip, advanced);
        tooltip.add(I18n.func_135052_a((String)"gregtechfoodoption.machine.electric_baking_oven.tooltip.1", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"gregtechfoodoption.machine.electric_baking_oven.tooltip.2", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"gregtechfoodoption.machine.electric_baking_oven.tooltip.3", (Object[])new Object[0]));
    }

    protected void addDisplayText(List<ITextComponent> textList) {
        if (!this.isStructureFormed()) {
            TextComponentTranslation tooltip = new TextComponentTranslation("gregtech.multiblock.invalid_structure.tooltip", new Object[0]);
            tooltip.func_150255_a(new Style().func_150238_a(TextFormatting.GRAY));
            textList.add(new TextComponentTranslation("gregtech.multiblock.invalid_structure", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED).func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)tooltip))));
        } else {
            if (!this.recipeMapWorkable.isWorkingEnabled()) {
                textList.add((ITextComponent)TextComponentUtil.translationWithColor((TextFormatting)TextFormatting.GRAY, (String)"gregtech.multiblock.work_paused", (Object[])new Object[0]));
            } else if (this.recipeMapWorkable.isActive()) {
                textList.add((ITextComponent)TextComponentUtil.translationWithColor((TextFormatting)TextFormatting.GRAY, (String)"gregtech.multiblock.running", (Object[])new Object[0]));
                int currentProgress = (int)(this.recipeMapWorkable.getProgressPercent() * 100.0);
                if (this.recipeMapWorkable.getParallelLimit() != 1) {
                    textList.add((ITextComponent)new TextComponentTranslation("gregtech.multiblock.parallel", new Object[]{this.recipeMapWorkable.getParallelLimit()}));
                }
                textList.add((ITextComponent)new TextComponentTranslation("gregtech.multiblock.progress", new Object[]{currentProgress}));
            } else {
                textList.add((ITextComponent)TextComponentUtil.translationWithColor((TextFormatting)TextFormatting.GRAY, (String)"gregtech.multiblock.idling", (Object[])new Object[0]));
            }
            if (this.recipeMapWorkable.isHasNotEnoughEnergy()) {
                textList.add(new TextComponentTranslation("gregtech.multiblock.not_enough_energy", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED)));
            }
            textList.add((ITextComponent)new TextComponentTranslation("gregtechfoodoption.multiblock.electric_baking_oven.tooltip.4", new Object[]{MetaTileEntityElectricBakingOven.temperatureEnergyCost(this.temp, this.size)}));
            textList.add((ITextComponent)new TextComponentTranslation("gregtechfoodoption.multiblock.electric_baking_oven.tooltip.5", new Object[]{this.targetTemp}));
            if (!this.canAchieveTargetTemp && this.hasEnoughEnergy) {
                textList.add(new TextComponentTranslation("gregtechfoodoption.multiblock.electric_baking_oven.tooltip.2", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED)));
            }
            if (!this.hasEnoughEnergy) {
                textList.add(new TextComponentTranslation("gregtech.multiblock.not_enough_energy", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED)));
            }
        }
    }

    public void decrementTemperatureTarget(Widget.ClickData data) {
        this.targetTemp -= data.isShiftClick ? 25 : 5;
    }

    public void incrementTemperatureTarget(Widget.ClickData data) {
        this.targetTemp += data.isShiftClick ? 25 : 5;
    }

    protected IBlockState getCasingState() {
        return GTFOMetaBlocks.GTFO_METAL_CASING.getState(GTFOMetalCasing.CasingType.BISMUTH_BRONZE_CASING);
    }

    protected IBlockState getFrameState() {
        return ((BlockFrame)MetaBlocks.FRAMES.get(Materials.Steel)).getBlock(Materials.Steel);
    }

    public ICubeRenderer getBaseTexture(IMultiblockPart sourcePart) {
        return GTFOClientHandler.BISMUTH_BRONZE_CASING;
    }

    protected ICubeRenderer getFrontOverlay() {
        return GTFOClientHandler.BAKING_OVEN_OVERLAY;
    }

    protected BlockPattern createStructurePattern() {
        return FactoryBlockPattern.start((RelativeDirection)RelativeDirection.FRONT, (RelativeDirection)RelativeDirection.UP, (RelativeDirection)RelativeDirection.RIGHT).aisle(new String[]{"XXXX", "YXXX", "XXXX", "####"}).aisle(new String[]{"XXXX", "GFFX", "GIOX", "XXXX"}).setRepeatable(2, 14).aisle(new String[]{"XXXX", "XXXX", "XXXX", "####"}).where('X', MetaTileEntityElectricBakingOven.states((IBlockState[])new IBlockState[]{this.getCasingState()}).setMinGlobalLimited(10).or(this.autoAbilities())).where('F', MetaTileEntityElectricBakingOven.states((IBlockState[])new IBlockState[]{this.getFrameState()})).where('G', MetaTileEntityElectricBakingOven.states((IBlockState[])new IBlockState[]{MetaBlocks.TRANSPARENT_CASING.getState((Enum)BlockGlassCasing.CasingType.TEMPERED_GLASS)})).where('#', MetaTileEntityElectricBakingOven.any()).where('O', MetaTileEntityElectricBakingOven.air()).where('I', MetaTileEntityElectricBakingOven.isIndicatorPredicate()).where('Y', this.selfPredicate()).build();
    }

    public static TraceabilityPredicate isIndicatorPredicate() {
        return new TraceabilityPredicate(blockWorldState -> {
            if (MetaTileEntityElectricBakingOven.air().test(blockWorldState)) {
                blockWorldState.getMatchContext().increment("bakingOvenLength", 1);
                return true;
            }
            return false;
        });
    }

    public void invalidateStructure() {
        this.setTemp(300);
        super.invalidateStructure();
    }

    protected void formStructure(PatternMatchContext context) {
        super.formStructure(context);
        this.size = (Integer)context.getOrDefault("bakingOvenLength", (Object)1) - 1;
    }

    public MetaTileEntity createMetaTileEntity(IGregTechTileEntity tileEntity) {
        return new MetaTileEntityElectricBakingOven(this.metaTileEntityId);
    }

    public static int temperatureEnergyCost(int temp, int multiSize) {
        return temp <= 300 ? 0 : (int)Math.exp(((double)temp - 100.0 + (double)(multiSize * 5)) / 100.0);
    }

    public static int temperatureForEnergy(int EUt) {
        if (EUt <= 8) {
            return 300;
        }
        return (int)(Math.log(EUt) * 100.0) + 100;
    }

    public NBTTagCompound writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        data.func_74768_a("temp", this.temp);
        data.func_74768_a("size", this.size);
        data.func_74768_a("targetTemp", this.targetTemp);
        data.func_74757_a("canAchieveTargetTemp", this.canAchieveTargetTemp);
        data.func_74757_a("hasEnoughEnergy", this.hasEnoughEnergy);
        data.func_74757_a("adaptable", this.adaptable);
        return data;
    }

    public void setTemp(int temp) {
        this.temp = temp;
        if (!this.getWorld().field_72995_K) {
            this.writeCustomData(600, buf -> buf.writeInt(temp));
            this.markDirty();
        }
    }

    public void receiveCustomData(int dataId, PacketBuffer buf) {
        super.receiveCustomData(dataId, buf);
        if (dataId == 600) {
            this.temp = buf.readInt();
            this.scheduleRenderUpdate();
        }
    }

    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.temp = data.func_74762_e("temp");
        this.targetTemp = data.func_74762_e("targetTemp");
        this.size = data.func_74762_e("size");
        this.canAchieveTargetTemp = data.func_74767_n("canAchieveTargetTemp");
        this.hasEnoughEnergy = data.func_74767_n("hasEnoughEnergy");
        this.adaptable = data.func_74767_n("adaptable");
    }

    public void writeInitialSyncData(PacketBuffer buf) {
        super.writeInitialSyncData(buf);
        buf.writeInt(this.temp);
        buf.writeInt(this.targetTemp);
        buf.writeInt(this.size);
        buf.writeBoolean(this.canAchieveTargetTemp);
        buf.writeBoolean(this.hasEnoughEnergy);
        buf.writeBoolean(this.adaptable);
    }

    public void receiveInitialSyncData(PacketBuffer buf) {
        super.receiveInitialSyncData(buf);
        this.temp = buf.readInt();
        this.targetTemp = buf.readInt();
        this.size = buf.readInt();
        this.canAchieveTargetTemp = buf.readBoolean();
        this.hasEnoughEnergy = buf.readBoolean();
        this.adaptable = buf.readBoolean();
    }

    public boolean checkRecipe(Recipe recipe, boolean consumeIfSuccess) {
        int recipeTemp = (Integer)recipe.getProperty((RecipeProperty)ElectricBakingOvenRecipeBuilder.TemperatureProperty.getInstance(), (Object)300);
        if (this.adaptable) {
            this.targetTemp = recipeTemp;
            this.canRunRecipe = true;
        }
        return recipeTemp == this.temp;
    }

    public int getActualLightValue() {
        return this.temp > 305 ? 15 : 0;
    }

    public double getFillPercentage(int index) {
        return Math.min(1.0, ((double)this.temp - 300.0) / 400.0);
    }

    public TextureArea getProgressBarTexture(int index) {
        return GTFOGuiTextures.PROGRESS_BAR_SINGLE_HEAT;
    }

    public void addBarHoverText(List<ITextComponent> hoverList, int index) {
        hoverList.add((ITextComponent)new TextComponentTranslation("gregtechfoodoption.multiblock.electric_baking_oven.tooltip.1", new Object[]{this.temp}));
    }

    public SoundEvent getBreakdownSound() {
        return GTSoundEvents.BREAKDOWN_ELECTRICAL;
    }

    public boolean canCreateSound() {
        return this.temp > 300 && this.recipeMapWorkable.isWorkingEnabled();
    }

    @NotNull
    protected TextureArea getLogo() {
        return GTFOGuiTextures.GTFO_LOGO_WORKING;
    }

    @NotNull
    protected TextureArea getWarningLogo() {
        return GTFOGuiTextures.GTFO_LOGO_WARNING;
    }

    @NotNull
    protected TextureArea getErrorLogo() {
        return GTFOGuiTextures.GTFO_LOGO_ERROR;
    }

    public int getAdaptableMode() {
        return this.adaptable ? 0 : 1;
    }

    public void setAdaptableMode(int mode) {
        this.adaptable = mode == 0;
    }

    @NotNull
    protected Widget getFlexButton(int x, int y, int width, int height) {
        return new ImageCycleButtonWidget(x, y, width, height, GTFOGuiTextures.BUTTON_ADAPTABILITY, 2, this::getAdaptableMode, this::setAdaptableMode).setTooltipHoverString(mode -> {
            String tooltip = "";
            switch (mode) {
                case 0: {
                    tooltip = "gregtechfoodoption.multiblock.electric_baking_oven.adaptable_on";
                    break;
                }
                case 1: {
                    tooltip = "gregtechfoodoption.multiblock.electric_baking_oven.adaptable_off";
                }
            }
            return tooltip;
        });
    }

    @NotNull
    protected Widget getTemperatureButton(int x, int y, int width, int height) {
        WidgetGroup group = new WidgetGroup(x, y, width, height);
        group.addWidget((Widget)new ClickButtonWidget(0, 0, 9, 18, "", this::decrementTemperatureTarget).setButtonTexture(GuiTextures.BUTTON_THROTTLE_MINUS).setTooltipText("gregtechfoodoption.multiblock.electric_baking_oven.temp_decrement", new Object[0]));
        group.addWidget((Widget)new ClickButtonWidget(9, 0, 9, 18, "", this::incrementTemperatureTarget).setButtonTexture(GuiTextures.BUTTON_THROTTLE_PLUS).setTooltipText("gregtechfoodoption.multiblock.electric_baking_oven.temp_increment", new Object[0]));
        return group;
    }

    protected ModularUI.Builder createUITemplate(EntityPlayer entityPlayer) {
        ModularUI.Builder builder = ModularUI.builder((IGuiTexture)GuiTextures.BACKGROUND, (int)198, (int)208);
        builder.image(4, 4, 190, 109, (IGuiTexture)GuiTextures.DISPLAY);
        builder.label(9, 9, this.getMetaFullName(), 0xFFFFFF);
        builder.widget((Widget)new AdvancedTextWidget(9, 20, this::addDisplayText, 0xFFFFFF).setMaxWidthLimit(181).setClickHandler((x$0, x$1) -> this.handleDisplayClick((String)x$0, (Widget.ClickData)x$1)));
        ProgressWidget progressBar = new ProgressWidget(() -> this.getFillPercentage(0), 4, 115, 190, 7, this.getProgressBarTexture(0), ProgressWidget.MoveType.HORIZONTAL).setHoverTextConsumer(list -> this.addBarHoverText((List<ITextComponent>)list, 0));
        builder.widget((Widget)progressBar);
        IControllable controllable = (IControllable)this.getCapability(GregtechTileCapabilities.CAPABILITY_CONTROLLABLE, null);
        if (controllable != null) {
            builder.widget((Widget)new ImageCycleButtonWidget(173, 183, 18, 18, GuiTextures.BUTTON_POWER, () -> ((IControllable)controllable).isWorkingEnabled(), arg_0 -> ((IControllable)controllable).setWorkingEnabled(arg_0)));
            builder.widget((Widget)new ImageWidget(173, 201, 18, 6, (IGuiTexture)GuiTextures.BUTTON_POWER_DETAIL));
        }
        builder.widget(this.getTemperatureButton(173, 143, 18, 18));
        builder.widget(this.getFlexButton(173, 124, 18, 18));
        builder.widget((Widget)new ImageWidget(173, 161, 18, 18, (IGuiTexture)GuiTextures.BUTTON_VOID_NONE).setTooltip("gregtech.gui.multiblock_voiding_not_supported"));
        builder.widget((Widget)new IndicatorImageWidget(174, 93, 17, 17, this.getLogo()).setWarningStatus(this.getWarningLogo(), x$0 -> this.addWarningText((List)x$0)).setErrorStatus(this.getErrorLogo(), x$0 -> this.addErrorText((List)x$0)));
        builder.bindPlayerInventory(entityPlayer.field_71071_by, 125);
        return builder;
    }

    public void renderMetaTileEntity(CCRenderState renderState, Matrix4 translation, IVertexOperation[] pipeline) {
        super.renderMetaTileEntity(renderState, translation, pipeline);
        this.getFrontOverlay().renderOrientedState(renderState, translation, pipeline, this.getFrontFacing(), this.temp > 300, this.recipeMapWorkable.isWorkingEnabled());
    }

    private class ElectricBakingOvenLogic
    extends MultiblockRecipeLogic {
        public ElectricBakingOvenLogic(RecipeMapMultiblockController tileEntity) {
            super(tileEntity);
        }

        public int getParallelLimit() {
            return ((MetaTileEntityElectricBakingOven)this.getMetaTileEntity()).size;
        }

        protected int[] calculateOverclock(Recipe recipe) {
            return new int[]{0, recipe.getDuration()};
        }

        public int getRecipeEUt() {
            return MetaTileEntityElectricBakingOven.temperatureEnergyCost(MetaTileEntityElectricBakingOven.this.temp, MetaTileEntityElectricBakingOven.this.size);
        }

        public boolean isWorking() {
            return MetaTileEntityElectricBakingOven.this.temp > 300 && !this.hasNotEnoughEnergy && this.workingEnabled;
        }

        @NotNull
        public ParallelLogicType getParallelLogicType() {
            return ParallelLogicType.MULTIPLY;
        }

        protected void updateRecipeProgress() {
            super.updateRecipeProgress();
            MetaTileEntityElectricBakingOven.this.canRunRecipe = true;
        }
    }
}

