/*
 * Decompiled with CFR 0.152.
 */
package gregtechfoodoption.machines.farmer;

import gregtechfoodoption.integration.agricraft.GTFOAgriCraftFarmerMode;
import gregtechfoodoption.machines.farmer.BlockCropsFarmerMode;
import gregtechfoodoption.machines.farmer.ChorusFarmerMode;
import gregtechfoodoption.machines.farmer.CocoaFarmerMode;
import gregtechfoodoption.machines.farmer.FarmerMode;
import gregtechfoodoption.machines.farmer.GTFOBerryFarmerMode;
import gregtechfoodoption.machines.farmer.GTFOCropFarmerMode;
import gregtechfoodoption.machines.farmer.GTFORootCropFarmerMode;
import gregtechfoodoption.machines.farmer.GroundClearingFarmerMode;
import gregtechfoodoption.machines.farmer.HeightCropFarmerMode;
import gregtechfoodoption.machines.farmer.MetaTileEntityFarmer;
import gregtechfoodoption.machines.farmer.NetherWartFarmerMode;
import gregtechfoodoption.machines.farmer.StemFarmerMode;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Loader;

public class FarmerModeRegistry {
    private static final List<FarmerMode> farmerModes = new ArrayList<FarmerMode>();
    public static boolean canUseAirOptimization = true;

    public static FarmerMode findSuitableFarmerMode(IBlockState state, MetaTileEntityFarmer farmer, BlockPos.MutableBlockPos pos, World world) {
        for (FarmerMode mode : farmerModes) {
            if (!mode.canOperate(state, farmer, (BlockPos)pos, world)) continue;
            return mode;
        }
        return null;
    }

    public static FarmerMode findSuitableFarmerMode(ItemStack stack, BlockPos.MutableBlockPos operationPos, BlockPos.MutableBlockPos farmerPos, EnumFacing facing, World world) {
        for (FarmerMode mode : farmerModes) {
            if (!mode.canPlaceItem(stack) || !mode.canPlaceAt(operationPos, farmerPos, facing, world)) continue;
            return mode;
        }
        return null;
    }

    public static FarmerMode findSuitableFarmerMode(ItemStack stack) {
        for (FarmerMode mode : farmerModes) {
            if (!mode.canPlaceItem(stack)) continue;
            return mode;
        }
        return null;
    }

    public static void registerFarmerMode(FarmerMode mode) {
        farmerModes.add(mode);
    }

    public static FarmerMode getAnyMode() {
        return farmerModes.isEmpty() ? null : farmerModes.get(0);
    }

    public static void registerDefaultModes() {
        FarmerModeRegistry.registerFarmerMode(new BlockCropsFarmerMode(Blocks.field_150464_aj, Items.field_151014_N));
        FarmerModeRegistry.registerFarmerMode(new BlockCropsFarmerMode(Blocks.field_150469_bN, Items.field_151174_bG));
        FarmerModeRegistry.registerFarmerMode(new BlockCropsFarmerMode(Blocks.field_150459_bM, Items.field_151172_bF));
        FarmerModeRegistry.registerFarmerMode(new BlockCropsFarmerMode(Blocks.field_185773_cZ, Items.field_185163_cU));
        FarmerModeRegistry.registerFarmerMode(new CocoaFarmerMode());
        FarmerModeRegistry.registerFarmerMode(new NetherWartFarmerMode());
        FarmerModeRegistry.registerFarmerMode(new StemFarmerMode(Blocks.field_150440_ba, Items.field_151081_bc));
        FarmerModeRegistry.registerFarmerMode(new StemFarmerMode(Blocks.field_150423_aK, Items.field_151080_bb));
        FarmerModeRegistry.registerFarmerMode(new HeightCropFarmerMode((Block)Blocks.field_150436_aH, Items.field_151120_aE));
        FarmerModeRegistry.registerFarmerMode(new HeightCropFarmerMode((Block)Blocks.field_150434_aF, Item.func_150898_a((Block)Blocks.field_150434_aF)));
        FarmerModeRegistry.registerFarmerMode(new GroundClearingFarmerMode((Block)Blocks.field_150330_I));
        FarmerModeRegistry.registerFarmerMode(new GroundClearingFarmerMode((Block)Blocks.field_150329_H));
        FarmerModeRegistry.registerFarmerMode(new GroundClearingFarmerMode((Block)Blocks.field_150328_O));
        FarmerModeRegistry.registerFarmerMode(new GroundClearingFarmerMode((Block)Blocks.field_150327_N));
        FarmerModeRegistry.registerFarmerMode(new GroundClearingFarmerMode((Block)Blocks.field_150337_Q));
        FarmerModeRegistry.registerFarmerMode(new GroundClearingFarmerMode((Block)Blocks.field_150338_P));
        FarmerModeRegistry.registerFarmerMode(new GroundClearingFarmerMode(Blocks.field_150431_aC));
        FarmerModeRegistry.registerFarmerMode(new GroundClearingFarmerMode((Block)Blocks.field_150398_cm));
        FarmerModeRegistry.registerFarmerMode(new ChorusFarmerMode());
        FarmerModeRegistry.registerFarmerMode(new GTFORootCropFarmerMode());
        FarmerModeRegistry.registerFarmerMode(new GTFOBerryFarmerMode());
        FarmerModeRegistry.registerFarmerMode(new GTFOCropFarmerMode());
        if (Loader.isModLoaded((String)"agricraft")) {
            FarmerModeRegistry.registerFarmerMode(new GTFOAgriCraftFarmerMode());
        }
    }
}

