/*
 * Decompiled with CFR 0.152.
 */
package gregtechfoodoption.machines;

import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Matrix4;
import gregtech.api.GTValues;
import gregtech.api.capability.GregtechDataCodes;
import gregtech.api.capability.impl.FluidTankList;
import gregtech.api.gui.GuiTextures;
import gregtech.api.gui.IUIHolder;
import gregtech.api.gui.ModularUI;
import gregtech.api.gui.Widget;
import gregtech.api.gui.resources.IGuiTexture;
import gregtech.api.gui.widgets.TankWidget;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.TieredMetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.unification.material.Materials;
import gregtech.client.renderer.texture.cube.OrientedOverlayRenderer;
import gregtech.core.sound.GTSoundEvents;
import gregtechfoodoption.client.GTFOClientHandler;
import gregtechfoodoption.utils.GTFODamageSources;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class MetaTileEntityMobExterminator
extends TieredMetaTileEntity {
    private static final int BASE_EU_CONSUMPTION_PER_KILL = 2;
    private static final int RADIUS = 4;
    private boolean isWorking;
    private AxisAlignedBB areaBoundingBox;
    private BlockPos areaCenterPos;
    public static int LOOTING_USED;
    private final FluidTank fluidTank;

    public MetaTileEntityMobExterminator(ResourceLocation metaTileEntityId, int tier) {
        super(metaTileEntityId, tier);
        this.fluidTank = new FluidTank(tier * 4000);
        this.initializeInventory();
    }

    public MetaTileEntity createMetaTileEntity(IGregTechTileEntity holder) {
        return new MetaTileEntityMobExterminator(this.metaTileEntityId, this.getTier());
    }

    public void renderMetaTileEntity(CCRenderState renderState, Matrix4 translation, IVertexOperation[] pipeline) {
        super.renderMetaTileEntity(renderState, translation, pipeline);
        OrientedOverlayRenderer renderer = GTFOClientHandler.MOB_EXTERMINATOR_OVERLAY;
        renderer.renderOrientedState(renderState, translation, pipeline, Cuboid6.full, this.getFrontFacing(), this.isWorking, true);
    }

    public void update() {
        boolean isWorkingNow;
        super.update();
        boolean bl = isWorkingNow = this.energyContainer.getEnergyStored() >= (long)this.getEnergyConsumedPerKill() && this.isBlockRedstonePowered();
        if (this.getWorld().field_72995_K) {
            return;
        }
        if (isWorkingNow != this.isWorking) {
            this.isWorking = isWorkingNow;
            this.writeCustomData(GregtechDataCodes.IS_WORKING, buffer -> buffer.writeBoolean(isWorkingNow));
        }
        if (this.getOffsetTimer() % 20L != 0L) {
            return;
        }
        if (isWorkingNow) {
            List mobs;
            BlockPos selfPos = this.getPos();
            if (this.areaCenterPos == null || this.areaBoundingBox == null) {
                this.areaCenterPos = selfPos.func_177967_a(this.getFrontFacing(), 5);
                this.areaBoundingBox = new AxisAlignedBB(this.areaCenterPos).func_72314_b(4.0, 0.0, 4.0);
            }
            if (!(mobs = this.getWorld().func_72872_a(EntityLivingBase.class, this.areaBoundingBox)).isEmpty()) {
                int loopLength = Math.min(this.getMobsPerCycle(), mobs.size());
                for (int i = 0; i < loopLength; ++i) {
                    LOOTING_USED = this.getTier() - 1;
                    ((EntityLivingBase)mobs.get(i)).func_70097_a(GTFODamageSources.getExterminationDamage(this.getWorld()), 40.0f);
                    if (i > 3) {
                        this.fluidTank.drain(1, true);
                    }
                    this.energyContainer.removeEnergy((long)this.getEnergyConsumedPerKill());
                }
            }
        }
    }

    private int getMobsPerCycle() {
        int maximumKills = Math.toIntExact(this.energyContainer.getEnergyStored() / (long)this.getEnergyConsumedPerKill());
        FluidStack currentGas = this.fluidTank.getFluid();
        if (currentGas != null && currentGas.isFluidEqual(Materials.NitrousOxide.getFluid(1))) {
            int amountToExtract = Math.min(currentGas.amount, 12);
            return Math.min(amountToExtract + 4, maximumKills);
        }
        return Math.min(4, maximumKills);
    }

    protected ModularUI createUI(EntityPlayer entityPlayer) {
        ModularUI.Builder builder = new ModularUI.Builder((IGuiTexture)GuiTextures.BACKGROUND, 170, 90);
        builder.image(7, 16, 81, 55, (IGuiTexture)GuiTextures.DISPLAY);
        TankWidget tankWidget = new TankWidget((IFluidTank)this.fluidTank, 69, 52, 18, 18).setHideTooltip(true).setAlwaysShowFull(true);
        builder.widget((Widget)tankWidget);
        builder.label(11, 20, "gregtech.gui.fluid_amount", 0xFFFFFF);
        builder.dynamicLabel(11, 30, () -> ((TankWidget)tankWidget).getFormattedFluidAmount(), 0xFFFFFF);
        builder.dynamicLabel(11, 40, () -> ((TankWidget)tankWidget).getFluidLocalizedName(), 0xFFFFFF);
        return builder.label(6, 6, this.getMetaFullName()).build((IUIHolder)this.getHolder(), entityPlayer);
    }

    public void writeInitialSyncData(PacketBuffer buf) {
        super.writeInitialSyncData(buf);
        buf.writeBoolean(this.isWorking);
    }

    public void receiveInitialSyncData(PacketBuffer buf) {
        super.receiveInitialSyncData(buf);
        this.isWorking = buf.readBoolean();
    }

    public void receiveCustomData(int dataId, PacketBuffer buf) {
        super.receiveCustomData(dataId, buf);
        if (dataId == GregtechDataCodes.IS_WORKING) {
            this.isWorking = buf.readBoolean();
            this.getHolder().scheduleRenderUpdate();
        }
    }

    protected int getEnergyConsumedPerKill() {
        return 2 * (1 << (this.getTier() - 1) * 2);
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack stack, @Nullable World player, List<String> tooltip, boolean advanced) {
        tooltip.add(I18n.func_135052_a((String)"gregtechfoodoption.machine.mob_exterminator.tooltip", (Object[])new Object[]{this.getTier() - 1}));
        tooltip.add(I18n.func_135052_a((String)"gregtech.universal.tooltip.max_voltage_in", (Object[])new Object[]{this.energyContainer.getInputVoltage(), GTValues.VNF[this.getTier()]}));
        tooltip.add(I18n.func_135052_a((String)"gregtech.universal.tooltip.energy_storage_capacity", (Object[])new Object[]{this.energyContainer.getEnergyCapacity()}));
        tooltip.add(I18n.func_135052_a((String)"gregtech.universal.tooltip.requires_redstone", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"gregtechfoodoption.machine.mob_exterminator.tooltip.consumption", (Object[])new Object[]{this.getEnergyConsumedPerKill()}));
        tooltip.add(I18n.func_135052_a((String)"gregtechfoodoption.machine.mob_exterminator.tooltip.nitrous", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"gregtechfoodoption.machine.mob_exterminator.tooltip.warning", (Object[])new Object[0]));
    }

    protected FluidTankList createImportFluidHandler() {
        return new FluidTankList(true, new IFluidTank[]{this.fluidTank});
    }

    public SoundEvent getSound() {
        return GTSoundEvents.MACERATOR;
    }

    public boolean isActive() {
        return this.isWorking;
    }
}

