/*
 * Decompiled with CFR 0.152.
 */
package gregtechfoodoption.item;

import gregtech.api.GTValues;
import gregtech.api.capability.impl.AbstractRecipeLogic;
import gregtech.api.gui.GuiTextures;
import gregtech.api.gui.ModularUI;
import gregtech.api.gui.Widget;
import gregtech.api.gui.resources.IGuiTexture;
import gregtech.api.gui.widgets.CycleButtonWidget;
import gregtech.api.gui.widgets.GhostCircuitSlotWidget;
import gregtech.api.gui.widgets.ImageWidget;
import gregtech.api.gui.widgets.LabelWidget;
import gregtech.api.gui.widgets.SlotWidget;
import gregtech.api.gui.widgets.ToggleButtonWidget;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.SimpleMachineMetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.recipes.RecipeMap;
import gregtech.client.renderer.ICubeRenderer;
import gregtechfoodoption.client.GTFOGuiTextures;
import java.util.function.Function;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.items.IItemHandler;

public class GTFOSimpleMachineMetaTileEntity
extends SimpleMachineMetaTileEntity {
    private static final int FONT_HEIGHT = 9;

    public GTFOSimpleMachineMetaTileEntity(ResourceLocation metaTileEntityId, RecipeMap<?> recipeMap, ICubeRenderer renderer, int tier, boolean hasFrontFacing) {
        super(metaTileEntityId, recipeMap, renderer, tier, hasFrontFacing);
    }

    public GTFOSimpleMachineMetaTileEntity(ResourceLocation metaTileEntityId, RecipeMap<?> recipeMap, ICubeRenderer renderer, int tier, boolean hasFrontFacing, Function<Integer, Integer> tankScalingFunction) {
        super(metaTileEntityId, recipeMap, renderer, tier, hasFrontFacing, tankScalingFunction);
    }

    public MetaTileEntity createMetaTileEntity(IGregTechTileEntity tileEntity) {
        return new GTFOSimpleMachineMetaTileEntity(this.metaTileEntityId, this.workable.getRecipeMap(), this.renderer, this.getTier(), this.hasFrontFacing(), this.getTankScalingFunction());
    }

    protected ModularUI.Builder createGuiTemplate(EntityPlayer player) {
        RecipeMap workableRecipeMap = this.workable.getRecipeMap();
        int yOffset = 0;
        if (workableRecipeMap.getMaxInputs() >= 6 || workableRecipeMap.getMaxFluidInputs() >= 6 || workableRecipeMap.getMaxOutputs() >= 6 || workableRecipeMap.getMaxFluidOutputs() >= 6) {
            yOffset = 9;
        }
        ModularUI.Builder builder = workableRecipeMap.createUITemplate(() -> ((AbstractRecipeLogic)this.workable).getProgressPercent(), this.importItems, this.exportItems, this.importFluids, this.exportFluids, yOffset).widget((Widget)new LabelWidget(5, 5, this.getMetaFullName(), new Object[0])).widget((Widget)new SlotWidget((IItemHandler)this.chargerInventory, 0, 79, 62 + yOffset, true, true, false).setBackgroundTexture(new IGuiTexture[]{GuiTextures.SLOT, GuiTextures.CHARGER_OVERLAY}).setTooltipText("gregtech.gui.charger_slot.tooltip", new Object[]{GTValues.VNF[this.getTier()], GTValues.VNF[this.getTier()]})).widget((Widget)new ImageWidget(79, 42 + yOffset, 18, 18, (IGuiTexture)GuiTextures.INDICATOR_NO_ENERGY).setIgnoreColor(true).setPredicate(() -> ((AbstractRecipeLogic)this.workable).isHasNotEnoughEnergy())).bindPlayerInventory(player.field_71071_by, (IGuiTexture)GuiTextures.SLOT, yOffset);
        int leftButtonStartX = 7;
        if (this.exportItems.getSlots() > 0) {
            builder.widget((Widget)new ToggleButtonWidget(leftButtonStartX, 62 + yOffset, 18, 18, GuiTextures.BUTTON_ITEM_OUTPUT, () -> ((GTFOSimpleMachineMetaTileEntity)this).isAutoOutputItems(), arg_0 -> ((GTFOSimpleMachineMetaTileEntity)this).setAutoOutputItems(arg_0)).setTooltipText("gregtech.gui.item_auto_output.tooltip", new Object[0]).shouldUseBaseBackground());
            leftButtonStartX += 18;
        }
        if (this.exportFluids.getTanks() > 0) {
            builder.widget((Widget)new ToggleButtonWidget(leftButtonStartX, 62 + yOffset, 18, 18, GuiTextures.BUTTON_FLUID_OUTPUT, () -> ((GTFOSimpleMachineMetaTileEntity)this).isAutoOutputFluids(), arg_0 -> ((GTFOSimpleMachineMetaTileEntity)this).setAutoOutputFluids(arg_0)).setTooltipText("gregtech.gui.fluid_auto_output.tooltip", new Object[0]).shouldUseBaseBackground());
            leftButtonStartX += 18;
        }
        builder.widget((Widget)new CycleButtonWidget(leftButtonStartX, 62 + yOffset, 18, 18, this.workable.getAvailableOverclockingTiers(), () -> ((AbstractRecipeLogic)this.workable).getOverclockTier(), arg_0 -> ((AbstractRecipeLogic)this.workable).setOverclockTier(arg_0)).setTooltipHoverString("gregtech.gui.overclock.description").setButtonTexture(GuiTextures.BUTTON_OVERCLOCK));
        if (this.exportItems.getSlots() + this.exportFluids.getTanks() <= 9) {
            ImageWidget logo = new ImageWidget(152, 62 + yOffset, 17, 17, (IGuiTexture)((Boolean)GTValues.XMAS.get() != false ? GTFOGuiTextures.GTFO_LOGO_XMAS : GTFOGuiTextures.GTFO_LOGO)).setIgnoreColor(true);
            if (this.circuitInventory != null) {
                SlotWidget circuitSlot = new GhostCircuitSlotWidget(this.circuitInventory, 0, 124, 62 + yOffset).setBackgroundTexture(new IGuiTexture[]{GuiTextures.SLOT, this.getCircuitSlotOverlay()});
                this.getCircuitSlotTooltip(circuitSlot);
                builder.widget((Widget)circuitSlot).widget((Widget)logo);
            }
        }
        return builder;
    }
}

