/*
 * Decompiled with CFR 0.152.
 */
package gregtechfoodoption.item;

import gregtech.api.gui.GuiTextures;
import gregtech.api.gui.IUIHolder;
import gregtech.api.gui.ModularUI;
import gregtech.api.gui.Widget;
import gregtech.api.gui.resources.IGuiTexture;
import gregtech.api.items.gui.ItemUIFactory;
import gregtech.api.items.gui.PlayerInventoryHolder;
import gregtech.api.items.metaitem.stats.IItemBehaviour;
import gregtechfoodoption.gui.widgets.KitchenRecipeWidget;
import gregtechfoodoption.item.GTFOMetaItem;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;

public class GTFOKitchenRecipeBehaviour
implements ItemUIFactory,
IItemBehaviour {
    public ModularUI createUI(PlayerInventoryHolder playerInventoryHolder, EntityPlayer entityPlayer) {
        ModularUI.Builder builder = ModularUI.builder((IGuiTexture)GuiTextures.BACKGROUND, (int)220, (int)240);
        ItemStack stack = playerInventoryHolder.getCurrentItem();
        builder.widget((Widget)new KitchenRecipeWidget(10, 10, 180, 243, GTFOKitchenRecipeBehaviour.getRecipeCount(stack), tag -> GTFOKitchenRecipeBehaviour.addRecipe(stack, tag), index -> GTFOKitchenRecipeBehaviour.getRecipe(stack, index), finalResult -> GTFOKitchenRecipeBehaviour.setFinalResult(stack, finalResult), index -> GTFOKitchenRecipeBehaviour.deleteRecipe(stack, index), GTFOKitchenRecipeBehaviour.getFinalResult(stack)));
        builder.bindPlayerInventory(entityPlayer.field_71071_by, (IGuiTexture)GuiTextures.SLOT, 30, 155);
        return builder.build((IUIHolder)playerInventoryHolder, entityPlayer);
    }

    private static void addRecipe(ItemStack stack, NBTTagCompound recipe) {
        if (!GTFOMetaItem.KITCHEN_RECIPE.isItemEqual(stack)) {
            return;
        }
        NBTTagCompound tag = stack.func_77978_p();
        if (stack.func_77978_p() == null) {
            tag = new NBTTagCompound();
        }
        int count = tag.func_74762_e("recipecount");
        tag.func_74768_a("recipecount", count + 1);
        tag.func_74782_a("recipe" + count, (NBTBase)recipe);
        stack.func_77982_d(tag);
    }

    private static NBTTagCompound getRecipe(ItemStack stack, int index) {
        if (!GTFOMetaItem.KITCHEN_RECIPE.isItemEqual(stack)) {
            return null;
        }
        if (stack.func_77978_p() == null) {
            return null;
        }
        return stack.func_77978_p().func_74775_l("recipe" + index);
    }

    private static void deleteRecipe(ItemStack stack, int location) {
        if (!GTFOMetaItem.KITCHEN_RECIPE.isItemEqual(stack)) {
            return;
        }
        NBTTagCompound tag = stack.func_77978_p();
        if (stack.func_77978_p() == null) {
            return;
        }
        int count = tag.func_74762_e("recipecount");
        if (location >= count) {
            return;
        }
        tag.func_82580_o("recipe" + location);
        for (int i = location; i < count - 1; ++i) {
            tag.func_74782_a("recipe" + i, (NBTBase)tag.func_74775_l("recipe" + (i + 1)));
        }
        tag.func_74768_a("recipecount", count - 1);
        stack.func_77982_d(tag);
    }

    private static int getRecipeCount(ItemStack stack) {
        if (!GTFOMetaItem.KITCHEN_RECIPE.isItemEqual(stack)) {
            return 0;
        }
        if (stack.func_77978_p() == null) {
            return 0;
        }
        return stack.func_77978_p().func_74762_e("recipecount");
    }

    private static void setFinalResult(ItemStack stack, ItemStack result) {
        if (!GTFOMetaItem.KITCHEN_RECIPE.isItemEqual(stack)) {
            return;
        }
        NBTTagCompound tag = stack.func_77978_p();
        if (stack.func_77978_p() == null) {
            tag = new NBTTagCompound();
        }
        tag.func_74782_a("finalresult", (NBTBase)result.serializeNBT());
        stack.func_77982_d(tag);
    }

    private static ItemStack getFinalResult(ItemStack stack) {
        if (!GTFOMetaItem.KITCHEN_RECIPE.isItemEqual(stack)) {
            return null;
        }
        if (stack.func_77978_p() == null) {
            return null;
        }
        return new ItemStack(stack.func_77978_p().func_74775_l("finalresult"));
    }

    public ActionResult<ItemStack> onItemRightClick(World world, EntityPlayer player, EnumHand hand) {
        ItemStack heldItem = player.func_184586_b(hand);
        if (!world.field_72995_K) {
            PlayerInventoryHolder holder = new PlayerInventoryHolder(player, hand);
            holder.openUI();
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)heldItem);
    }

    public void addInformation(ItemStack itemStack, List<String> lines) {
        ItemStack finalItem = GTFOKitchenRecipeBehaviour.getFinalResult(itemStack);
        if (finalItem != null && !finalItem.func_190926_b()) {
            lines.add(I18n.func_135052_a((String)"gregtechfoodoption.kitchen_recipe.final_result", (Object[])new Object[]{finalItem.func_82833_r()}));
        }
    }
}

