/*
 * Decompiled with CFR 0.152.
 */
package gregtechfoodoption.item;

import gregtechfoodoption.block.GTFOBerryBush;
import gregtechfoodoption.item.GTFOCropSeedBehaviour;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class GTFOBerrySeedBehaviour
extends GTFOCropSeedBehaviour {
    public GTFOBerrySeedBehaviour(GTFOBerryBush cropBlock, ItemStack seed, ItemStack crop) {
        super(cropBlock, seed, crop);
    }

    @Override
    public ActionResult<ItemStack> onItemUse(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!this.isBlocked(world, pos, player)) {
            return super.onItemUse(player, world, pos, hand, facing, hitX, hitY, hitZ);
        }
        return new ActionResult(EnumActionResult.FAIL, (Object)player.func_184586_b(hand));
    }

    private boolean isBlocked(World world, BlockPos pos, EntityPlayer player) {
        AtomicInteger areAnyBlocked = new AtomicInteger(0);
        AtomicReference blockedCrop = new AtomicReference();
        BlockPos.func_177980_a((BlockPos)pos.func_177984_a().func_177974_f().func_177978_c(), (BlockPos)pos.func_177984_a().func_177976_e().func_177968_d()).forEach(crop -> {
            if (crop.equals((Object)pos.func_177984_a()) || world.func_180495_p(crop).func_177230_c() instanceof GTFOBerryBush) {
                AtomicBoolean isBlocked = new AtomicBoolean(true);
                BlockPos.func_177980_a((BlockPos)crop.func_177974_f().func_177978_c(), (BlockPos)crop.func_177976_e().func_177968_d()).forEach(blockpos -> {
                    if (!blockpos.equals((Object)pos.func_177984_a()) && world.func_180495_p(blockpos).func_177230_c().isAir(world.func_180495_p(blockpos), (IBlockAccess)world, blockpos)) {
                        isBlocked.set(false);
                    }
                });
                if (isBlocked.get()) {
                    blockedCrop.set(crop);
                    areAnyBlocked.set(areAnyBlocked.get() + 1);
                }
            }
        });
        if (world.field_72995_K && areAnyBlocked.get() > 0) {
            String posString = "(" + ((BlockPos)blockedCrop.get()).func_177958_n() + ", " + ((BlockPos)blockedCrop.get()).func_177956_o() + ", " + ((BlockPos)blockedCrop.get()).func_177952_p() + ")";
            player.func_145747_a((ITextComponent)new TextComponentTranslation("gregtechfoodoption.blocked", new Object[]{posString, areAnyBlocked.get()}));
        }
        return areAnyBlocked.get() > 0;
    }

    @Override
    public void addInformation(ItemStack itemStack, List<String> lines) {
        super.addInformation(itemStack, lines);
        for (int i = 0; i < 4; ++i) {
            lines.add(I18n.func_135052_a((String)("gregtechfoodoption.berry.description." + i), (Object[])new Object[0]));
        }
    }
}

