/*
 * Decompiled with CFR 0.152.
 */
package gregtechfoodoption.integration.jei;

import gregtech.api.gui.GuiTextures;
import gregtech.common.items.MetaItems;
import gregtechfoodoption.integration.jei.LacingInfo;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import org.jetbrains.annotations.Nullable;

public class LacingCategory
implements IRecipeCategory<LacingInfo> {
    private final IDrawable icon;
    protected final IDrawable slot;
    private String potionName;
    private final IGuiHelper guiHelper;

    public LacingCategory(IGuiHelper guiHelper) {
        this.guiHelper = guiHelper;
        this.icon = guiHelper.createDrawableIngredient((Object)MetaItems.BOTTLE_PURPLE_DRINK.getStackForm());
        this.slot = guiHelper.drawableBuilder(GuiTextures.SLOT.imageLocation, 0, 0, 18, 18).setTextureSize(18, 18).build();
    }

    public void setRecipe(IRecipeLayout recipeLayout, LacingInfo recipeWrapper, IIngredients ingredients) {
        IGuiItemStackGroup itemStackGroup = recipeLayout.getItemStacks();
        itemStackGroup.init(0, true, 79, 5);
        itemStackGroup.set(0, recipeWrapper.getLacingItem());
        this.potionName = recipeWrapper.getPotionName();
    }

    public void drawExtras(Minecraft minecraft) {
        this.slot.draw(minecraft, 79, 5);
    }

    public String getUid() {
        return "gregtechfoodoption:lacing_info";
    }

    public String getTitle() {
        return I18n.func_135052_a((String)"lacing.item_list.name", (Object[])new Object[0]);
    }

    public String getModName() {
        return "GregTech Food Option";
    }

    public IDrawable getBackground() {
        return this.guiHelper.createBlankDrawable(176, 50);
    }

    @Nullable
    public IDrawable getIcon() {
        return this.icon;
    }
}

