/*
 * Decompiled with CFR 0.152.
 */
package gregtechfoodoption.integration.agricraft;

import com.infinityraider.agricraft.api.v1.AgriApi;
import com.infinityraider.agricraft.api.v1.crop.IAgriCrop;
import com.infinityraider.agricraft.api.v1.plant.IAgriPlant;
import com.infinityraider.agricraft.api.v1.render.RenderMethod;
import com.infinityraider.agricraft.api.v1.requirement.IGrowthRequirement;
import com.infinityraider.agricraft.api.v1.soil.IAgriSoil;
import com.infinityraider.agricraft.api.v1.stat.IAgriStat;
import com.infinityraider.agricraft.api.v1.util.FuzzyStack;
import com.infinityraider.agricraft.farming.growthrequirement.GrowthReqBuilder;
import com.infinityraider.agricraft.renderers.PlantRenderer;
import com.infinityraider.infinitylib.render.tessellation.ITessellator;
import gregtechfoodoption.block.GTFOBerryBush;
import gregtechfoodoption.block.GTFOCrop;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.I18n;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class GTFOAgriPlant
implements IAgriPlant {
    private GTFOCrop wrap;
    private List<FuzzyStack> seeds;

    public GTFOAgriPlant(GTFOCrop wrap) {
        this.wrap = wrap;
        this.seeds = new ArrayList<FuzzyStack>();
        this.seeds.add(new FuzzyStack(wrap.getSeedStack(), false, false, new String[]{"agri_growth", "agri_gain", "agri_strength", "agri_analyzed"}));
    }

    @Nonnull
    public String getId() {
        return this.wrap.getName();
    }

    @Nonnull
    public String getPlantName() {
        return this.wrap.func_149732_F();
    }

    @Nonnull
    public String getSeedName() {
        return this.wrap.getSeedStack().func_82833_r();
    }

    @Nonnull
    public Collection<FuzzyStack> getSeedItems() {
        return this.seeds;
    }

    public boolean isWeed() {
        return false;
    }

    public boolean isFertilizable() {
        return true;
    }

    public double getSpreadChance() {
        return 0.05;
    }

    public double getSpawnChance() {
        return 0.0;
    }

    public double getGrowthChanceBase() {
        return this.wrap instanceof GTFOBerryBush ? 0.05 : 0.9;
    }

    public double getGrowthChanceBonus() {
        return 0.025;
    }

    public double getSeedDropChanceBase() {
        return 0.1;
    }

    public double getSeedDropChanceBonus() {
        return 0.2;
    }

    public double getGrassDropChance() {
        return 0.0;
    }

    public int getGrowthStages() {
        return this.wrap instanceof GTFOBerryBush ? 3 : 6;
    }

    public int getTier() {
        return 0;
    }

    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public String getInformation() {
        return I18n.func_135052_a((String)"gregtechfoodoption.crop.agricraft.info", (Object[])new Object[0]);
    }

    @Nonnull
    public ItemStack getSeed() {
        return this.wrap.getSeedStack();
    }

    @Nonnull
    public IGrowthRequirement getGrowthRequirement() {
        GrowthReqBuilder builder = new GrowthReqBuilder();
        if (this.wrap instanceof GTFOBerryBush) {
            builder.addSoil((IAgriSoil)AgriApi.getSoilRegistry().get(Blocks.field_150349_c.func_176223_P()).get());
        }
        builder.addSoil((IAgriSoil)AgriApi.getSoilRegistry().get(Blocks.field_150458_ak.func_176223_P()).get());
        return builder.build();
    }

    public void getPossibleProducts(@Nonnull Consumer<ItemStack> consumer) {
        consumer.accept(this.wrap.getCropStack());
    }

    public void getHarvestProducts(@Nonnull Consumer<ItemStack> consumer, @Nonnull IAgriCrop iAgriCrop, @Nonnull IAgriStat iAgriStat, @Nonnull Random random) {
        if (iAgriCrop.isMature()) {
            for (int i = 0; i < 3; ++i) {
                if (random.nextInt(2 * this.wrap.func_185526_g()) > iAgriCrop.getGrowthStage()) continue;
                consumer.accept(this.wrap.getCropStack().func_77946_l());
            }
        }
    }

    @Nullable
    public ResourceLocation getSeedTexture() {
        return null;
    }

    public float getHeight(int i) {
        return 0.8125f;
    }

    @Nullable
    public RenderMethod getRenderMethod() {
        return RenderMethod.CROSSED;
    }

    @Nullable
    public ResourceLocation getPrimaryPlantTexture(int i) {
        if (this.wrap instanceof GTFOBerryBush) {
            return i < 3 ? new ResourceLocation("gregtechfoodoption", "blocks/berry/ungrown") : new ResourceLocation("gregtechfoodoption", "blocks/berry/" + this.wrap.getName() + "_ripe");
        }
        int possibleAge = Math.min(i, this.wrap.func_185526_g());
        return new ResourceLocation("gregtechfoodoption", "crop/crop_" + this.wrap.getName() + "/stage" + possibleAge);
    }

    @Nullable
    public ResourceLocation getSecondaryPlantTexture(int i) {
        return null;
    }

    @Nonnull
    public List<BakedQuad> getPlantQuads(IExtendedBlockState iExtendedBlockState, int growthStage, EnumFacing enumFacing, Function<ResourceLocation, TextureAtlasSprite> textureToIcon) {
        if (textureToIcon instanceof ITessellator) {
            PlantRenderer.renderPlant((ITessellator)((ITessellator)textureToIcon), (IAgriPlant)this, (int)growthStage);
        }
        return Collections.emptyList();
    }
}

