/*
 * Decompiled with CFR 0.152.
 */
package gregtechfoodoption.gui.widgets;

import gregtech.api.fluids.GTFluid;
import gregtech.api.gui.GuiTextures;
import gregtech.api.gui.Widget;
import gregtech.api.gui.impl.ModularUIContainer;
import gregtech.api.gui.ingredient.IRecipeTransferHandlerWidget;
import gregtech.api.gui.resources.IGuiTexture;
import gregtech.api.gui.widgets.AbstractWidgetGroup;
import gregtech.api.gui.widgets.ClickButtonWidget;
import gregtech.api.gui.widgets.LabelWidget;
import gregtech.api.gui.widgets.PhantomSlotWidget;
import gregtech.api.gui.widgets.SimpleTextWidget;
import gregtech.api.gui.widgets.SlotWidget;
import gregtech.api.items.metaitem.FoodUseManager;
import gregtech.api.items.metaitem.MetaItem;
import gregtech.api.recipes.Recipe;
import gregtech.api.recipes.category.GTRecipeCategory;
import gregtech.api.recipes.ingredients.GTRecipeInput;
import gregtech.api.util.Position;
import gregtech.api.util.Size;
import gregtech.integration.jei.recipe.GTRecipeWrapper;
import gregtechfoodoption.GTFOMaterialHandler;
import gregtechfoodoption.client.GTFOGuiTextures;
import gregtechfoodoption.gui.widgets.PhantomRecipeWidget;
import gregtechfoodoption.integration.applecore.GTFOAppleCoreCompat;
import gregtechfoodoption.item.GTFOMetaItem;
import gregtechfoodoption.item.GTFOMetaItems;
import gregtechfoodoption.machines.multiblock.kitchen.FluidStackInfo;
import gregtechfoodoption.machines.multiblock.kitchen.ItemStackInfo;
import gregtechfoodoption.utils.GTFOLog;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import mezz.jei.api.gui.IGhostIngredientHandler;
import mezz.jei.api.gui.IGuiIngredient;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.recipe.IRecipeWrapper;
import mezz.jei.gui.recipes.RecipeLayout;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;

public class KitchenRecipeWidget
extends AbstractWidgetGroup
implements IRecipeTransferHandlerWidget {
    private Function<Integer, NBTTagCompound> loadingFunction;
    private Consumer<NBTTagCompound> savingFunction;
    private Consumer<NBTTagCompound> deletingFunction;
    private int recipeCount;
    private int recipeShown;
    private PhantomRecipeWidget recipeWidget;
    private ClickButtonWidget leftArrowWidget;
    private ClickButtonWidget rightArrowWidget;
    private ClickButtonWidget deleteButtonWidget;
    private SimpleTextWidget recipeCountLabel;
    private SlotWidget finalResultSlot;
    private ItemStackHandler finalResult = new ItemStackHandler(1){

        @NotNull
        public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
            if (KitchenRecipeWidget.this.isAcceptableItem(stack)) {
                return super.insertItem(slot, stack, simulate);
            }
            return stack;
        }

        protected int getStackLimit(int slot, @NotNull ItemStack stack) {
            return 1;
        }

        public int getSlotLimit(int slot) {
            return 1;
        }
    };
    private List<ItemStack> neededInputs = new ArrayList<ItemStack>();
    private List<FluidStack> neededFluidInputs = new ArrayList<FluidStack>();

    public KitchenRecipeWidget(int x, int y, int width, int height, int recipeCount, Consumer<NBTTagCompound> savingFunction, Function<Integer, NBTTagCompound> loadingFunction, Consumer<ItemStack> resultItemConsumer, Consumer<Integer> deletingFunction, ItemStack finalResultStack) {
        super(new Position(x, y), new Size(width, height));
        if (finalResultStack != null) {
            this.finalResult.setStackInSlot(0, finalResultStack);
        }
        this.addWidget((Widget)new LabelWidget(x, y + 5, "Recipe for:", new Object[0]));
        this.finalResultSlot = new PhantomSlotWidget((IItemHandlerModifiable)this.finalResult, 0, x + 63, y){

            public List<IGhostIngredientHandler.Target<?>> getPhantomTargets(Object ingredient) {
                return Collections.emptyList();
            }
        }.setTooltipText("gregtechfoodoption.kitchen.recipe.warn", new Object[0]);
        this.finalResultSlot.setChangeListener(() -> resultItemConsumer.accept(this.finalResult.getStackInSlot(0)));
        this.finalResultSlot.setBackgroundTexture(new IGuiTexture[]{GuiTextures.SLOT});
        this.addWidget((Widget)this.finalResultSlot);
        this.recipeWidget = new PhantomRecipeWidget(x, y + 10);
        this.addWidget((Widget)this.recipeWidget);
        this.savingFunction = savingFunction;
        this.loadingFunction = loadingFunction;
        this.recipeCount = recipeCount;
        this.recipeWidget.deserializeNBT(loadingFunction.apply(0));
        this.recipeShown = 0;
        this.leftArrowWidget = new ClickButtonWidget(x, y + 120, 9, 9, "", data -> {
            this.setRecipeShown(Math.max(this.getRecipeShown() - 1, 0));
            this.recipeWidget.deserializeNBT((NBTTagCompound)loadingFunction.apply(this.getRecipeShown()));
        }).setButtonTexture(GTFOGuiTextures.BUTTON_LEFT).setShouldClientCallback(true);
        this.addWidget((Widget)this.leftArrowWidget);
        this.rightArrowWidget = new ClickButtonWidget(x + width - 9, y + 120, 9, 9, "", data -> {
            this.setRecipeShown(Math.min(this.getRecipeShown() + 1, this.getRecipeCount() - 1));
            this.recipeWidget.deserializeNBT((NBTTagCompound)loadingFunction.apply(this.getRecipeShown()));
        }).setButtonTexture(GTFOGuiTextures.BUTTON_RIGHT).setShouldClientCallback(true);
        this.addWidget((Widget)this.rightArrowWidget);
        this.recipeCountLabel = new SimpleTextWidget(x + width / 2, y + 120, "", 0x666666, () -> "Recipe: " + (this.getRecipeShown() + 1) + "/" + this.getRecipeCount(), true);
        this.addWidget((Widget)this.recipeCountLabel);
        this.deleteButtonWidget = new ClickButtonWidget(x + width - 50, y + 120, 9, 9, "", data -> {
            deletingFunction.accept(this.getRecipeShown());
            this.recipeWidget.deserializeNBT((NBTTagCompound)loadingFunction.apply(this.getRecipeShown()));
        }).setButtonTexture(GuiTextures.BUTTON_CLEAR_GRID).setShouldClientCallback(true);
        this.addWidget((Widget)this.deleteButtonWidget);
        this.getNeededInputs();
        this.getNeededFluidInputs();
    }

    public void handleClientAction(int id, PacketBuffer buf) {
        super.handleClientAction(id, buf);
        if (id == 2) {
            try {
                NBTTagCompound tag = buf.func_150793_b();
                this.recipeWidget.deserializeNBT(tag);
                this.savingFunction.accept(tag);
                ++this.recipeCount;
                this.recipeShown = this.recipeCount - 1;
            }
            catch (IOException e) {
                GTFOLog.logger.warn("Failed to read recipe NBT for the kitchen", (Throwable)e);
            }
        }
    }

    protected void getNeededInputs() {
        this.neededInputs.clear();
        for (int i = 0; i < this.recipeCount; ++i) {
            NBTTagCompound recipe = this.loadingFunction.apply(i);
            NBTTagCompound inputs = recipe.func_74775_l("inputs");
            for (int item = 0; item < inputs.func_74762_e("size"); ++item) {
                ItemStack stack = new ItemStack(inputs.func_74775_l("item" + item));
                stack.func_190920_e(1);
                this.neededInputs.add(stack);
            }
        }
        this.neededInputs.add(this.finalResult.getStackInSlot(0));
    }

    protected void getNeededFluidInputs() {
        this.neededFluidInputs.clear();
        for (int i = 0; i < this.recipeCount; ++i) {
            NBTTagCompound recipe = this.loadingFunction.apply(i);
            NBTTagCompound fluidInputs = recipe.func_74775_l("fluidInputs");
            for (int item = 0; item < fluidInputs.func_74762_e("size"); ++item) {
                FluidStack stack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)fluidInputs.func_74775_l("fluid" + item));
                this.neededFluidInputs.add(stack);
            }
        }
    }

    public int getRecipeCount() {
        return this.recipeCount;
    }

    public int getRecipeShown() {
        return this.recipeShown;
    }

    public void setRecipeShown(int recipeShown) {
        this.recipeShown = recipeShown;
    }

    public String transferRecipe(ModularUIContainer modularUIContainer, IRecipeLayout recipeLayout, EntityPlayer entityPlayer, boolean maxTransfer, boolean doTransfer) {
        List fluidOutputs;
        IRecipeWrapper recipeWrapper;
        this.getNeededInputs();
        this.getNeededFluidInputs();
        if (recipeLayout instanceof RecipeLayout) {
            recipeWrapper = (IRecipeWrapper)ObfuscationReflectionHelper.getPrivateValue(RecipeLayout.class, (Object)((RecipeLayout)recipeLayout), (String)"recipeWrapper");
            if (!(recipeWrapper instanceof GTRecipeWrapper)) {
                return "This only works on GTCEu singleblock recipes!";
            }
        } else {
            return "Uh I don't know how you got here, but apparently you're not looking at a recipe?!";
        }
        Recipe recipe = ((GTRecipeWrapper)recipeWrapper).getRecipe();
        String uidString = recipeLayout.getRecipeCategory().getUid();
        String map = GTRecipeCategory.getByName((String)uidString.substring(uidString.indexOf(":") + 1)).getRecipeMap().getUnlocalizedName();
        NonNullList outputs = recipe.getOutputs();
        boolean isGTFO = false;
        boolean isUseful = false;
        if (outputs.stream().anyMatch(this::isAcceptableItem)) {
            isGTFO = true;
        }
        if (outputs.parallelStream().anyMatch(itemStack -> this.neededInputs.stream().anyMatch(arg_0 -> ((ItemStack)itemStack).func_77969_a(arg_0)))) {
            isUseful = true;
        }
        if ((fluidOutputs = recipe.getFluidOutputs()).stream().anyMatch(this::isAcceptableFluid)) {
            isGTFO = true;
        }
        if (fluidOutputs.parallelStream().anyMatch(fluidStack -> this.neededFluidInputs.stream().anyMatch(fluidStack1 -> fluidStack1.isFluidEqual(fluidStack)))) {
            isUseful = true;
        }
        if (!isGTFO) {
            return "Kitchens only process food-related recipes!";
        }
        if (!isUseful) {
            return "This doesn't output anything used in the target item or another recipe!";
        }
        if (!doTransfer) {
            return null;
        }
        ArrayList<ItemStackInfo> inputs = new ArrayList<ItemStackInfo>();
        for (int i = 0; i < recipe.getInputs().size(); ++i) {
            inputs.add(new ItemStackInfo((ItemStack)((IGuiIngredient)recipeLayout.getItemStacks().getGuiIngredients().get(i)).getDisplayedIngredient(), ((GTRecipeInput)recipe.getInputs().get(i)).isNonConsumable()));
        }
        ArrayList<FluidStackInfo> fluidInputs = new ArrayList<FluidStackInfo>();
        for (int i = 0; i < recipe.getFluidInputs().size(); ++i) {
            fluidInputs.add(new FluidStackInfo((FluidStack)((IGuiIngredient)recipeLayout.getFluidStacks().getGuiIngredients().get(i)).getDisplayedIngredient(), ((GTRecipeInput)recipe.getFluidInputs().get(i)).isNonConsumable()));
        }
        NBTTagCompound tag = new NBTTagCompound();
        NBTTagCompound inputTag = new NBTTagCompound();
        inputTag.func_74768_a("size", inputs.size());
        for (int i = 0; i < inputs.size(); ++i) {
            NBTTagCompound nbt = new NBTTagCompound();
            ((ItemStackInfo)inputs.get((int)i)).itemStack.func_77955_b(nbt);
            inputTag.func_74782_a("item" + i, (NBTBase)nbt);
            inputTag.func_74757_a("nonConsumable" + i, ((ItemStackInfo)inputs.get((int)i)).nonConsumable);
        }
        NBTTagCompound fluidInputTag = new NBTTagCompound();
        fluidInputTag.func_74768_a("size", fluidInputs.size());
        for (int i = 0; i < fluidInputs.size(); ++i) {
            NBTTagCompound nbt = new NBTTagCompound();
            ((FluidStackInfo)fluidInputs.get((int)i)).fluidStack.writeToNBT(nbt);
            fluidInputTag.func_74782_a("fluid" + i, (NBTBase)nbt);
            fluidInputTag.func_74757_a("nonConsumable" + i, ((FluidStackInfo)fluidInputs.get((int)i)).nonConsumable);
        }
        NBTTagCompound outputsTag = new NBTTagCompound();
        outputsTag.func_74768_a("size", outputs.size());
        for (int i = 0; i < outputs.size(); ++i) {
            NBTTagCompound nbt = new NBTTagCompound();
            ((ItemStack)outputs.get(i)).func_77955_b(nbt);
            outputsTag.func_74782_a("item" + i, (NBTBase)nbt);
        }
        NBTTagCompound fluidOutputsTag = new NBTTagCompound();
        fluidOutputsTag.func_74768_a("size", fluidOutputs.size());
        for (int i = 0; i < fluidOutputs.size(); ++i) {
            NBTTagCompound nbt = new NBTTagCompound();
            ((FluidStack)fluidOutputs.get(i)).writeToNBT(nbt);
            fluidOutputsTag.func_74782_a("fluid" + i, (NBTBase)nbt);
        }
        tag.func_74782_a("inputs", (NBTBase)inputTag);
        tag.func_74782_a("fluidInputs", (NBTBase)fluidInputTag);
        tag.func_74782_a("outputs", (NBTBase)outputsTag);
        tag.func_74782_a("fluidOutputs", (NBTBase)fluidOutputsTag);
        tag.func_74768_a("EUt", recipe.getEUt());
        tag.func_74778_a("map", map);
        this.recipeWidget.deserializeNBT(tag);
        this.savingFunction.accept(tag);
        ++this.recipeCount;
        this.recipeShown = this.recipeCount - 1;
        this.writeClientAction(2, buf -> buf.func_150786_a(tag));
        return null;
    }

    private boolean isAcceptableItem(ItemStack stack) {
        return stack.func_77973_b() instanceof GTFOMetaItem && !((GTFOMetaItem.GTFOMetaValueItem)((GTFOMetaItem)stack.func_77973_b()).getItem(stack)).isKitchenBlacklisted() || stack.func_77973_b().equals((Object)GTFOMetaItems.SHAPED_ITEM) && GTFOMetaItems.SHAPED_ITEM.isFoodRelated(stack) || stack.func_77973_b() instanceof ItemFood || stack.func_77973_b() instanceof MetaItem && ((MetaItem)stack.func_77973_b()).getItem(stack).getUseManager() instanceof FoodUseManager || Loader.isModLoaded((String)"applecore") && GTFOAppleCoreCompat.isAppleCoreEdible(stack);
    }

    private boolean isAcceptableFluid(FluidStack stack) {
        Fluid fluid = stack.getFluid();
        if (fluid instanceof GTFluid.GTMaterialFluid) {
            return GTFOMaterialHandler.isFoodRelated(((GTFluid.GTMaterialFluid)fluid).getMaterial());
        }
        return false;
    }
}

