/*
 * Decompiled with CFR 0.152.
 */
package gregtechfoodoption.client.particle;

import codechicken.lib.vec.Vector3;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.client.particle.GTLaserBeamParticle;
import gregtech.client.utils.EffectRenderContext;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.util.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class GTFOFarmingLaserBeamParticle
extends GTLaserBeamParticle {
    private int particleAge = 0;
    private final int particleMaxAge;

    public GTFOFarmingLaserBeamParticle(MetaTileEntity mte, Vector3 startPos, Vector3 endPos, int maxAge) {
        super(mte, startPos, endPos);
        this.particleMaxAge = maxAge;
        this.setBody(new ResourceLocation("gregtech", "textures/fx/laser/laser.png"));
        this.setHead(new ResourceLocation("gregtech", "textures/fx/laser/laser_start.png"));
        this.setEmit(1.0f);
    }

    public float getAlpha() {
        return (float)this.particleAge / (float)this.particleMaxAge;
    }

    public void onUpdate() {
        super.onUpdate();
        if (this.particleAge != this.particleMaxAge) {
            this.setAlpha(1.0f - (float)this.particleAge / (float)this.particleMaxAge);
            ++this.particleAge;
        } else {
            this.setExpired();
        }
    }

    public void renderParticle(@NotNull BufferBuilder buffer, @NotNull EffectRenderContext context) {
        this.setAlpha(1.0f - (float)this.particleAge / (float)this.particleMaxAge);
        super.renderParticle(buffer, context);
    }
}

