/*
 * Decompiled with CFR 0.152.
 */
package gregtechfoodoption.block.tree;

import gregtechfoodoption.GTFOValues;
import gregtechfoodoption.block.GTFOMetaBlocks;
import gregtechfoodoption.block.IVariantNamed;
import gregtechfoodoption.worldgen.trees.GTFOTree;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.BlockSapling;
import net.minecraft.block.IGrowable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;

public class GTFOBlockSapling
extends BlockBush
implements IGrowable,
IVariantNamed {
    protected static final AxisAlignedBB SAPLING_AABB = new AxisAlignedBB(0.1, 0.0, 0.1, 0.9, 0.8, 0.9);
    public static final PropertyInteger VARIANT = PropertyInteger.func_177719_a((String)"variant", (int)0, (int)7);
    public final int offset;

    public GTFOBlockSapling(int offset) {
        super(Material.field_151584_j);
        this.offset = offset;
        this.func_149663_c("gtfo_sapling_" + offset);
        this.func_149675_a(true);
        this.func_149711_c(0.0f);
        this.func_149713_g(1);
        this.func_149672_a(SoundType.field_185850_c);
        GTFOMetaBlocks.GTFO_SAPLINGS.add(this);
        this.func_149647_a((CreativeTabs)GTFOValues.TAB_GTFO);
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{BlockSapling.field_176479_b, VARIANT});
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)BlockSapling.field_176479_b, (Comparable)Integer.valueOf(meta & 1)).func_177226_a((IProperty)VARIANT, (Comparable)Integer.valueOf((meta & 0xE) >> 1));
    }

    public int func_176201_c(IBlockState state) {
        int i = 0;
        i |= ((Integer)state.func_177229_b((IProperty)BlockSapling.field_176479_b)).intValue();
        return i |= (Integer)state.func_177229_b((IProperty)VARIANT) << 1;
    }

    @Override
    public String getVariantTranslationKey(IBlockState state) {
        try {
            return "gregtechfoodoption.sapling." + this.getTreeFromState((IBlockState)state).name;
        }
        catch (IndexOutOfBoundsException e) {
            return "gregtechfoodoption.hello_buildcraft";
        }
    }

    public GTFOTree getTreeFromState(IBlockState state) {
        return GTFOTree.TREES.get((Integer)state.func_177229_b((IProperty)VARIANT) + this.offset * 8);
    }

    @Nonnull
    public AxisAlignedBB func_185496_a(@Nonnull IBlockState state, @Nonnull IBlockAccess source, @Nonnull BlockPos pos) {
        return SAPLING_AABB;
    }

    public boolean func_176473_a(@Nonnull World world, @Nonnull BlockPos blockPos, @Nonnull IBlockState iBlockState, boolean b) {
        return true;
    }

    public boolean func_180670_a(@Nonnull World world, @Nonnull Random random, @Nonnull BlockPos blockPos, @Nonnull IBlockState iBlockState) {
        return true;
    }

    public boolean canBeReplacedByLeaves(@Nonnull IBlockState state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos) {
        return true;
    }

    public void func_176474_b(@Nonnull World worldIn, @Nonnull Random rand, @Nonnull BlockPos pos, @Nonnull IBlockState state) {
        this.getTreeFromState(state).getTreeGrowInstance().func_180709_b(worldIn, rand, pos);
    }

    @Nonnull
    public EnumPlantType getPlantType(@Nonnull IBlockAccess world, @Nonnull BlockPos pos) {
        return EnumPlantType.Plains;
    }

    public void func_149666_a(CreativeTabs itemIn, NonNullList<ItemStack> items) {
        for (int i = 0; i < 8 && GTFOTree.TREES.size() > i + this.offset * 8; ++i) {
            items.add((Object)new ItemStack((Block)this, 1, i * 2));
        }
    }

    public int func_180651_a(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)VARIANT) << 1;
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if (!worldIn.field_72995_K) {
            super.func_180650_b(worldIn, pos, state, rand);
            if (rand.nextInt(7) != 0) {
                return;
            }
            if (!worldIn.func_175697_a(pos, 1)) {
                return;
            }
            if (worldIn.func_175671_l(pos.func_177984_a()) >= 9) {
                this.func_176474_b(worldIn, rand, pos, state);
            }
        }
    }
}

