/*
 * Decompiled with CFR 0.152.
 */
package gregtechfoodoption.block;

import gregtechfoodoption.block.GTFOCrop;
import gregtechfoodoption.utils.GTFOLog;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import org.jetbrains.annotations.Nullable;

public class GTFOBerryBush
extends GTFOCrop {
    public static final PropertyInteger EFFICIENCY_GTFO = PropertyInteger.func_177719_a((String)"efficiency", (int)0, (int)4);
    private static final AxisAlignedBB SMALL_AABB = new AxisAlignedBB(0.25, 0.0, 0.25, 0.75, 0.5, 0.75);
    private static final AxisAlignedBB LARGE_AABB = new AxisAlignedBB(0.0625, 0.0, 0.0625, 0.9375, 0.9375, 0.9375);
    private static final AxisAlignedBB STEM_AABB = new AxisAlignedBB(0.4325, 0.0, 0.4325, 0.5675, 0.25, 0.5675);
    protected static final PropertyInteger DEFAULT_AGE_BUSH = PropertyInteger.func_177719_a((String)"age", (int)0, (int)2);
    private boolean isThorny = false;

    protected GTFOBerryBush(String name) {
        super(name);
        this.func_149663_c("gtfo_berry_bush_" + name);
        this.func_149711_c(1.0f);
    }

    protected boolean func_185514_i(IBlockState state) {
        return state.func_177230_c() == Blocks.field_150346_d || super.func_185514_i(state);
    }

    public static GTFOBerryBush create(String name) {
        return new GTFOBerryBush(name);
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{this.func_185524_e(), EFFICIENCY_GTFO});
    }

    @Override
    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        Random rand;
        int age = this.func_185527_x(state);
        int efficiency = this.getEfficiency(state);
        Random random = rand = world instanceof World ? ((World)world).field_73012_v : new Random();
        if (age >= this.func_185526_g()) {
            int cropCount = 1;
            for (int i = 0; i < 2 + efficiency; ++i) {
                if (rand.nextInt(2) != 0) continue;
                ++cropCount;
            }
            ItemStack crop = this.crop.func_77946_l();
            crop.func_190920_e(cropCount);
            drops.add((Object)crop);
        }
    }

    public int getEfficiency(IBlockState state) {
        return state.func_177228_b().get((Object)EFFICIENCY_GTFO) != null ? (Integer)state.func_177229_b((IProperty)EFFICIENCY_GTFO) : -1;
    }

    public void func_176487_g(World worldIn, BlockPos pos, IBlockState state) {
        int j;
        if (worldIn.field_73012_v.nextInt(Math.max(2, this.getGrowthSlowdown(worldIn, pos, state) / 8)) != 0) {
            return;
        }
        int i = this.func_185527_x(state) + this.func_185529_b(worldIn);
        if (i > (j = this.func_185526_g())) {
            i = j;
        }
        worldIn.func_180501_a(pos, this.withEfficiency(this.func_185528_e(i), this.calcEfficiency(worldIn, pos)), 3);
    }

    public int calcEfficiency(World worldIn, BlockPos pos) {
        int[] efficiencies = new int[(Integer)EFFICIENCY_GTFO.func_177700_c().stream().max(Integer::compare).get() + 1];
        BlockPos.func_177980_a((BlockPos)pos.func_177974_f().func_177978_c(), (BlockPos)pos.func_177976_e().func_177968_d()).forEach(blockpos -> {
            if (!blockpos.equals((Object)pos) && this.getEfficiency(worldIn.func_180495_p(blockpos)) + 1 < efficiencies.length) {
                int n = this.getEfficiency(worldIn.func_180495_p(blockpos)) + 1;
                efficiencies[n] = efficiencies[n] + 1;
            }
        });
        for (int i = efficiencies.length - 1; i >= 0; --i) {
            if (efficiencies[i] <= 2) continue;
            return i;
        }
        return 0;
    }

    protected int func_185529_b(World worldIn) {
        return 1;
    }

    public IBlockState withEfficiency(IBlockState state, int efficiency) {
        if (efficiency > 4) {
            efficiency = 4;
            GTFOLog.logger.warn("Somehow, you managed to get your berry's efficiency higher than 4, which is really cool (or the result of a hacked mod/bug), but it's currently not available in GTFO. Please report this to the mod author, along with a screenshot of how great your berry setup is.");
        }
        return state.func_177226_a((IProperty)EFFICIENCY_GTFO, (Comparable)Integer.valueOf(efficiency));
    }

    public int getGrowthSlowdown(World world, BlockPos pos, IBlockState state) {
        if (this.func_185527_x(state) == 0) {
            return 4;
        }
        int growthSlowdown = 320 << this.getEfficiency(state);
        if (!world.func_72935_r()) {
            growthSlowdown *= 2;
        }
        if (world.func_72896_J()) {
            growthSlowdown = growthSlowdown * 2 / 3;
        }
        return growthSlowdown;
    }

    @Override
    public EnumPlantType getPlantType(IBlockAccess world, BlockPos pos) {
        return EnumPlantType.Plains;
    }

    public void func_180634_a(World worldIn, BlockPos pos, IBlockState state, Entity entityIn) {
        if (this.isThorny && entityIn instanceof EntityLiving) {
            entityIn.func_70097_a(DamageSource.field_76367_g, 1.0f);
        }
        double distanceFromCenter = entityIn.func_70092_e((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5);
        distanceFromCenter += 0.5;
        entityIn.field_70138_W = 0.125f;
        entityIn.field_70159_w *= (distanceFromCenter /= 4.0);
        entityIn.field_70181_x *= distanceFromCenter;
        entityIn.field_70179_y *= distanceFromCenter;
    }

    public GTFOBerryBush setThorny(boolean thorny) {
        this.isThorny = thorny;
        return this;
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return STEM_AABB;
    }

    @Override
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return this.func_185527_x(state) == 0 ? SMALL_AABB : LARGE_AABB;
    }

    @Override
    public int func_185526_g() {
        return 2;
    }

    @Override
    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (this.func_185525_y(state)) {
            int berries = 1;
            for (int i = 0; i < 2 + this.getEfficiency(state); ++i) {
                if (worldIn.field_73012_v.nextInt(2) != 0) continue;
                ++berries;
            }
            ItemStack berryStack = this.getCropStack().func_77946_l();
            berryStack.func_190920_e(berries);
            if (!playerIn.func_191521_c(berryStack)) {
                playerIn.func_71019_a(this.getCropStack(), false);
            }
            worldIn.func_180501_a(pos, state.func_177226_a((IProperty)this.func_185524_e(), (Comparable)Integer.valueOf(this.func_185526_g() - 1)), 3);
            return true;
        }
        return false;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_185528_e(meta % 3).func_177226_a((IProperty)EFFICIENCY_GTFO, (Comparable)Integer.valueOf(meta / 3));
    }

    public int func_176201_c(IBlockState state) {
        return this.getEfficiency(state) * 3 + this.func_185527_x(state);
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (!(worldIn.func_180495_p(fromPos).func_177230_c() instanceof GTFOBerryBush)) {
            int newEfficiency = Math.min(this.calcEfficiency(worldIn, pos), this.getEfficiency(state));
            worldIn.func_180501_a(pos, state.func_177226_a((IProperty)EFFICIENCY_GTFO, (Comparable)Integer.valueOf(newEfficiency)), 3);
        }
        super.func_189540_a(state, worldIn, pos, blockIn, fromPos);
    }

    @Override
    public PropertyInteger func_185524_e() {
        return DEFAULT_AGE_BUSH;
    }
}

