/*
 * Decompiled with CFR 0.152.
 */
package gregtechfoodoption;

import gregtech.api.GTValues;
import gregtech.api.GregTechAPI;
import gregtech.api.items.metaitem.MetaItem;
import gregtech.api.network.IPacket;
import gregtech.api.unification.material.event.MaterialEvent;
import gregtech.api.util.GregFakePlayer;
import gregtechfoodoption.GTFOConfig;
import gregtechfoodoption.GTFOMaterialHandler;
import gregtechfoodoption.GTFOValues;
import gregtechfoodoption.block.GTFOBerryBush;
import gregtechfoodoption.entity.EntityStrongSnowman;
import gregtechfoodoption.integration.GTFOGAMaterialHandler;
import gregtechfoodoption.integration.applecore.GTFOAppleCoreCompat;
import gregtechfoodoption.item.food.GTFOFoodDurationSetter;
import gregtechfoodoption.network.PacketAppleCoreFoodDivisorUpdate;
import gregtechfoodoption.potion.AntiSchizoPotion;
import gregtechfoodoption.potion.CreativityPotion;
import gregtechfoodoption.potion.CyanidePoisoningPotion;
import gregtechfoodoption.potion.PotionAmplifierPotion;
import gregtechfoodoption.potion.PotionLengthenerPotion;
import gregtechfoodoption.potion.SnowGolemSpawnerPotion;
import gregtechfoodoption.potion.StepAssistPotion;
import gregtechfoodoption.utils.GTFODamageSources;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.WorldServer;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.PotionColorCalculationEvent;
import net.minecraftforge.event.entity.living.PotionEvent;
import net.minecraftforge.event.entity.player.AdvancementEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Mod.EventBusSubscriber(modid="gregtechfoodoption")
public class GTFOEventHandler {
    protected static Random rand = new Random();
    private static final HashMap<EntityLivingBase, Integer> snowGolemSpawnSpeeds = new HashMap();
    private static final Set<EntityLivingBase> jumpBoostSet = new HashSet<EntityLivingBase>();

    @SubscribeEvent
    public static void onMaterialsInit(MaterialEvent event) {
        GTFOMaterialHandler gtfoMaterials = new GTFOMaterialHandler();
        GTFOMaterialHandler.onMaterialsInit();
        if (Loader.isModLoaded((String)"gcys")) {
            GTFOGAMaterialHandler gtfogaMaterials = new GTFOGAMaterialHandler();
            GTFOGAMaterialHandler.onMaterialsInit();
        }
    }

    @SubscribeEvent
    public static void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        if (event.getEntityLiving() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)event.getEntityLiving();
            NBTTagCompound persisted = player.getEntityData().func_74775_l("PlayerPersisted");
            if (!player.getEntityData().func_74764_b("PlayerPersisted")) {
                player.getEntityData().func_74782_a("PlayerPersisted", (NBTBase)persisted);
            }
            if (GTFOConfig.gtfoPotionConfig.creativity) {
                if (CreativityPotion.INSTANCE != null && player.func_70644_a((Potion)CreativityPotion.INSTANCE)) {
                    if (!persisted.func_74767_n("gregtechfoodoption - creativity")) {
                        persisted.func_74757_a("gregtechfoodoption - creativity", true);
                    }
                    player.field_71075_bZ.field_75101_c = true;
                } else if (persisted.func_74767_n("gregtechfoodoption - creativity")) {
                    persisted.func_74757_a("gregtechfoodoption - creativity", false);
                    player.field_70143_R = 0.0f;
                    if (!player.field_71075_bZ.field_75098_d) {
                        player.field_71075_bZ.field_75100_b = false;
                        player.field_71075_bZ.field_75101_c = false;
                    }
                }
            }
            if (GTFOConfig.gtfoPotionConfig.stepAssist) {
                if (StepAssistPotion.INSTANCE != null && player.func_70644_a((Potion)StepAssistPotion.INSTANCE)) {
                    if (!persisted.func_74767_n("gregtechfoodoption - stepassist")) {
                        persisted.func_74757_a("gregtechfoodoption - stepassist", true);
                    }
                } else if (persisted.func_74767_n("gregtechfoodoption - stepassist")) {
                    persisted.func_74757_a("gregtechfoodoption - stepassist", false);
                    player.field_70138_W = 0.6f;
                }
            }
            if (GTFOConfig.gtfoPotionConfig.snowGolemSpawner) {
                if (SnowGolemSpawnerPotion.INSTANCE != null && player.func_70644_a((Potion)SnowGolemSpawnerPotion.INSTANCE)) {
                    if (!persisted.func_74767_n("gregtechfoodoption - snowgolemspawnerpotion")) {
                        persisted.func_74757_a("gregtechfoodoption - snowgolemspawnerpotion", true);
                    } else if (!player.field_70170_p.field_72995_K && GTFOValues.rand.nextInt(100 / (player.func_70660_b((Potion)SnowGolemSpawnerPotion.INSTANCE).func_76458_c() + 1)) == 0) {
                        float angle = (float)((double)GTFOValues.rand.nextFloat() * Math.PI);
                        RayTraceResult result = player.field_70170_p.func_147447_a(player.func_174791_d(), new Vec3d(1.0, -0.3, 0.0).func_178785_b(angle), false, false, true);
                        EntityStrongSnowman spawn = new EntityStrongSnowman(player.field_70170_p);
                        spawn.func_70012_b(result.func_178782_a().func_177958_n(), result.func_178782_a().func_177956_o() + 1, result.func_178782_a().func_177952_p(), player.field_70759_as, player.field_70125_A);
                        player.field_70170_p.func_72838_d((Entity)spawn);
                        spawn.func_70690_d(new PotionEffect(Potion.func_188412_a((int)5), 1000, 4));
                    }
                } else if (persisted.func_74767_n("gregtechfoodoption - snowgolemspawnerpotion")) {
                    persisted.func_74757_a("gregtechfoodoption - snowgolemspawnerpotion", false);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onLivingUpdate(LivingEntityUseItemEvent.Start event) {
        if (event.getItem().func_77973_b() instanceof ItemFood || event.getItem().func_77973_b() instanceof MetaItem) {
            event.setDuration(GTFOFoodDurationSetter.duration(event.getItem()));
        }
    }

    @SubscribeEvent
    public static void onLivingUpdate(LivingEntityUseItemEvent.Tick event) {
        if (event.getItem().func_77973_b() instanceof ItemFood || event.getItem().func_77973_b() instanceof MetaItem) {
            EntityLivingBase livingBase = event.getEntityLiving();
            ItemStack stack = event.getItem();
            if (livingBase.func_184605_cv() <= GTFOFoodDurationSetter.duration(stack) - 7 && livingBase.func_184605_cv() % 4 == 0) {
                if (stack.func_77975_n() == EnumAction.EAT) {
                    for (int i = 0; i < 5; ++i) {
                        Vec3d vec3d = new Vec3d(((double)rand.nextFloat() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, 0.0);
                        vec3d = vec3d.func_178789_a(-livingBase.field_70125_A * ((float)Math.PI / 180));
                        vec3d = vec3d.func_178785_b(-livingBase.field_70177_z * ((float)Math.PI / 180));
                        double d0 = (double)rand.nextFloat() * 0.6 - 0.3;
                        Vec3d vec3d1 = new Vec3d(((double)rand.nextFloat() - 0.5) * 0.3, d0, 0.6);
                        vec3d1 = vec3d1.func_178789_a(-livingBase.field_70125_A * ((float)Math.PI / 180));
                        vec3d1 = vec3d1.func_178785_b(-livingBase.field_70177_z * ((float)Math.PI / 180));
                        vec3d1 = vec3d1.func_72441_c(livingBase.field_70165_t, livingBase.field_70163_u + (double)livingBase.func_70047_e(), livingBase.field_70161_v);
                        if (stack.func_77981_g()) {
                            livingBase.field_70170_p.func_175688_a(EnumParticleTypes.ITEM_CRACK, vec3d1.field_72450_a, vec3d1.field_72448_b, vec3d1.field_72449_c, vec3d.field_72450_a, vec3d.field_72448_b + 0.05, vec3d.field_72449_c, new int[]{Item.func_150891_b((Item)stack.func_77973_b()), stack.func_77960_j()});
                            continue;
                        }
                        livingBase.field_70170_p.func_175688_a(EnumParticleTypes.ITEM_CRACK, vec3d1.field_72450_a, vec3d1.field_72448_b, vec3d1.field_72449_c, vec3d.field_72450_a, vec3d.field_72448_b + 0.05, vec3d.field_72449_c, new int[]{Item.func_150891_b((Item)stack.func_77973_b())});
                    }
                    livingBase.func_184185_a(SoundEvents.field_187537_bA, 0.5f + 0.5f * (float)rand.nextInt(2), (rand.nextFloat() - rand.nextFloat()) * 0.2f + 1.0f);
                } else if (stack.func_77975_n() == EnumAction.DRINK) {
                    livingBase.func_184185_a(SoundEvents.field_187664_bz, 0.5f, livingBase.field_70170_p.field_73012_v.nextFloat() * 0.1f + 0.9f);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onAdvancement(AdvancementEvent event) {
        float divisorObtained;
        if (GTFOConfig.gtfoOtherFoodModConfig.reduceForeignFoodStats && (divisorObtained = GTFOAppleCoreCompat.getDivisorOnAdvancement(event.getAdvancement())) > 1.0f && GTFOAppleCoreCompat.advancementLookup(event.getEntityPlayer()) == divisorObtained) {
            GregTechAPI.networkHandler.sendToAll((IPacket)new PacketAppleCoreFoodDivisorUpdate(event.getEntityPlayer().func_110124_au(), divisorObtained));
            event.getEntityPlayer().func_145747_a((ITextComponent)new TextComponentTranslation("gregtechfoodoption.chat.food_buff", new Object[0]));
        }
    }

    @SubscribeEvent
    public static void onPlayerLoginEvent(PlayerEvent.PlayerLoggedInEvent event) {
        if (!event.player.func_130014_f_().field_72995_K && Loader.isModLoaded((String)"applecore")) {
            GregTechAPI.networkHandler.sendToAll((IPacket)new PacketAppleCoreFoodDivisorUpdate(event.player.func_110124_au(), GTFOAppleCoreCompat.advancementLookup(event.player)));
        }
    }

    @SubscribeEvent
    public static void onWorldLoadEvent(WorldEvent.Load event) {
        if (!event.getWorld().field_72995_K) {
            GTFODamageSources.EXTERMINATOR = GregFakePlayer.get((WorldServer)((WorldServer)event.getWorld()));
        }
    }

    @SubscribeEvent
    public static void getPotionParticleColor(PotionColorCalculationEvent event) {
        if (event.getEffects().stream().anyMatch(effect -> effect.func_188419_a() instanceof CyanidePoisoningPotion)) {
            event.shouldHideParticles(true);
        }
    }

    @SubscribeEvent
    public static void onDrinkPotion(PotionEvent.PotionAddedEvent event) {
        Potion type;
        if (PotionAmplifierPotion.INSTANCE != null && event.getEntityLiving().func_70644_a((Potion)PotionAmplifierPotion.INSTANCE) && !event.getPotionEffect().func_188419_a().equals((Object)PotionAmplifierPotion.INSTANCE)) {
            int amplificationBonus = event.getEntityLiving().func_70660_b((Potion)PotionAmplifierPotion.INSTANCE).func_76458_c() + 1;
            type = event.getPotionEffect().func_188419_a();
            int newAmplifier = event.getPotionEffect().func_76458_c() + amplificationBonus;
            event.getPotionEffect().func_76452_a(new PotionEffect(type, 0, newAmplifier));
        }
        if (PotionLengthenerPotion.INSTANCE != null && event.getEntityLiving().func_70644_a((Potion)PotionLengthenerPotion.INSTANCE) && !event.getPotionEffect().func_188419_a().equals((Object)PotionLengthenerPotion.INSTANCE)) {
            int durationBonus = event.getEntityLiving().func_70660_b((Potion)PotionLengthenerPotion.INSTANCE).func_76458_c();
            type = event.getPotionEffect().func_188419_a();
            int newDuration = (int)((double)event.getPotionEffect().func_76458_c() * ((double)durationBonus * 0.5 + 1.5));
            event.getPotionEffect().func_76452_a(new PotionEffect(type, newDuration));
        }
    }

    @SubscribeEvent
    public static void handleBerryGrowth(BlockEvent.CropGrowEvent.Post event) {
        Block block = event.getState().func_177230_c();
        if (block instanceof GTFOBerryBush) {
            GTFOBerryBush bush = (GTFOBerryBush)block;
            event.getWorld().func_180501_a(event.getPos(), bush.withEfficiency(event.getState(), bush.calcEfficiency(event.getWorld(), event.getPos())), 2);
        }
    }

    @SubscribeEvent
    public static void handleBerryGrowth(BlockEvent.CropGrowEvent.Pre event) {
        Block block = event.getState().func_177230_c();
        if (block instanceof GTFOBerryBush) {
            GTFOBerryBush bush = (GTFOBerryBush)block;
            event.setResult(GTValues.RNG.nextInt(bush.getGrowthSlowdown(event.getWorld(), event.getPos(), event.getState())) == 0 ? Event.Result.ALLOW : Event.Result.DENY);
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public static void handlePlayerRender(RenderPlayerEvent.Pre event) {
        EntityPlayer player = event.getEntityPlayer();
        if (!player.func_175144_cb() && Minecraft.func_71410_x().field_71439_g.func_70644_a((Potion)AntiSchizoPotion.INSTANCE)) {
            event.setCanceled(true);
            Minecraft.func_71410_x().func_175598_ae().func_178633_a(false);
        }
    }
}

