/*
 * Decompiled with CFR 0.152.
 */
package gregtechfoodoption;

import crazypants.enderio.api.farm.IFarmerJoe;
import crazypants.enderio.base.farming.farmers.CustomSeedFarmer;
import gregtech.api.block.VariantItemBlock;
import gregtech.api.recipes.RecipeMaps;
import gregtech.api.unification.OreDictUnifier;
import gregtech.api.unification.material.Material;
import gregtech.api.unification.material.Materials;
import gregtech.api.unification.ore.OrePrefix;
import gregtechfoodoption.GTFOConfig;
import gregtechfoodoption.GTFOMaterialHandler;
import gregtechfoodoption.block.GTFOBerryBush;
import gregtechfoodoption.block.GTFOCrop;
import gregtechfoodoption.block.GTFOMetaBlocks;
import gregtechfoodoption.block.GTFORootCrop;
import gregtechfoodoption.integration.enderio.GTFOBerryFarmer;
import gregtechfoodoption.integration.enderio.GTFORootCropFarmer;
import gregtechfoodoption.integration.nutrition.GTFONutritionCompatibility;
import gregtechfoodoption.item.GTFOMetaItem;
import gregtechfoodoption.item.GTFOMetaItems;
import gregtechfoodoption.item.GTFOSpecialVariantItemBlock;
import gregtechfoodoption.machines.multiblock.MetaTileEntityGreenhouse;
import gregtechfoodoption.potion.AntiSchizoPotion;
import gregtechfoodoption.potion.CyanidePoisoningPotion;
import gregtechfoodoption.potion.GTFOPotions;
import gregtechfoodoption.potion.LacingEntry;
import gregtechfoodoption.potion.LungCancerPotion;
import gregtechfoodoption.recipe.GTFOOreDictRegistration;
import gregtechfoodoption.recipe.GTFORecipeAddition;
import gregtechfoodoption.recipe.GTFORecipeHandler;
import gregtechfoodoption.recipe.GTFORecipeRemoval;
import gregtechfoodoption.utils.GTFOLog;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="gregtechfoodoption")
public class CommonProxy {
    public void preLoad() {
        GTFOPotions.initPotionInstances();
        GTFOMetaItems.init();
        GTFORecipeHandler.register();
        RecipeMaps.BREWING_RECIPES.setMaxOutputs(1);
        RecipeMaps.EXTRACTOR_RECIPES.setMaxInputs(2);
        RecipeMaps.FERMENTING_RECIPES.setMaxInputs(1);
        RecipeMaps.FERMENTING_RECIPES.setMaxOutputs(1);
        RecipeMaps.COMPRESSOR_RECIPES.setMaxFluidInputs(1);
        RecipeMaps.COMPRESSOR_RECIPES.setMaxFluidOutputs(1);
    }

    public void onLoad() {
    }

    public void onPostLoad() {
        MinecraftForge.addGrassSeed((ItemStack)GTFOMetaItem.UNKNOWN_SEED.getStackForm(), (int)5);
        LacingEntry.LACING_REGISTRY.func_177775_a(0, (Object)"cyanide", (Object)new LacingEntry(GTFOMaterialHandler.SodiumCyanide.getItemStack(), new PotionEffect((Potion)CyanidePoisoningPotion.INSTANCE, 1300, 0), "5dkcap/2/4/"));
        LacingEntry.LACING_REGISTRY.func_177775_a(1, (Object)"antischizo", (Object)new LacingEntry(GTFOMaterialHandler.LithiumCarbonate.getItemStack(), new PotionEffect((Potion)AntiSchizoPotion.INSTANCE, 1000, 0), "14hez98zk7/2/3/5/9/10/"));
        LacingEntry.LACING_REGISTRY.func_177775_a(2, (Object)"lungcancer", (Object)new LacingEntry(OreDictUnifier.get((OrePrefix)OrePrefix.dust, (Material)Materials.Asbestos), new PotionEffect((Potion)LungCancerPotion.INSTANCE, 99999999, 0), "17aaqe0i1q/1/2/3/7/10/"));
        if (Loader.isModLoaded((String)"nutrition_gtceu") && GTFOConfig.gtfoOtherFoodModConfig.enableGTFONutrition) {
            GTFONutritionCompatibility.init();
        }
        GTFOLog.logger.info("Removing recipes during post init (thanks Ender IO!)");
        GTFORecipeRemoval.init();
    }

    @SubscribeEvent
    public static void syncConfigValues(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals("gregtechfoodoption")) {
            ConfigManager.sync((String)"gregtechfoodoption", (Config.Type)Config.Type.INSTANCE);
        }
    }

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        GTFOLog.logger.info("Registering blocks...");
        IForgeRegistry registry = event.getRegistry();
        registry.register((IForgeRegistryEntry)GTFOMetaBlocks.GTFO_CASING);
        registry.register((IForgeRegistryEntry)GTFOMetaBlocks.GTFO_METAL_CASING);
        registry.register((IForgeRegistryEntry)GTFOMetaBlocks.GTFO_GLASS_CASING);
        GTFOCrop.CROP_BLOCKS.forEach(arg_0 -> ((IForgeRegistry)registry).register(arg_0));
        GTFOMetaBlocks.GTFO_LEAVES.forEach(arg_0 -> ((IForgeRegistry)registry).register(arg_0));
        GTFOMetaBlocks.GTFO_LOGS.forEach(arg_0 -> ((IForgeRegistry)registry).register(arg_0));
        GTFOMetaBlocks.GTFO_PLANKS.forEach(arg_0 -> ((IForgeRegistry)registry).register(arg_0));
        GTFOMetaBlocks.GTFO_SAPLINGS.forEach(arg_0 -> ((IForgeRegistry)registry).register(arg_0));
        MetaTileEntityGreenhouse.addGrasses();
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        GTFOLog.logger.info("Registering Items...");
        IForgeRegistry registry = event.getRegistry();
        registry.register((IForgeRegistryEntry)CommonProxy.createItemBlock(GTFOMetaBlocks.GTFO_CASING, VariantItemBlock::new));
        registry.register((IForgeRegistryEntry)CommonProxy.createItemBlock(GTFOMetaBlocks.GTFO_METAL_CASING, VariantItemBlock::new));
        registry.register((IForgeRegistryEntry)CommonProxy.createItemBlock(GTFOMetaBlocks.GTFO_GLASS_CASING, VariantItemBlock::new));
        GTFOMetaBlocks.GTFO_LEAVES.forEach(leaves -> registry.register((IForgeRegistryEntry)CommonProxy.createItemBlock(leaves, GTFOSpecialVariantItemBlock::new)));
        GTFOMetaBlocks.GTFO_LOGS.forEach(log -> registry.register((IForgeRegistryEntry)CommonProxy.createItemBlock(log, GTFOSpecialVariantItemBlock::new)));
        GTFOMetaBlocks.GTFO_SAPLINGS.forEach(sapling -> registry.register((IForgeRegistryEntry)CommonProxy.createItemBlock(sapling, GTFOSpecialVariantItemBlock::new)));
        GTFOMetaBlocks.GTFO_PLANKS.forEach(sapling -> registry.register((IForgeRegistryEntry)CommonProxy.createItemBlock(sapling, GTFOSpecialVariantItemBlock::new)));
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public static void registerRecipes(RegistryEvent.Register<IRecipe> event) {
        GTFOLog.logger.info("Registering recipe normal...");
        GTFORecipeAddition.init();
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void registerLowRecipes(RegistryEvent.Register<IRecipe> event) {
        GTFOLog.logger.info("Registering recipe low...");
        GTFORecipeAddition.lowInit();
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void registerOrePrefix(RegistryEvent.Register<IRecipe> event) {
        GTFOLog.logger.info("Registering ore prefix...");
        GTFOOreDictRegistration.init();
        GTFOMetaBlocks.registerOreDict();
    }

    private static <T extends Block> ItemBlock createItemBlock(T block, Function<T, ItemBlock> producer) {
        ItemBlock itemBlock = producer.apply(block);
        itemBlock.setRegistryName(Objects.requireNonNull(block.getRegistryName()));
        return itemBlock;
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void registerRecipesLowest(RegistryEvent.Register<IRecipe> event) {
        GTFOLog.logger.info("Registering recipe very low...");
        GTFORecipeAddition.compatInit();
    }

    @SubscribeEvent
    @Optional.Method(modid="enderio")
    public static void registerEIOFarmerJoes(@Nonnull RegistryEvent.Register<IFarmerJoe> event) {
        for (GTFOCrop crop : GTFOCrop.CROP_BLOCKS) {
            if (crop instanceof GTFORootCrop) {
                event.getRegistry().register((IForgeRegistryEntry)((IFarmerJoe)new GTFORootCropFarmer((Block)crop, crop.getSeedStack()).setRegistryName(crop.getRegistryName())));
                continue;
            }
            if (crop instanceof GTFOBerryBush) {
                event.getRegistry().register((IForgeRegistryEntry)((IFarmerJoe)new GTFOBerryFarmer((Block)crop, crop.getSeedStack()).setRegistryName(crop.getRegistryName())));
                continue;
            }
            event.getRegistry().register((IForgeRegistryEntry)((IFarmerJoe)new CustomSeedFarmer((Block)crop, crop.getSeedStack()).setRegistryName(crop.getRegistryName())));
        }
    }
}

