/*
 * Decompiled with CFR 0.152.
 */
package gregtechfoodoption;

import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import gregtechfoodoption.CommonProxy;
import gregtechfoodoption.block.GTFOMetaBlocks;
import gregtechfoodoption.entity.GTFOEntities;
import gregtechfoodoption.integration.appleskin.GTFOMetaHUDOverlay;
import gregtechfoodoption.integration.appleskin.GTFOMetaTooltipOverlay;
import gregtechfoodoption.potion.AntiSchizoPotion;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.network.NetworkPlayerInfo;
import net.minecraft.entity.Entity;
import net.minecraft.potion.Potion;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ChatType;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.client.event.ClientChatReceivedEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.event.entity.living.PotionEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
@Mod.EventBusSubscriber(value={Side.CLIENT})
public class ClientProxy
extends CommonProxy {
    private static final ResourceLocation GTFO_CAPE_TEXTURE = new ResourceLocation("gregtechfoodoption", "textures/gtfocape.png");
    private static final Set<UUID> capeHoldersUUIDs = new HashSet<UUID>();

    @Override
    public void preLoad() {
        super.preLoad();
        if (!Minecraft.func_71410_x().func_147110_a().isStencilEnabled()) {
            Minecraft.func_71410_x().func_147110_a().enableStencil();
        }
        GTFOEntities.registerRenders();
    }

    @Override
    public void onLoad() {
        super.onLoad();
        if (Loader.isModLoaded((String)"appleskin")) {
            GTFOMetaTooltipOverlay.init();
            GTFOMetaHUDOverlay.init();
        }
        GTFOMetaBlocks.registerColors();
    }

    @Override
    public void onPostLoad() {
        super.onPostLoad();
        capeHoldersUUIDs.add(UUID.fromString("aaf70ec1-ac70-494f-9966-ea5933712750"));
    }

    @SubscribeEvent
    public static void registerModels(ModelRegistryEvent event) {
        GTFOMetaBlocks.registerItemModels();
    }

    @SubscribeEvent
    public static void onPlayerRender(RenderPlayerEvent.Pre event) {
        AbstractClientPlayer clientPlayer = (AbstractClientPlayer)event.getEntityPlayer();
        if (capeHoldersUUIDs.contains(clientPlayer.func_110124_au()) && clientPlayer.func_152122_n() && clientPlayer.func_110303_q() == null) {
            NetworkPlayerInfo playerInfo = (NetworkPlayerInfo)ObfuscationReflectionHelper.getPrivateValue(AbstractClientPlayer.class, (Object)clientPlayer, (int)0);
            Map playerTextures = (Map)ObfuscationReflectionHelper.getPrivateValue(NetworkPlayerInfo.class, (Object)playerInfo, (int)1);
            playerTextures.put(MinecraftProfileTexture.Type.CAPE, GTFO_CAPE_TEXTURE);
        }
    }

    @SubscribeEvent
    public static void removeOtherPlayerMessages(ClientChatReceivedEvent event) {
        if (Minecraft.func_71410_x().field_71439_g.func_70644_a((Potion)AntiSchizoPotion.INSTANCE) && event.getType() == ChatType.CHAT) {
            TextComponentString nameString;
            TextComponentString nameWrapperString;
            TextComponentTranslation chatMessage;
            Object object = event.getMessage();
            if (object instanceof TextComponentTranslation && (object = (chatMessage = (TextComponentTranslation)object).func_150271_j()[0]) instanceof TextComponentString && (object = (nameWrapperString = (TextComponentString)object).func_150253_a().get(0)) instanceof TextComponentString && (nameString = (TextComponentString)object).func_150265_g().equals(Minecraft.func_71410_x().field_71439_g.func_70005_c_())) {
                return;
            }
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onPotionApplied(PotionEvent.PotionAddedEvent event) {
        if (event.getPotionEffect().func_188419_a() == AntiSchizoPotion.INSTANCE && event.getEntity().func_70028_i((Entity)Minecraft.func_71410_x().field_71439_g)) {
            Minecraft.func_71410_x().field_71456_v.func_146158_b().func_146231_a(true);
        }
    }
}

